<?php while ( have_posts() ) : the_post(); 

$maco_client_name 	= get_field('client_name');
$maco_portfolio_year = get_field('portfolio_year');
$maco_project_url 	= get_field('project_url');

$maco_portfolio_gallery = get_field('maco_gallery'); ?>

<div class="single-porto-inner-wrap portfolio-chocolat portfolio-style1">

	<div class="container">

		<?php
		if ( has_post_format('gallery') ) {
			if($maco_portfolio_gallery == 0){ ?>
			<div class="portfolio-thumbnail clearfix">
				<?php $maco_porto_thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full'); ?>
				<a class="chocolat-image" title="<?php the_title(); ?>" href="<?php echo esc_url( $maco_porto_thumb[0] ); ?>">
					<img src="<?php echo esc_url( $maco_porto_thumb[0] ); ?>" alt="<?php the_title(); ?>">
				</a>
			</div>
			<?php }
			else {

			$maco_force_crop 	= get_field('force_crop');
			$maco_item_per_row 	= get_field('item_per_row');
			$maco_gallery_width 	= get_field('gallery_width');
			$maco_gallery_height = get_field('gallery_height');

			$maco_vertical_gap 	= get_field('vertical_gap');
			if(!empty($maco_vertical_gap)) {
				$maco_vertical_gap_res = $maco_vertical_gap;
			}
			else {
				$maco_vertical_gap_res = '0';
			}

			$maco_horizontal_gap = get_field('horizontal_gap');
			if(!empty($maco_horizontal_gap)) {
				$maco_horizontal_gap_res = $maco_horizontal_gap;
			}
			else {
				$maco_horizontal_gap_res = '0';
			}

			$maco_gap_calc = $maco_vertical_gap_res + $maco_horizontal_gap_res;

			?>
			<div class="portfolio-thumbnail gallery-type clearfix">
				<?php
				foreach( $maco_portfolio_gallery as $porto_gal2 ):

				$maco_portgal_def_wid = $porto_gal2["width"];
				$maco_portgal_def_hei = $porto_gal2["height"];

				if(!empty($maco_gallery_width)) {
					$maco_portgal_wid = $maco_gallery_width;
				}
				else {
					$maco_portgal_wid = $maco_portgal_def_wid;
				}

				if(!empty($maco_gallery_height)) {
					$maco_portgal_hei = $maco_gallery_height;
				}
				else {
					$maco_portgal_hei = $maco_portgal_def_hei;
				}

				$porto_gal_res = aq_resize($porto_gal2['url'],  $maco_portgal_wid , $maco_portgal_hei, $maco_force_crop, true, true);

				$attachment_id = $porto_gal2['ID'];
				$foto_name = $porto_gal2['title']; ?>
				<div class="item" style="width: calc(100% / <?php echo esc_attr($maco_item_per_row) ?> - <?php echo esc_attr ($maco_gap_calc); ?>px); padding: <?php echo esc_attr($maco_vertical_gap_res); ?>px <?php echo esc_attr($maco_horizontal_gap_res); ?>px">
					<a class="chocolat-image" title="<?php echo esc_attr( $foto_name ); ?>" href="<?php echo esc_url( $porto_gal2['url'] ); ?>">
						<img src="<?php echo esc_url( $porto_gal_res ); ?>" alt="<?php echo esc_attr( $porto_gal2['alt'] ); ?>" /> 
					</a> 
				</div>
				<?php endforeach; ?>
			</div>
			<?php }
		}
		if ( has_post_format('video') ) { ?>
			<div class="featured-video clearfix">
				<?php 
					$video_url = get_field('video_url');
					$video_embed = get_field('video_embed');
					$video_file = get_field('video_file');
					
					if($video_url !== ''){ 
						echo wp_oembed_get( esc_url( $video_url ));
					} 

					elseif($video_embed !== '') { 
						echo wp_specialchars_decode( $video_embed );
					}

					elseif($video_file !== '') {  ?>
					<?php echo do_shortcode( '[video src="'. esc_url( $video_file ).'"]' ) ?>  
				<?php } ?>
			</div>
		<?php }
		if ( !get_post_format() ) { ?>
			<div class="portfolio-thumbnail clearfix">
				<?php $maco_porto_thumb = wp_get_attachment_image_src( get_post_thumbnail_id(), 'full'); ?>
				<a class="chocolat-image" title="<?php the_title(); ?>" href="<?php echo esc_url( $maco_porto_thumb[0] ); ?>">
					<img src="<?php echo esc_url( $maco_porto_thumb[0] ); ?>" alt="<?php the_title(); ?>">
				</a>
			</div>
		<?php } ?>

		<div class="porfolio-content-wrap clearfix">
			<?php 
				$category_name = array();
				$category_slugs = array();
				$category_terms = wp_get_object_terms($post->ID, 'portfolio-category');
				if(!empty($category_terms)){
					if(!is_wp_error( $category_terms )){
					$category_slugs = array();
						foreach($category_terms as $term){
							$category_name[] = $term->name;
							$category_slugs[] = $term->slug;
						}

					$maco_porto_comas =  join( ", ", $category_name );
					$maco_porto_space =  join( " ", $category_slugs );

					}
				}
			?>
			<?php if(have_rows('portfolio_details')) { ?>
				<div class="project-details column column-3 clearfix">
					<div class="category-portfolio">
						<span class="category"><?php echo esc_html($maco_porto_comas); ?></span>
					</div>
					<div class="page-title">
						<h2><?php the_title(); ?></h2>
					</div>

					<ul>
						<?php while(have_rows('portfolio_details')):the_row(); 
							$detail_name	= get_sub_field('detail_name');
							$detail_text	= get_sub_field('detail_text');
						?>
						<li>
							<p><span><?php echo esc_html( $detail_name ); ?></span><?php echo esc_html( $detail_text ); ?></p>
						</li>
						<?php endwhile; ?>
					</ul>
				</div>

				<div class="portfolio-content column column-2of3 clearfix">
					<?php the_content(); ?>
				</div>
			<?php }
			else { ?>
				<div class="project-details column column-3 clearfix">
					<div class="category-portfolio">
						<span class="category"><?php echo esc_html($maco_porto_comas); ?></span>
					</div>
					<div class="page-title">
						<h2><?php the_title(); ?></h2>
					</div>
				</div>

				<div class="portfolio-content column column-2of3 clearfix">
					<?php the_content(); ?>
				</div>
			<?php } ?>
		</div>

		<div class="portfolio-pagination clearfix">
			<?php $next_post = get_next_post();
			$previous_post = get_previous_post(); ?>

			<div class="prev-portfolio column column-3">
				<h3>
				<?php if ( get_previous_post() ) : ?>
					<a href="<?php echo get_permalink( $previous_post->ID ); ?>"><?php esc_html_e( 'Prev', 'maco' ); ?></a>
				</h3>
				<?php endif; ?>
			</div>

			<div class="all-portfolio column column-3">
				<h3>
				<?php if(class_exists( 'Redux' )) {
				$options						= get_option('maco_framework');
				$maco_portfolio_back_link	= $options['portfolio_back_link']; 
				if(!empty($maco_portfolio_back_link)) { 

					$page_back = new WP_Query( array( 'page_id' => $maco_portfolio_back_link ) );
					if ($page_back->have_posts()) : while($page_back->have_posts()) : $page_back->the_post();
					?>
					<a href="<?php the_permalink(); ?>"><?php esc_html_e( 'Back', 'maco' ); ?></a>
				<?php 
					endwhile; endif; wp_reset_postdata();
					}
				} ?>
				</h3>
			</div>

			<div class="next-portfolio column column-3">
				<h3>
				<?php if ( get_next_post() ) : ?>
					<a href="<?php echo get_permalink( $next_post->ID ); ?>"><?php esc_html_e( 'Next', 'maco' ); ?></a>
				</h3>
				<?php endif; ?>
			</div>
		</div>
		
	</div>
</div>

<?php endwhile; // end of the loop. ?>