/*
*
*	Live Customiser Script
*	------------------------------------------------
	*	Themes Awesome Framework
	* 	Copyright Maco 2018 - http://www.themesawesome.com
*
*/
( function( $ ){

	'use strict';

	/* ======================== HEADER SECTION ======================== */
			
	// HEADER STYLING

	wp.customize('menu_header',function( value ) {
		value.bind(function(to) {
			$('.header-style-1-wrap .main-menu ul.sm-clean>li>a, .header-style-1-wrap .main-menu ul.sm-clean>li>a:active, .header-style-1-wrap .search-wrap #btn-search i, .header-style-1-wrap .main-menu ul.sm-clean>li.current-menu-item>a, .header-style-1-wrap .main-menu ul.sm-clean>li>a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('menu_header',function( value ) {
		value.bind(function(to) {
			$('.sm-clean a span.sub-arrow').css('border-top-color', to ? to : '' );
		});
	});

	wp.customize('menu_hover_header',function( value ) {
		value.bind(function(to) {
			$('.header-style-1-wrap .main-menu ul.sm-clean>li>a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('menu_border',function( value ) {
		value.bind(function(to) {
			$('.header-style-1-wrap .main-menu ul.sm-clean>li>a::before, .header-style-1-wrap .main-menu ul.sm-clean>li.current-menu-item>a::before').css('background-color', to ? to : '' );
		});
	});

	wp.customize('sub_bg',function( value ) {
		value.bind(function(to) {
			$('.header-style-1-wrap ul.sm-clean ul').css('background-color', to ? to : '' );
		});
	});

	wp.customize('sub_menu',function( value ) {
		value.bind(function(to) {
			$('.header-style-1-wrap ul.sm-clean ul li a').css('color', to ? to : '' );
		});
	});

	wp.customize('search_close',function( value ) {
		value.bind(function(to) {
			$('.header-style-1 .btn--search-close').css('color', to ? to : '' );
		});
	});

	wp.customize('search_bar_title',function( value ) {
		value.bind(function(to) {
			$('.header-style-1 .search__info').css('color', to ? to : '' );
		});
	});

	wp.customize('search_sugges',function( value ) {
		value.bind(function(to) {
			$('.header-style-1 .search__suggestion h4').css('color', to ? to : '' );
			$('.header-style-1 .search__suggestion h4::before').css('background-color', to ? to : '' );
		});
	});

	wp.customize('search_desc_sugges',function( value ) {
		value.bind(function(to) {
			$('.header-style-1 .search__suggestion p').css('color', to ? to : '' );
		});
	});

	wp.customize('search_bord',function( value ) {
		value.bind(function(to) {
			$('.header-style-1 .search__input').css('color', to ? to : '' );
		});
	});

	wp.customize('header_bg_btn',function( value ) {
		value.bind(function(to) {
			$('#header .header-info-url a').css('background-color', to ? to : '' );
		});
	});

	wp.customize('header_bg_btn_hover',function( value ) {
		value.bind(function(to) {
			$('#header .header-info-url a:hover').css('background-color', to ? to : '' );
		});
	});

	wp.customize('header_text_btn',function( value ) {
		value.bind(function(to) {
			$('#header .header-info-url a').css('color', to ? to : '' );
		});
	});

	wp.customize('header_text_btn_hover',function( value ) {
		value.bind(function(to) {
			$('#header .header-info-url a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('header_info_text',function( value ) {
		value.bind(function(to) {
			$('#header .head-info-text span').css('color', to ? to : '' );
		});
	});

	wp.customize('header_info_icon',function( value ) {
		value.bind(function(to) {
			$('.header-style-1-wrap .info-wrap i').css('color', to ? to : '' );
		});
	});


	// HEADER ALTERNATIVE STYLING

	wp.customize('alt_menu_hover',function( value ) {
		value.bind(function(to) {
			$('body .alt-head .main-menu ul.sm-clean>li>a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('alt_menu_border',function( value ) {
		value.bind(function(to) {
			$('body .alt-head .main-menu ul.sm-clean>li>a::before, body .alt-head .main-menu ul.sm-clean>li.current-menu-item>a::before').css('background-color', to ? to : '' );
		});
	});

	wp.customize('alt_bg_btn',function( value ) {
		value.bind(function(to) {
			$('#header.alt-head .header-info-url a').css('background-color', to ? to : '' );
		});
	});

	wp.customize('alt_bg_btn_hover',function( value ) {
		value.bind(function(to) {
			$('#header.alt-head .header-info-url a:hover').css('background-color', to ? to : '' );
		});
	});

	wp.customize('alt_text_btn',function( value ) {
		value.bind(function(to) {
			$('#header.alt-head .header-info-url a').css('color', to ? to : '' );
		});
	});

	wp.customize('alt_text_btn_hover',function( value ) {
		value.bind(function(to) {
			$('#header.alt-head .header-info-url a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('alt_info_text',function( value ) {
		value.bind(function(to) {
			$('#header.alt-head .head-info-text span').css('color', to ? to : '' );
		});
	});

	wp.customize('alt_info_icon',function( value ) {
		value.bind(function(to) {
			$('#header.alt-head .info-wrap i').css('color', to ? to : '' );
		});
	});



	/* ======================== CONTENT SECTION ======================== */

	// BLOG

	wp.customize('post_meta',function( value ) {
		value.bind(function(to) {
			$('.loop-post-head .meta-info .date a, .single-post-head .meta-info .date a, .loop-post-head .meta-info .date span, .single-post-head .meta-info .date span, .loop-post-head .the-post-head .meta-info .span-head:after, .single-post-head .the-post-head .meta-info .span-head:after, .loop-post-head .meta-info .author span, .single-post-head .meta-info .author span, .loop-post-head .meta-info .vcard a, .single-post-head .meta-info .vcard a, .single-post-head .category-text, .single-post-head .meta-info .span-head:after, .the-post-head .meta-info .span-head:after').css('color', to ? to : '' );
		});
	});

	wp.customize('post_meta_hover',function( value ) {
		value.bind(function(to) {
			$('.post-content .date a:hover, .loop-post-head .meta-info .date span:hover, .single-post-head .meta-info .date span:hover, .post-content .meta-info .vcard a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('category_bg',function( value ) {
		value.bind(function(to) {
			$('.the-post-head .standard-post-categories a').css('background-color', to ? to : '' );
		});
	});

	wp.customize('category_bg_hover',function( value ) {
		value.bind(function(to) {
			$('.the-post-head .standard-post-categories a:hover').css('background-color', to ? to : '' );
		});
	});

	wp.customize('category_text',function( value ) {
		value.bind(function(to) {
			$('.the-post-head .standard-post-categories a').css('color', to ? to : '' );
		});
	});

	wp.customize('category_text_hover',function( value ) {
		value.bind(function(to) {
			$('.the-post-head .standard-post-categories a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('post_title',function( value ) {
		value.bind(function(to) {
			$('.post-content h2.post-title a, .post-content h1.post-title a').css('color', to ? to : '' );
		});
	});

	wp.customize('post_hover_title',function( value ) {
		value.bind(function(to) {
			$('.post-content h2.post-title a:hover, .post-content h1.post-title a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('post_desc',function( value ) {
		value.bind(function(to) {
			$('.post-content .post-text p, .comment-content p').css('color', to ? to : '' );
		});
	});

	wp.customize('read_more',function( value ) {
		value.bind(function(to) {
			$('.post-content a.read-more').css('color', to ? to : '' );
		});
	});

	wp.customize('read_hover_more',function( value ) {
		value.bind(function(to) {
			$('.post-content a.read-more:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('read_more_border',function( value ) {
		value.bind(function(to) {
			$('.blog-item .read-more').css('border-color', to ? to : '' );
		});
	});

	wp.customize('read_more_hover_border',function( value ) {
		value.bind(function(to) {
			$('.blog-item .read-more:hover').css('border-color', to ? to : '' );
		});
	});

	wp.customize('read_more_hover_bg',function( value ) {
		value.bind(function(to) {
			$('.blog-item .read-more:hover').css('background-color', to ? to : '' );
		});
	});



	// SINGLE BLOG

	wp.customize('title_single',function( value ) {
		value.bind(function(to) {
			$('.single-post-head .post-title').css('color', to ? to : '' );
		});
	});

	wp.customize('text_single',function( value ) {
		value.bind(function(to) {
			$('.blog-single .post-content .post-text p, .comment-content p').css('color', to ? to : '' );
		});
	});

	wp.customize('text_quote',function( value ) {
		value.bind(function(to) {
			$('.blog-single .post-content .post-text blockquote p').css('color', to ? to : '' );
		});
	});

	wp.customize('quote_icon',function( value ) {
		value.bind(function(to) {
			$('.post-text blockquote::after').css('color', to ? to : '' );
		});
	});

	wp.customize('tag_text',function( value ) {
		value.bind(function(to) {
			$('.blog-single .tag-wrapper a').css('color', to ? to : '' );
		});
	});

	wp.customize('tag_hover',function( value ) {
		value.bind(function(to) {
			$('.blog-single .tag-wrapper a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('tag_bg',function( value ) {
		value.bind(function(to) {
			$('.blog-single .tag-wrapper a').css('background-color', to ? to : '' );
		});
	});

	wp.customize('tag_bg_hover',function( value ) {
		value.bind(function(to) {
			$('.blog-single .tag-wrapper a:hover').css('background-color', to ? to : '' );
		});
	});

	wp.customize('meta_bg',function( value ) {
		value.bind(function(to) {
			$('.blog-single .post-author, .blog-single .post-content, .comments-area, .next-prev-post, .blog-single .post-author').css('background-color', to ? to : '' );
		});
	});

	wp.customize('left_border',function( value ) {
		value.bind(function(to) {
			$('.blog-single .post-author').css('border-top-color', to ? to : '' );
		});
	});

	wp.customize('meta_title',function( value ) {
		value.bind(function(to) {
			$('.meta-content-bottom .meta-title').css('color', to ? to : '' );
		});
	});

	wp.customize('meta_link',function( value ) {
		value.bind(function(to) {
			$('.author-meta a, .meta-content-bottom .date-meta, .next-prev-post h4.title').css('color', to ? to : '' );
		});
	});

	wp.customize('meta_link_hover',function( value ) {
		value.bind(function(to) {
			$('.author-meta a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('prev_bord',function( value ) {
		value.bind(function(to) {
			$('.blog-single .post-author').css('border-top-color', to ? to : '' );
			$('.blog-single .post-content, .comment-list').css('border-bottom-color', to ? to : '' );
			$('.blog-single .next-prev-post .inner-nav, .comments-area, textarea').css('border-color', to ? to : '' );
		});
	});

	wp.customize('prev_bg',function( value ) {
		value.bind(function(to) {
			$('.blog-single .next-prev-post .inner-nav').css('background-color', to ? to : '' );
		});
	});

	wp.customize('prev_link',function( value ) {
		value.bind(function(to) {
			$('.blog-single .next-prev-post .prev-post a:hover > .the-nav-title, .blog-single .next-prev-post span.the-nav-link').css('color', to ? to : '' );
		});
	});

	wp.customize('prev_hover_link',function( value ) {
		value.bind(function(to) {
			$('.blog-single .next-prev-post .prev-post a > .the-nav-title, .blog-single .next-prev-post span').css('color', to ? to : '' );
		});
	});

	wp.customize('comment_title',function( value ) {
		value.bind(function(to) {
			$('.comment-respond h3.comment-reply-title, .comments-title h3').css('color', to ? to : '' );
		});
	});

	wp.customize('comment_link',function( value ) {
		value.bind(function(to) {
			$('.comment-respond form p.logged-in-as a, .comment-respond form p.logged-in-as, .comment-action a').css('color', to ? to : '' );
		});
	});

	wp.customize('comment_hover_link',function( value ) {
		value.bind(function(to) {
			$('.comment-respond form p.logged-in-as a:hover, .comment-action a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('btn_comment_bg',function( value ) {
		value.bind(function(to) {
			$('.comment-respond form p.form-submit input').css('background-color', to ? to : '' );
		});
	});

	wp.customize('btn_comment_bg_hover',function( value ) {
		value.bind(function(to) {
			$('.comment-respond form p.form-submit input:hover, .contact-form-style-1 .wpcf7-submit:hover, .contact-form-style-2 .wpcf7-submit:hover').css('background-color', to ? to : '' );
		});
	});

	wp.customize('btn_comment_text',function( value ) {
		value.bind(function(to) {
			$('.comment-respond form p.form-submit input').css('color', to ? to : '' );
		});
	});

	wp.customize('next_archive',function( value ) {
		value.bind(function(to) {
			$('.archive .post-navigation .btn, .search-page .post-navigation .btn').css('color', to ? to : '' );
		});
	});


	// SIDEBAR & WIDGET

	wp.customize('sidebar_search_bg',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget.widget_search input').css('background-color', to ? to : '' );
		});
	});

	wp.customize('sidebar_search_btn',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget.widget_search button').css('background-color', to ? to : '' );
			$('.sidebar .widget.widget_search button').css('border-color', to ? to : '' );
		});
	});

	wp.customize('sidebar_search_icon',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget.widget_search button i').css('color', to ? to : '' );
		});
	});

	wp.customize('sidebar_search_text',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget.widget_search input').css('color', to ? to : '' );
		});
	});

	wp.customize('sidebar_bg',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget').css('background-color', to ? to : '' );
		});
	});

	wp.customize('sidebar_border',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget').css('border-color', to ? to : '' );
		});
	});

	wp.customize('maco_widget_title',function( value ) {
		value.bind(function(to) {
			$('.sidebar .widget h4.widget-title').css('color', to ? to : '' );
		});
	});

	wp.customize('link_text_sidebar',function( value ) {
		value.bind(function(to) {
			$('.sidebar #recent-posts-2 ul li a, .sidebar .widget .recent-news .post-content h5 a, .sidebar #recent-comments-2 ul li a, li.recentcomments, .sidebar #archives-2 ul li a, .sidebar #categories-2 ul li a, .sidebar #meta-2 ul li a, .latest-post-wrap h5 a, .latest-post-wrap .post-content h5').css('color', to ? to : '' );
		});
	});

	wp.customize('link_hover_sidebar',function( value ) {
		value.bind(function(to) {
			$('.sidebar #recent-posts-2 ul li a:hover, .sidebar .widget .recent-news .post-content h5 a:hover, .sidebar #recent-comments-2 ul li a:hover, li.recentcomments:hover, .sidebar #archives-2 ul li a:hover, .sidebar #categories-2 ul li a:hover, .sidebar #meta-2 ul li a:hover, .latest-post-wrap h5 a:hover, .latest-post-wrap .post-content h5:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('bg_tabs',function( value ) {
		value.bind(function(to) {
			$('.widget.widget_maco_news .nav-tabs li.active, .widget.widget_maco_news .post-item:before').css('background-color', to ? to : '' );
		});
	});

	wp.customize('text_tabs',function( value ) {
		value.bind(function(to) {
			$('.widget.widget_maco_news .nav-tabs li.active a, .widget.widget_maco_news .post-item:before').css('color', to ? to : '' );
		});
	});

	wp.customize('bg_tabs2',function( value ) {
		value.bind(function(to) {
			$('.widget.widget_maco_news .nav-tabs li').css('background-color', to ? to : '' );
		});
	});

	wp.customize('text_tabs2',function( value ) {
		value.bind(function(to) {
			$('.widget.widget_maco_news .nav-tabs li a').css('color', to ? to : '' );
		});
	});

	wp.customize('text_tabs2_hover',function( value ) {
		value.bind(function(to) {
			$('.widget.widget_maco_news .nav-tabs li a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('border_tabs',function( value ) {
		value.bind(function(to) {
			$('.widget.widget_maco_news .nav-tabs').css('border-bottom-color', to ? to : '' );
		});
	});


	// CONTACT

	wp.customize('form_bord',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-2 .contact-item2:before, .contact-ef .border-form-top, .contact-ef').css('background-color', to ? to : '' );
		});
	});

	wp.customize('form_bord_hover',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-2 .contact-item2:after').css('background-color', to ? to : '' );
		});
	});

	wp.customize('text_input',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-1 .contact-bordered input, .contact-form-style-2 .contact-item2 input, .contact-bordered.text-area textarea, .contact-form-style-2 .contact-item2 textarea').css('color', to ? to : '' );
		});
	});

	wp.customize('btn_send',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-1 input.wpcf7-submit, .contact-form-style-2 input.wpcf7-submit').css('background-color', to ? to : '' );
		});
	});

	wp.customize('btn_send_text',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-1 input.wpcf7-submit, .contact-form-style-2 input.wpcf7-submit').css('color', to ? to : '' );
		});
	});

	wp.customize('btn_send_hover',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-1 input.wpcf7-submit:hover, .contact-form-style-2 input.wpcf7-submit:hover').css('background-color', to ? to : '' );
		});
	});

	wp.customize('btn_send_text_hover',function( value ) {
		value.bind(function(to) {
			$('.contact-form-style-1 input.wpcf7-submit:hover, .contact-form-style-2 input.wpcf7-submit:hover').css('color', to ? to : '' );
		});
	});


	/* ======================== PORTFOLIO SECTION ======================== */

	// PORTFOLIO SINGLE

	wp.customize('port_title',function( value ) {
		value.bind(function(to) {
			$('.header-style-1 .page-title h2, .post-title-porto-2 h1').css('color', to ? to : '' );
		});
	});

	wp.customize('category_portfolio',function( value ) {
		value.bind(function(to) {
			$('.portfolio-style1 span.category, .post-title-porto-2 span.category').css('color', to ? to : '' );
		});
	});

	wp.customize('detail1_title',function( value ) {
		value.bind(function(to) {
			$('.portfolio-style1 .project-details ul li span, .portfolio-details .detail-title').css('color', to ? to : '' );
		});
	});

	wp.customize('detail1_p',function( value ) {
		value.bind(function(to) {
			$('.portfolio-style1 .project-details ul li p, .portfolio-details .detail-info').css('color', to ? to : '' );
		});
	});

	wp.customize('detail1_border',function( value ) {
		value.bind(function(to) {
			$('.portfolio-style1 .project-details ul li, .portfolio-details .detail-item').css('border-bottom-color', to ? to : '' );
		});
	});

	wp.customize('detail1_desc',function( value ) {
		value.bind(function(to) {
			$('.portfolio-content p').css('color', to ? to : '' );
		});
	});

	wp.customize('detail1_pagination',function( value ) {
		value.bind(function(to) {
			$('.portfolio-style1 .portfolio-pagination .prev-portfolio a, .portfolio-style1 .portfolio-pagination .all-portfolio a, .portfolio-style1 .portfolio-pagination .next-portfolio a').css('color', to ? to : '' );
		});
	});

	wp.customize('detail1_hov_pagination',function( value ) {
		value.bind(function(to) {
			$('.portfolio-style1 .portfolio-pagination a:hover').css('color', to ? to : '' );
		});
	});



	/* ======================== FOOTER SECTION ======================== */

	// FOOTER

	wp.customize('footer_text',function( value ) {
		value.bind(function(to) {
			$('.copyright-text, .footer-text-area, #footer.no-redux p, #footer.no-redux a').css('color', to ? to : '' );
		});
	});

	wp.customize('footer_link',function( value ) {
		value.bind(function(to) {
			$('.copyright-text a, .footer-menu li a').css('color', to ? to : '' );
		});
	});

	wp.customize('footer_hover_link',function( value ) {
		value.bind(function(to) {
			$('.copyright-text a:hover, .footer-menu li a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('footer_social',function( value ) {
		value.bind(function(to) {
			$('.footer-bottom .social-footer ul li a').css('color', to ? to : '' );
		});
	});

	wp.customize('footer_hover_social',function( value ) {
		value.bind(function(to) {
			$('.footer-bottom .social-footer ul li a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('footer_widget_bg',function( value ) {
		value.bind(function(to) {
			$('.footer-widget-wrapper').css('background-color', to ? to : '' );
		});
	});

	wp.customize('footer_widget_title',function( value ) {
		value.bind(function(to) {
			$('.footer-widget .widget-footer h4.widget-title').css('color', to ? to : '' );
		});
	});

	wp.customize('footer_wgtitle_separator',function( value ) {
		value.bind(function(to) {
			$('.footer-widget .widget-footer h4.widget-title:after').css('background-color', to ? to : '' );
		});
	});

	wp.customize('link_text_widget',function( value ) {
		value.bind(function(to) {
			$('.footer-widget .widget-footer .latest-post-widget a, .latest-post-wrap h5, .footer-widget .widget_nav_menu ul li a, .footer-widget .widget-footer a, .footer-widget .meta-latest-news span, .footer-widget .meta-latest-news a, .footer-widget .meta-latest-news a span, .footer-widget .date span, .footer-widget .date a').css('color', to ? to : '' );
		});
	});

	wp.customize('link_hover_widget',function( value ) {
		value.bind(function(to) {
			$('.footer-widget .widget-footer .latest-post-widget a:hover, .footer-widget .widget_nav_menu ul li a:hover, .footer-widget .widget-footer a:hover, .footer-widget .date a:hover').css('color', to ? to : '' );
		});
	});

	wp.customize('text_widget',function( value ) {
		value.bind(function(to) {
			$('.footer-widget .textwidget').css('color', to ? to : '' );
		});
	});

	wp.customize('border_widget',function( value ) {
		value.bind(function(to) {
			$('.footer-widget .widget_nav_menu ul li a:before, .latest-post-wrap .post-content, .footer-widget .widget_nav_menu ul li a:before').css('border-bottom-color', to ? to : '' );
		});
	});

	wp.customize('border_search_footer',function( value ) {
		value.bind(function(to) {
			$('#footer .widget-footer.widget_search input').css('border-color', to ? to : '' );
			$('#footer .widget-footer.widget_search button').css('background-color', to ? to : '' );
		});
	});

	wp.customize('input_search_footer',function( value ) {
		value.bind(function(to) {
			$('#footer .widget-footer.widget_search input').css('color', to ? to : '' );
		});
	});




} )( jQuery );