<?php if(!defined('ABSPATH')){ exit; }

add_action('admin_menu', function(){
	add_theme_page(
		esc_html__('TA Licenser', 'maco'), 
		esc_html__('TA Licenser', 'maco'), 
		'manage_options', 
		'ta-licensebox', 
		'ta_licensebox_theme_page' 
	);
});

function ta_licensebox_theme_page(){
	global $maco_lbapi;
	global $maco_lb_verify_res;
	$lb_activate_res = null;
	$lb_deactivate_res = null;
	if(!empty($_POST['client_name'])&&!empty($_POST['license_code'])){
		check_admin_referer('lb_update_license', 'lb_update_license_sec');
		$lb_activate_res = $maco_lbapi->activate_license(
			strip_tags(trim($_POST['license_code'])), 
			strip_tags(trim($_POST['client_name']))
		);
		$maco_lb_verify_res = $maco_lbapi->verify_license();

		$maco_lb_verify_res_a = array(
			'status' => true,
		);
		update_option( 'maco_lb_verify_res', $maco_lb_verify_res_a );
	}
	if(!empty($_POST['lb_deactivate'])){
		check_admin_referer('lb_deactivate_license', 'lb_deactivate_license_sec');
		$lb_deactivate_res = $maco_lbapi->deactivate_license();
		$maco_lb_verify_res = $maco_lbapi->verify_license();

		$maco_lb_verify_res_a = array(
			'status' => false,
		);
		update_option( 'maco_lb_verify_res', $maco_lb_verify_res_a );
	}
	$lb_update_data = $maco_lbapi->check_update(); ?>

	<div class="wrap">
		<h1><?php esc_html_e('TA Licenser', 'maco'); ?></h1>
		<?php if($maco_lb_verify_res['status']){ ?> 
			<div class="notice notice-info">
				<p><?php esc_html_e('Activated! Your license is valid.', 'maco'); ?></p>
			</div> 
		<?php }else{ ?> 
			<div class="notice notice-error">
				<p><?php echo (!empty($lb_activate_res['message']))?$lb_activate_res['message']:esc_html__('No license has been provided yet or the provided license is invalid.', 'maco') ?></p>
			</div> 
		<?php }?>
		<form action="" method="post">
			<?php wp_nonce_field('lb_update_license', 'lb_update_license_sec'); ?>
			<table>   
				<tr>
					<th><?php esc_html_e('License code', 'maco'); ?></th>
					<td>
						<input type="text" name="license_code" size="50" placeholder="<?php 
						if($maco_lb_verify_res['status']){
							echo esc_attr__('Enter the license code here to update', 'maco');
						}else{
							echo esc_attr__('Enter the license code here', 'maco');
						} ?>" required>
					</td>
				</tr>
				<tr>
					<th><?php esc_html_e('Envato Username', 'maco'); ?></th>
					<td>
						<input type="text" name="client_name" size="50" placeholder="<?php 
						if($maco_lb_verify_res['status']){
							echo esc_html__('Enter your Envato username here to update', 'maco');
						}else{
							echo esc_html__('Enter your Envato username here', 'maco');
						} ?>" required>
					</td>
				</tr>    
				<tr>
					<td>
						<div style="padding-top: 10px;">
							<input type="submit" value="Activate" class="button button-primary">
						</div>
					</td>
				</tr>
			</table>

			<div style="margin-top: 10px;">
				<p><?php echo esc_html__('How to get purchase code?', 'maco'); ?></p>
				<a class="btn btn-sm" href="<?php echo esc_url("https://help.market.envato.com/hc/en-us/articles/202822600-Where-Is-My-Purchase-Code-"); ?>"><?php echo esc_html__('Click Here!', 'maco'); ?></a>
			</div>
		</form>
		<?php if($maco_lb_verify_res['status']){ ?>
			<h2 class="title" style="padding-top:10px;"><?php esc_html_e('Deactivate License', 'maco'); ?></h2>
			<p style="max-width: 450px;">
				<?php esc_html_e('If you wish to use this license for activating theme on a different server, you can first release your license from this server by deactivating it below.', 'maco'); ?>
			</p>
			<?php if(empty($lb_deactivate_res)){ ?>
				<form action="" method="post">
					<?php wp_nonce_field('lb_deactivate_license', 'lb_deactivate_license_sec'); ?>
					<input type="hidden" name="lb_deactivate" value="yes">
					<input type="submit" value="Deactivate" class="button">
				</form>
			<?php } ?>
		<?php } ?>
		<?php if($maco_lb_verify_res['status']){ ?>
			<h2 class="title" style="padding-top:10px;"><?php esc_html_e('Plugin Updates', 'maco'); ?></h2>
			<p>
				<strong><?php echo esc_html($lb_update_data['message']); ?></strong>
			</p>
			<?php if($lb_update_data['status']){ ?>
				<p style="max-width: 700px;"><?php esc_html_e('Changelog: ', 'maco'); ?>
					<?php echo strip_tags($lb_update_data['changelog'], '<ol><ul><li><i><b><strong><p><br><a><blockquote>'); ?>
				</p>
				<?php if(!empty($_POST['update_id'])){
					check_admin_referer('lb_update_download', 'lb_update_download_sec');
					$maco_lbapi->download_update(
						strip_tags(trim($_POST['update_id'])), 
						strip_tags(trim($_POST['has_sql'])), 
						strip_tags(trim($_POST['version']))
					);
					if (false !== get_transient('licensebox_next_update_check')) {
						delete_transient('licensebox_next_update_check');
					}
				?>
				<?php }else{ ?>
					<form action="" method="POST">
						<?php wp_nonce_field('lb_update_download', 'lb_update_download_sec'); ?>
						<input type="hidden" value="<?php echo esc_attr($lb_update_data['update_id']); ?>" name="update_id">
						<input type="hidden" value="<?php echo esc_attr($lb_update_data['has_sql']); ?>" name="has_sql">
						<input type="hidden" value="<?php echo esc_attr($lb_update_data['version']); ?>" name="version">
						<div style="padding-top: 10px;">
							<input type="submit" value="Download and Install Update" class="button button-secondary">
						</div>
					</form>
				<?php } ?>
			<?php } ?>
		<?php } ?>
	</div>
<?php }
