<?php

	/*=====================================================================================================*/
	// Set Panel ID
	/*=====================================================================================================*/
	$panel_id_1 = 'maco_header_section';

	$wp_customize->add_panel( $panel_id_1,
	    array(
	        'priority'          => 199,
	        'capability'        => 'edit_theme_options',
	        'theme_supports'    => '',
	        'title'             => esc_html__( 'Header Section Color', 'maco' ),
	        'description'       => esc_html__( 'Edit your header color here.', 'maco' ),
	    )
	);

	/* HEADER STYLING
	================================================== */
	
	$wp_customize->add_section( 'header_default_styling', array(
		'title'		=>	esc_html__( 'Header Default', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );
	
	//SECTION

	$wp_customize->add_setting( 'menu_header', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'menu_hover_header', array(
		'default'		=> 	'#111111',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'menu_border', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sub_bg', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sub_menu', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'search_close', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'search_bar_title', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'search_sugges', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'search_desc_sugges', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'search_bord', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'header_bg_btn', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'header_bg_btn_hover', array(
		'default'		=> 	'#cc4141',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'header_text_btn', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'header_text_btn_hover', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'header_info_text', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'header_info_icon', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'menu_header', array(
		'label'		=>	esc_html__( 'Menu & Search Icon Header Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'menu_header',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'menu_hover_header', array(
		'label'		=>	esc_html__( 'Menu Header Hover Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'menu_hover_header',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'menu_border', array(
		'label'		=>	esc_html__( 'Menu Header Border Hover Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'menu_border',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sub_bg', array(
		'label'		=>	esc_html__( 'Submenu Background Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'sub_bg',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sub_menu', array(
		'label'		=>	esc_html__( 'Submenu Text Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'sub_menu',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'search_close', array(
		'label'		=>	esc_html__( 'Button Search Close Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'search_close',
		'priority'	=>	7,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'search_bar_title', array(
		'label'		=>	esc_html__( 'Search Bar Title Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'search_bar_title',
		'priority'	=>	8,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'search_sugges', array(
		'label'		=>	esc_html__( 'Search Suggestion Title Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'search_sugges',
		'priority'	=>	9,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'search_desc_sugges', array(
		'label'		=>	esc_html__( 'Search Suggestion Description Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'search_desc_sugges',
		'priority'	=>	10,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'search_bord', array(
		'label'		=>	esc_html__( 'Search Border Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'search_bord',
		'priority'	=>	11,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_bg_btn', array(
		'label'		=>	esc_html__( 'Header info Button Background Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'header_bg_btn',
		'priority'	=>	12,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_bg_btn_hover', array(
		'label'		=>	esc_html__( 'Header info Button Background Hover Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'header_bg_btn_hover',
		'priority'	=>	13,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_text_btn', array(
		'label'		=>	esc_html__( 'Header info Button Text Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'header_text_btn',
		'priority'	=>	14,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_text_btn_hover', array(
		'label'		=>	esc_html__( 'Header info Button Text Hover Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'header_text_btn_hover',
		'priority'	=>	15,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_info_text', array(
		'label'		=>	esc_html__( 'Header info Text Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'header_info_text',
		'priority'	=>	16,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'header_info_icon', array(
		'label'		=>	esc_html__( 'Header info Icon Color', 'maco' ),
		'section'	=>	'header_default_styling',
		'settings'	=>	'header_info_icon',
		'priority'	=>	17,
	) ) );


	/* HEADER ALTERNATIVE STYLING
	================================================== */
	
	$wp_customize->add_section( 'header_alt_styling', array(
		'title'		=>	esc_html__( 'Header Alternative', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );
	
	//SECTION

	$wp_customize->add_setting( 'alt_menu_hover', array(
		'default'		=> 	'#dddddd',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_menu_border', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_bg_btn', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_bg_btn_hover', array(
		'default'		=> 	'#cc4141',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_text_btn', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_text_btn_hover', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_info_text', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'alt_info_icon', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_menu_hover', array(
		'label'		=>	esc_html__( 'Menu Hover Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_menu_hover',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_menu_border', array(
		'label'		=>	esc_html__( 'Menu Border Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_menu_border',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_bg_btn', array(
		'label'		=>	esc_html__( 'Header info Button Background Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_bg_btn',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_bg_btn_hover', array(
		'label'		=>	esc_html__( 'Header info Button Background Hover Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_bg_btn_hover',
		'priority'	=>	4,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_text_btn', array(
		'label'		=>	esc_html__( 'Header info Button Text Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_text_btn',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_text_btn_hover', array(
		'label'		=>	esc_html__( 'Header info Button Text Hover Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_text_btn_hover',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_info_text', array(
		'label'		=>	esc_html__( 'Header info Text Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_info_text',
		'priority'	=>	7,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'alt_info_icon', array(
		'label'		=>	esc_html__( 'Header info Icon Color', 'maco' ),
		'section'	=>	'header_alt_styling',
		'settings'	=>	'alt_info_icon',
		'priority'	=>	8,
	) ) );

	
	
	/*=====================================================================================================*/
	// Set Panel ID
	/*=====================================================================================================*/
	$panel_id_1 = 'maco_content_section';

	$wp_customize->add_panel( $panel_id_1,
	    array(
	        'priority'          => 199,
	        'capability'        => 'edit_theme_options',
	        'theme_supports'    => '',
	        'title'             => esc_html__( 'Content Section Color', 'maco' ),
	        'description'       => esc_html__( 'Edit your content color here.', 'maco' ),
	    )
	);

	/* BLOG STYLING
	================================================== */
	
	$wp_customize->add_section( 'blog_styling', array(
		'title'		=>	esc_html__( 'Blog Loop', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );
	
	//SECTION

	$wp_customize->add_setting( 'post_meta', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'post_meta_hover', array(
		'default'		=> 	'#666666',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'category_bg', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'category_bg_hover', array(
		'default'		=> 	'#cc4141',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'category_text', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'category_text_hover', array(
		'default'		=> 	'#fafafa',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'post_title', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'post_hover_title', array(
		'default'		=> 	'#666666',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'post_desc', array(
		'default'		=> 	'#777777',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'read_more', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'read_hover_more', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'read_more_border', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'read_more_hover_border', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'read_more_hover_bg', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_meta', array(
		'label'		=>	esc_html__( 'Post Meta Color (Loop & Single Post)', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'post_meta',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_meta_hover', array(
		'label'		=>	esc_html__( 'Post Meta Link Hover Color (Loop & Single Post)', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'post_meta_hover',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'category_bg', array(
		'label'		=>	esc_html__( 'Post Category Background Color (Loop & Single Post)', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'category_bg',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'category_bg_hover', array(
		'label'		=>	esc_html__( 'Post Category Background Hover Color (Loop & Single Post)', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'category_bg_hover',
		'priority'	=>	4,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'category_text', array(
		'label'		=>	esc_html__( 'Post Category Text Color (Loop & Single Post)', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'category_text',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'category_text_hover', array(
		'label'		=>	esc_html__( 'Post Category Text Hover Color (Loop & Single Post)', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'category_text_hover',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_title', array(
		'label'		=>	esc_html__( 'Post Title Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'post_title',
		'priority'	=>	7,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_hover_title', array(
		'label'		=>	esc_html__( 'Post Title Hover Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'post_hover_title',
		'priority'	=>	8,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'post_desc', array(
		'label'		=>	esc_html__( 'Post Text Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'post_desc',
		'priority'	=>	9,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'read_more', array(
		'label'		=>	esc_html__( 'Read More Button Text Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'read_more',
		'priority'	=>	10,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'read_hover_more', array(
		'label'		=>	esc_html__( 'Read More Button Text Hover Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'read_hover_more',
		'priority'	=>	11,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'read_more_border', array(
		'label'		=>	esc_html__( 'Read More Button Border Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'read_more_border',
		'priority'	=>	12,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'read_more_hover_border', array(
		'label'		=>	esc_html__( 'Read More Button Border Hover Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'read_more_hover_border',
		'priority'	=>	13,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'read_more_hover_bg', array(
		'label'		=>	esc_html__( 'Read More Button Background Hover Color', 'maco' ),
		'section'	=>	'blog_styling',
		'settings'	=>	'read_more_hover_bg',
		'priority'	=>	14,
	) ) );



	/* BLOG SINGLE STYLING
	================================================== */
	
	$wp_customize->add_section( 'blog_single_styling', array(
		'title'		=>	esc_html__( 'Single Blog', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );

	//SECTION

	$wp_customize->add_setting( 'title_single', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_single', array(
		'default'		=> 	'#777777',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_quote', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'quote_icon', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'tag_text', array(
		'default'		=> 	'#777777',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'tag_hover', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'tag_bg', array(
		'default'		=> 	'#f3f3f3',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'tag_bg_hover', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'meta_bg', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'left_border', array(
		'default'		=> 	'#dddddd',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'meta_title', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'meta_link', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'meta_link_hover', array(
		'default'		=> 	'#666666',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'prev_bord', array(
		'default'		=> 	'#eeeeee',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'prev_bg', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'prev_link', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'prev_hover_link', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'comment_title', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'comment_link', array(
		'default'		=> 	'#999999',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'comment_hover_link', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_comment_bg', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_comment_bg_hover', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_comment_text', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'next_archive', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'title_single', array(
		'label'		=>	esc_html__( 'Title Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'title_single',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_single', array(
		'label'		=>	esc_html__( 'Text Description Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'text_single',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_quote', array(
		'label'		=>	esc_html__( 'Text Quote Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'text_quote',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'quote_icon', array(
		'label'		=>	esc_html__( 'Quote Icon Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'quote_icon',
		'priority'	=>	4,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tag_text', array(
		'label'		=>	esc_html__( 'Tags Text Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'tag_text',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tag_hover', array(
		'label'		=>	esc_html__( 'Tags Text Hover Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'tag_hover',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tag_bg', array(
		'label'		=>	esc_html__( 'Tags Background Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'tag_bg',
		'priority'	=>	7,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'tag_bg_hover', array(
		'label'		=>	esc_html__( 'Tags Background Hover Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'tag_bg_hover',
		'priority'	=>	8,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'meta_bg', array(
		'label'		=>	esc_html__( 'Content Background Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'meta_bg',
		'priority'	=>	9,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'left_border', array(
		'label'		=>	esc_html__( 'Post Meta Author Border Top Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'left_border',
		'priority'	=>	10,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'meta_title', array(
		'label'		=>	esc_html__( 'Post Meta Title Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'meta_title',
		'priority'	=>	11,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'meta_link', array(
		'label'		=>	esc_html__( 'Post Meta Author Link & Date Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'meta_link',
		'priority'	=>	12,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'meta_link_hover', array(
		'label'		=>	esc_html__( 'Post Meta Author Link Hover Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'meta_link_hover',
		'priority'	=>	13,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'prev_bord', array(
		'label'		=>	esc_html__( 'Next & Previous Post Border Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'prev_bord',
		'priority'	=>	14,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'prev_bg', array(
		'label'		=>	esc_html__( 'Next & Previous Post Background Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'prev_bg',
		'priority'	=>	15,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'prev_link', array(
		'label'		=>	esc_html__( 'Next & Previous Post Text Link Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'prev_link',
		'priority'	=>	16,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'prev_hover_link', array(
		'label'		=>	esc_html__( 'Next & Previous Post Text Link Hover Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'prev_hover_link',
		'priority'	=>	17,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'border_prev', array(
		'label'		=>	esc_html__( 'Next & Previous Post border Top & Bottom Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'border_prev',
		'priority'	=>	18,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'comment_title', array(
		'label'		=>	esc_html__( 'Comment Reply Title Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'comment_title',
		'priority'	=>	19,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'comment_link', array(
		'label'		=>	esc_html__( 'Comment Link Log in & Log Out Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'comment_link',
		'priority'	=>	20,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'comment_hover_link', array(
		'label'		=>	esc_html__( 'Comment Link Log in & Log Out Hover Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'comment_hover_link',
		'priority'	=>	21,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_comment_bg', array(
		'label'		=>	esc_html__( 'Post Comment Button Background Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'btn_comment_bg',
		'priority'	=>	22,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_comment_bg_hover', array(
		'label'		=>	esc_html__( 'Post Comment Button Background Hover Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'btn_comment_bg_hover',
		'priority'	=>	23,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_comment_text', array(
		'label'		=>	esc_html__( 'Post Comment Button Text Color', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'btn_comment_text',
		'priority'	=>	24,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'next_archive', array(
		'label'		=>	esc_html__( 'Next & Previous Post Text Color (Archive)', 'maco' ),
		'section'	=>	'blog_single_styling',
		'settings'	=>	'next_archive',
		'priority'	=>	25,
	) ) );



	/* SIDEBAR STYLING
	================================================== */
	
	$wp_customize->add_section( 'sidebar_styling', array(
		'title'		=>	esc_html__( 'Sidebar & Widget', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );
	
	//SECTION

	$wp_customize->add_setting( 'sidebar_search_bg', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sidebar_search_btn', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sidebar_search_icon', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sidebar_search_text', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sidebar_bg', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'sidebar_border', array(
		'default'		=> 	'#efefef',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'maco_widget_title', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'link_text_sidebar', array(
		'default'		=> 	'#555555',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'link_hover_sidebar', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'bg_tabs', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_tabs', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'bg_tabs2', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_tabs2', array(
		'default'		=> 	'#555555',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_tabs2_hover', array(
		'default'		=> 	'#999999',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'border_tabs', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_search_bg', array(
		'label'		=>	esc_html__( 'Search Widget Background Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'sidebar_search_bg',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_search_btn', array(
		'label'		=>	esc_html__( 'Search Widget Button Background Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'sidebar_search_btn',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_search_icon', array(
		'label'		=>	esc_html__( 'Search Widget Button Icon Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'sidebar_search_icon',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_search_text', array(
		'label'		=>	esc_html__( 'Search Widget Text Iput Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'sidebar_search_text',
		'priority'	=>	4,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_bg', array(
		'label'		=>	esc_html__( 'Widget Background Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'sidebar_bg',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'sidebar_border', array(
		'label'		=>	esc_html__( 'Widget Border Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'sidebar_border',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'maco_widget_title', array(
		'label'		=>	esc_html__( 'Widget Titlte Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'maco_widget_title',
		'priority'	=>	7,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'maco_border_title', array(
		'label'		=>	esc_html__( 'Widget Titlte Border Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'maco_border_title',
		'priority'	=>	8,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_text_sidebar', array(
		'label'		=>	esc_html__( 'Sidebar Widget Link Text Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'link_text_sidebar',
		'priority'	=>	9,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_hover_sidebar', array(
		'label'		=>	esc_html__( 'Sidebar Widget Link Text Hover Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'link_hover_sidebar',
		'priority'	=>	10,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bg_tabs', array(
		'label'		=>	esc_html__( 'maco News Widget Tabs Active Background Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'bg_tabs',
		'priority'	=>	11,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_tabs', array(
		'label'		=>	esc_html__( 'maco News Widget Tabs Text Active Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'text_tabs',
		'priority'	=>	12,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'bg_tabs2', array(
		'label'		=>	esc_html__( 'maco News Widget Tabs Background Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'bg_tabs2',
		'priority'	=>	13,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_tabs2', array(
		'label'		=>	esc_html__( 'maco News Widget Tabs Text Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'text_tabs2',
		'priority'	=>	14,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_tabs2_hover', array(
		'label'		=>	esc_html__( 'maco News Widget Tabs Text Hover Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'text_tabs2_hover',
		'priority'	=>	15,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'border_tabs', array(
		'label'		=>	esc_html__( 'maco News Widget Tabs Border Bottom Color', 'maco' ),
		'section'	=>	'sidebar_styling',
		'settings'	=>	'border_tabs',
		'priority'	=>	16,
	) ) );
	

	/* CONTACT STYLING
	================================================== */
	
	$wp_customize->add_section( 'contact_styling', array(
		'title'		=>	esc_html__( 'Contact Form', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );
	
	//SECTION

	$wp_customize->add_setting( 'form_bord', array(
		'default'		=> 	'#cdcdcc',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'form_bord_hover', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_input', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_send', array(
		'default'		=> 	'#000000',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_send_text', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_send_hover', array(
		'default'		=> 	'#333333',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'btn_send_text_hover', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'form_bord', array(
		'label'		=>	esc_html__( 'Contact Form Style 1&2 Border Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'form_bord',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'form_bord_hover', array(
		'label'		=>	esc_html__( 'Contact Form Style 2 Border Hover Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'form_bord_hover',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_input', array(
		'label'		=>	esc_html__( 'Text Input Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'text_input',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_send', array(
		'label'		=>	esc_html__( 'Contact Form Style 1&2 Button Background Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'btn_send',
		'priority'	=>	4,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_send_text', array(
		'label'		=>	esc_html__( 'Contact Form Style 1&2 Button Text Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'btn_send_text',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_send_hover', array(
		'label'		=>	esc_html__( 'Contact Form Style 1&2 Button Background Hover Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'btn_send_hover',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'btn_send_text_hover', array(
		'label'		=>	esc_html__( 'Contact Form Style 1&2 Button Text Hover Color', 'maco' ),
		'section'	=>	'contact_styling',
		'settings'	=>	'btn_send_text_hover',
		'priority'	=>	7,
	) ) );




	/*=====================================================================================================*/
	// Set Panel ID
	/*=====================================================================================================*/
	$panel_id_1 = 'maco_footer_section';

	$wp_customize->add_panel( $panel_id_1,
	    array(
	        'priority'          => 199,
	        'capability'        => 'edit_theme_options',
	        'theme_supports'    => '',
	        'title'             => esc_html__( 'Footer Section Color', 'maco' ),
	        'description'       => esc_html__( 'Edit your Footer color here.', 'maco' ),
	    )
	);

	/* Footer STYLING
	================================================== */
	
	$wp_customize->add_section( 'footer_styling', array(
		'title'		=>	esc_html__( 'Footer', 'maco' ),
		'priority'	=>	200,
		'panel' 	  => $panel_id_1
	) );
	
	//SECTION

	$wp_customize->add_setting( 'footer_text', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_link', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_hover_link', array(
		'default'		=> 	'#666666',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_social', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_hover_social', array(
		'default'		=> 	'#666666',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_widget_bg', array(
		'default'		=> 	'#111111',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_widget_title', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'footer_wgtitle_separator', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'link_text_widget', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'link_hover_widget', array(
		'default'		=> 	'#666666',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'text_widget', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'border_widget', array(
		'default'		=> 	'#333333',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'border_search_footer', array(
		'default'		=> 	'#cb1313',
		'type'			=> 	'option',
		'transport'		=> 	'postMessage',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	$wp_customize->add_setting( 'input_search_footer', array(
		'default'		=> 	'#ffffff',
		'type'			=> 	'option',
		'capability'	=>	'edit_theme_options',
		'sanitize_callback' => 'sanitize_hex_color',
	) );

	//CONTROL

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_text', array(
		'label'		=>	esc_html__( 'Footer Copyright & Address Text Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_text',
		'priority'	=>	1,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_link', array(
		'label'		=>	esc_html__( 'Footer Copyright Link Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_link',
		'priority'	=>	2,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_hover_link', array(
		'label'		=>	esc_html__( 'Footer Copyright Link Hover Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_hover_link',
		'priority'	=>	3,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_social', array(
		'label'		=>	esc_html__( 'Footer Social Icon Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_social',
		'priority'	=>	4,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_hover_social', array(
		'label'		=>	esc_html__( 'Footer Social Icon Hover Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_hover_social',
		'priority'	=>	5,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_widget_bg', array(
		'label'		=>	esc_html__( 'Footer Widget Background Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_widget_bg',
		'priority'	=>	6,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_widget_title', array(
		'label'		=>	esc_html__( 'Footer Widget Title Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_widget_title',
		'priority'	=>	7,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'footer_wgtitle_separator', array(
		'label'		=>	esc_html__( 'Footer Widget Title Separator Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'footer_wgtitle_separator',
		'priority'	=>	8,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_text_widget', array(
		'label'		=>	esc_html__( 'Footer Widget Link Text Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'link_text_widget',
		'priority'	=>	9,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'link_hover_widget', array(
		'label'		=>	esc_html__( 'Footer Widget Link Text Hover Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'link_hover_widget',
		'priority'	=>	10,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'text_widget', array(
		'label'		=>	esc_html__( 'Footer Widget Text Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'text_widget',
		'priority'	=>	11,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'border_widget', array(
		'label'		=>	esc_html__( 'Footer Widget Border Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'border_widget',
		'priority'	=>	12,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'border_search_footer', array(
		'label'		=>	esc_html__( 'Footer Search Widget Border & Background Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'border_search_footer',
		'priority'	=>	13,
	) ) );

	$wp_customize->add_control( new WP_Customize_Color_Control( $wp_customize, 'input_search_footer', array(
		'label'		=>	esc_html__( 'Footer Search Widget Input Color', 'maco' ),
		'section'	=>	'footer_styling',
		'settings'	=>	'input_search_footer',
		'priority'	=>	14,
	) ) );

	