<?php


	if ( ! class_exists( 'Redux' ) ) {
		return;
	}


if (!class_exists("MACO_Framework_Config")) {

	class MACO_Framework_Config {

		public $args = array();
		public $sections = array();
		public $theme;
		public $ReduxFramework;

		public function __construct() {
			// This is needed. Bah WordPress bugs.  ;)
			if ( get_template_directory() && strpos( Redux_Helpers::cleanFilePath( __FILE__ ), Redux_Helpers::cleanFilePath( get_template_directory() ) ) !== false) {
				$this->initSettings();
			} else {
				add_action('plugins_loaded', array($this, 'initSettings'), 10);    
			}
		}

		public function initSettings() {

			if ( !class_exists("ReduxFramework" ) ) {
				return;
			}       
			
			$this->theme = wp_get_theme();
			$this->setArguments();
			$this->setHelpTabs();
			$this->setSections();

			if (!isset($this->args['opt_name'])) { 
				return;
			}

			$this->ReduxFramework = new ReduxFramework($this->sections, $this->args);
		}

		public function setSections() {



			ob_start();

			$ct = wp_get_theme();
			$this->theme = $ct;
			$item_name = $this->theme->get('Name');
			$tags = $this->theme->Tags;
			$screenshot = $this->theme->get_screenshot();
			$class = $screenshot ? 'has-screenshot' : '';

			$customize_title = sprintf(__('Customize &#8220;%s&#8221;', 'maco'), $this->theme->display('Name'));
			?>
			

			<?php
			$item_info = ob_get_contents();

			ob_end_clean();


			// DECLARATION OF SECTIONS

			/*---------------------------------------
				1. Header Options
				2. Content Options
				3. Footer Options
				4. Blog Options
				5. Single Post Options
				6. Single Portfolio Options
				7. 404 Options
				8. Page Loader Options
			----------------------------------------*/

			/*-----------------------------------------------------------------------------------
			1. Header Options
				1.1. Header Container
				1.2. Header Type
					1.2.1. Header 1 Options
						1.2.1.1 Header 1 Top Options
					1.2.1. Header 2 & 3 Options
					1.2.3. Header 4, 5, 6 Options
				1.3. Boxed Header Options
				1.4. Header Alternative Options
				1.5. Search
			-----------------------------------------------------------------------------------*/
			
			$this->sections[] = array(
				'icon' => ' el-icon-credit-card',
				'icon_class' => 'icon-large',
				'title' => esc_html__('Header Builder', 'maco'),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-credit-card',
				'id'   => 'genereal-header',
				'icon_class' => 'icon-large',
				'class' => 'header-general-sub',
				'subsection' => true,
				'title' => esc_html__('General Header', 'maco'),
				'fields' => array(

					/* 1.2. Header Type */
					array(
						'id'       => 'header_animated',
						'type'     => 'switch',
						'title'    => esc_html__( 'Use Animated Header', 'maco' ),
						'subtitle' => esc_html__( 'Make your header animated after page loaded', 'maco' ),
						'default'  => true,
					),
					array(
						'id'       => 'fixed_header',
						'type'     => 'switch',
						'title'    => esc_html__( 'Use Fixed Header', 'maco' ),
						'subtitle' => esc_html__( 'Make your header as sticky header.', 'maco' ),
						'default'  => false,
					),
					array(
						'id'       => 'header_fixed_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Header Fixed Type', 'maco' ),
						'options'  => array(
							'header_fixed_noscroll'     => esc_html__( 'Header Fixed No Scroll', 'maco' ),
							'header_fixed_scroll'     => esc_html__( 'Header Fixed Scroll', 'maco' ),
						),
						'default'  => 'header_fixed_noscroll',
						'required' => array(
							array( 'fixed_header', '=', true ),
						),
					),
					array(
						'id'       => 'space_when_scroll',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'         => false,
						'bottom'         => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Header Space When Scroll', 'maco' ),
						'default'  => array(
							'padding-top'    => '40px',
							'padding-right'  => '0',
							'padding-bottom' => '40px',
							'padding-left'   => '0'
						),
						'required' => array(
							array( 'header_fixed_type', '=', 'header_fixed_scroll' ),
						),
					),

					/* end of header type */

					/* logo dimensions tab */
					array(
						'id'       => 'header_general_opt_select',
						'type'     => 'button_set',
						'title'    => '',
						'subtitle' => '',
						'options'  => array(
							'header-logo'     => esc_html__( 'Header Logo', 'maco' ),
							'header-dimension'   => esc_html__( 'Header Dimensions', 'maco' ),
							'header-background'   => esc_html__( 'Header Background', 'maco' ),
							'header-widget'		=> esc_html__( 'Header Widget', 'maco' ),
						),
						'default'  => 'header-logo'
					),
					/* end of header_general_opt_select */

					array(
						'id' 		=> 'logo_upload',
						'type' 		=> 'media',
						'url' 		=> true,
						'compiler' 	=> 'true',
						'title'    	=> esc_html__( 'Header Logo', 'maco' ),
						'default'  	=> array(
							'url'	=>''
						),
						'required' 	=> array( 'header_general_opt_select', '=', 'header-logo' ),
					),
					array(
						'id'       => 'logo_padding',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'right'    => false,
						'left'     => false, 
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Logo', 'maco' ),
						'subtitle' => esc_html__( 'A gap space for your logo image and title.', 'maco' ),
						'default'  => array(
							'padding-top'    => '5px',
							'padding-bottom' => '0',
						),
						'required' 	=> array( 'header_general_opt_select', '=', 'header-logo' ),
					),

					/* header dimensions */
					array(
						'id'       => 'header_padding',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Header', 'maco' ),
						'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
						'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
						'default'  => array(
							'padding-top'    => '80px',
							'padding-right'  => '0',
							'padding-bottom' => '80px',
							'padding-left'   => '0'
						),
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-dimension' ),
						),
					),

					/* header custom background */
					array(
						'id' => 'header_background',
						'type' => 'background',
						'title' => esc_html__('Header Custom Background', 'maco'),
						'subtitle' => esc_html__('Header background with image, color, etc.', 'maco'),
						'default' => array(
							'background-color'  => 'transparent',
							'background-repeat'  => 'no-repeat',
							'background-size'  => 'inherit',
							'background-attachment'  => 'inherit',
							'background-position'  => 'center center',
						),
						'required' => array(
							array( 'header_general_opt_select', '=', 'header-background' ),
						),
					),
					array(
						'id' => 'header_fixed_background',
						'type'     => 'color',
						'title' => esc_html__('Header Fixed When Scroll Background', 'maco'),
						'subtitle' => esc_html__('Header fixed background with image, color, etc.', 'maco'),
						'default' => '#ffffff',
						'validate' => 'color',
						'required' => array(
							array( 'header_general_opt_select', '=', 'header-background' ),
							array( 'fixed_header', '=', true ),
							array( 'header_fixed_type', '=', 'header_fixed_scroll' ),
						),
					),
					array(
						'id' => 'header_fixed_color',
						'type'     => 'color',
						'title' => esc_html__('Header Fixed When Scroll Color', 'maco'),
						'subtitle' => esc_html__('Header fixed text color.', 'maco'),
						'default' => '#000000',
						'validate' => 'color',
						'required' => array(
							array( 'header_general_opt_select', '=', 'header-background' ),
							array( 'fixed_header', '=', true ),
							array( 'header_fixed_type', '=', 'header_fixed_scroll' ),
						),
					),

					/* header info */
					array(
						'id'		=> 'header_info_icon_1',
						'type'		=> 'select',
						'data'		=> 'elusive-icons',
						'title'		=> esc_html__( 'Header Info 1 Icon', 'maco' ),
						'enqueue_frontend' => true,
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-widget' ),
						),
					),

					array(
						'id'=>'header_info_1',
						'type' => 'text',
						'title' => esc_html__('Header Info 1', 'maco'),
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-widget' ),
						),
						'default' => ''
					),

					array(
						'id'		=> 'header_info_icon_2',
						'type'		=> 'select',
						'data'		=> 'elusive-icons',
						'title'		=> esc_html__( 'Header Info 2 Icon', 'maco' ),
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-widget' ),
						),
					),

					array(
						'id'=>'header_info_2',
						'type' => 'text',
						'title' => esc_html__('Header Info 2', 'maco'),
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-widget' ),
						),
						'default' => ''
					),

					array(
						'id'=>'header_info_link',
						'type' => 'text',
						'title' => esc_html__('Info Link Text', 'maco'),
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-widget' ),
						),
						'default' => ''
					),

					array(
						'id'=>'header_info_url',
						'type' => 'text',
						'title' => esc_html__('Header Info URL', 'maco'),
						'required' => array( 
							array( 'header_general_opt_select', '=', 'header-widget' ),
						),
						'validate' => 'url',
						'default' => ''
					),

					/* 1.3. Boxed Header Options */
					array(
						'id'       => 'header_boxed',
						'type'     => 'switch',
						'title'    => esc_html__( 'Use Boxed Header', 'maco' ),
						'subtitle' => esc_html__( 'Make your header boxed', 'maco' ),
						'default'  => false,
					),
					array(
						'id'       => 'header_boxed_width',
						'type'     => 'dimensions',
						'units'    => array('px', '%'),
						'title'    => esc_html__('Header Boxed Width.', 'maco'),
						'subtitle' => esc_html__('Define width for header box.', 'maco'),
						'output'   => array('header#header.inner-head-wrap'),
						'height'   => false,
						'default'  => array(
							'Width'   => '1170', 
							'Height'  => false
						),
						'required' => array(
							array('header_boxed','=', true),
						),
					),
					array(
						'id'       => 'header_margin',
						'type'     => 'spacing',
						'output'   => array( 'header#header' ),
						'mode'     => 'margin',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Header', 'maco' ),
						'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
						'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-right'  => 'auto',
							'margin-bottom' => '0',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array('header_boxed','=', true),
						),
					),
					/* end of header boxed options */

				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-website',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'class' => 'header-style-sub',
				'title' => esc_html__('Header Style', 'maco'),
				'fields' => array(

					/* 1.2.1. Header 1 Options */
					array(
						'id'=>'header_1_layout',
						'type' => 'image_select',
						'compiler'=> true,
						'title' => esc_html__('Header 1 Layout', 'maco'), 
						'subtitle' => esc_html__('Select header between 1, 2 or 3 column layout.', 'maco'),
						'options' => array(
								'1column-header' => array('alt' => '1column-header', 'img' => get_template_directory_uri() .'/img/col-opt1.png'),
								'2column-header' => array('alt' => '2column-header', 'img' => get_template_directory_uri() .'/img/col-opt2.png'),
								'3column-header' => array('alt' => '3column-header', 'img' => get_template_directory_uri() .'/img/col-opt3.png'),
							),
						'default' => '2column-header',
					),
					array(
						'id'       => 'header_col_3',
						'type'     => 'button_set',
						'title'    => '',
						'subtitle' => '',
						'options'  => array(
							'header_3_col_1'     => esc_html__('Header Left Column', 'maco'),
							'header_3_col_2'     => esc_html__('Header Center Column', 'maco'),
							'header_3_col_3'     => esc_html__('Header Right Column', 'maco'),
						),
						'default'  => 'header_3_col_1',
						'required' => array( 'header_1_layout', '=', array( '1column-header', '2column-header', '3column-header' ) ),
					),
					array(
						'id'       => 'header_3_centered',
						'type'     => 'button_set',
						'title'    => esc_html__('Header Column 3 Item Position', 'maco'),
						'subtitle' => '',
						'options'  => array(
							'header3_centered'     => esc_html__('Centered Item', 'maco'),
							'normal_header3'     => esc_html__('Normal', 'maco'),
						),
						'default'  => 'normal_header3',
						'required' => array( 'header_1_layout', '=', '3column-header' ),
					),
					array(
						'id'       => 'header_col3_side',
						'type'     => 'dimensions',
						'units'    => array('px', '%'),
						'title'    => esc_html__('Header Column 3 Side Item Width.', 'maco'),
						'height'   => false,
						'output' => array('#header .header3_centered .fl, #header .header3_centered .fr'),
						'default'  => array(
							'width'   => '20', 
							'Height'  => false
						),
						'required' => array(
							array( 'header_1_layout', '=', '3column-header' ),
							array( 'header_3_centered', '=', 'header3_centered' ),
						),
					),
					array(
						'id'       => 'header_col3_center',
						'type'     => 'dimensions',
						'units'    => array('px', '%'),
						'title'    => esc_html__('Header Column 3 Center Item Width.', 'maco'),
						'height'   => false,
						'output' => array('#header .header3_centered .fc'),
						'default'  => array(
							'width'   => '60', 
							'Height'  => false
						),
						'required' => array(
							array( 'header_1_layout', '=', '3column-header' ),
							array( 'header_3_centered', '=', 'header3_centered' ),
						),
					),
					/* column setting end */

					/*left section*/
					array(
						'id'       => 'header_left_set',
						'type'     => 'button_set',
						'title'    => esc_html__('Header Left Setting', 'maco'),
						'subtitle' => '',
						'options'  => array(
							'header_left_content'     => esc_html__('Header Left Content', 'maco'),
							'header_left_display'     => esc_html__('Header Left Display', 'maco'),
						),
						'default'  => 'header_left_content',
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
						),
					),
					array(
						'id'      => 'header_customize_left',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Header Left Content', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the header left', 'maco' ),
						'options' => array(
							'enabled'  => array(
								'maco-logo' => esc_html__('Logo','maco'),
							),
							'disabled' => array(
								'maco-menus'   => esc_html__('Menus','maco'),
								'maco-sec-menus'   => esc_html__('Secondary Menus','maco'),
								'maco-search' => esc_html__('Search Button','maco'),
								'maco-info'   => esc_html__('Header Info','maco'),
							)
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
							array( 'header_left_set', '=', 'header_left_content' ),
						),
					),
					array(
						'id'       => 'header_left_display',
						'type'     => 'select',
						'title'    => esc_html__('Header Left Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'horizontal',
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
							array( 'header_left_set', '=', 'header_left_display' ),
						),
					),
					array(
						'id'       => 'header_left_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Header Left Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__('Text Left', 'maco'),
							'text-center' => esc_html__('Text Center', 'maco'),
							'text-right' => esc_html__('Text Right', 'maco')
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
							array( 'header_left_set', '=', 'header_left_display' ),
							array( 'header_1_layout', '=', '3column-header' ),
						),
						'default'  => 'text-center'
					),
					array(
						'id'       => 'header_left_item_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'left'          => true,
						'right'         => true,
						'top'			=> false,
						'bottom'		=> false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Header Item', 'maco' ),
						'default'  => array(
							'margin-top'    => 'auto',
							'margin-left'   => '0',
							'margin-bottom' => 'auto',
							'margin-right'  => '20px',
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
							array( 'header_left_set', '=', 'header_left_display' ),
							array( 'header_left_display', '=', 'horizontal' ),
						),
					),
					array(
						'id'       => 'header_left_float',
						'type'     => 'button_set',
						'title'    => '',
						'subtitle' => '',
						'options'  => array(
							'header_left_nofloat'     => esc_html__('Make Full Width', 'maco'),
							'header_left_float'     => esc_html__('Make Column', 'maco'),
						),
						'default'  => 'header_left_float',
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
							array( 'header_left_set', '=', 'header_left_display' ),
							array( 'header_left_display', '=', 'vertical' ),
						),
					),
					array(
						'id'       => 'header_left_item_ver_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'left'          => false,
						'right'         => false,
						'top'			=> true,
						'bottom'		=> true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Header Item', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-left'   => 'auto',
							'margin-bottom' => '0',
							'margin-right'  => 'auto',
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_1' ),
							array( 'header_left_set', '=', 'header_left_display' ),
							array( 'header_left_display', '=', 'vertical' ),
							array( 'header_left_float', '=', 'header_left_nofloat' ),
						),
					),
					array(
						'id'    => 'header_left_notif',
						'type'  => 'info',
						'notice' => false,
						'title' => esc_html__( 'Left column section not available for current choice.', 'maco' ),
						'required' => array(
							array( 'header_1_layout', '=', '1column-header' ),
							array( 'header_col_3', '=', 'header_3_col_1' ),
						),
					),
					/*left section end*/

					/*center section*/
					array(
						'id'       => 'header_center_set',
						'type'     => 'button_set',
						'title'    => esc_html__('Header Center Setting', 'maco'),
						'subtitle' => '',
						'options'  => array(
							'header_center_content'     => esc_html__('Header Center Content', 'maco'),
							'header_center_display'     => esc_html__('Header Center Display', 'maco'),
						),
						'default'  => 'header_center_content',
						'required' => array(
							array( 'header_1_layout', '=', array( '1column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_2' ),
						),
					),
					array(
						'id'      => 'header_customize_center',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Header Center Content', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the header center', 'maco' ),
						'options' => array(
							'enabled'  => array(
								
							),
							'disabled' => array(
								'maco-menus'   => esc_html__('Menus','maco'),
								'maco-sec-menus'   => esc_html__('Secondary Menus','maco'),
								'maco-search' => esc_html__('Search Button','maco'),
								'maco-logo' => esc_html__('Logo','maco'),
								'maco-info'   => esc_html__('Header Info','maco'),
							)
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '1column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_2' ),
							array( 'header_center_set', '=', 'header_center_content' ),
						),
					),
					array(
						'id'       => 'header_center_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Header Center Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__('Text Left','maco'),
							'text-center' => esc_html__('Text Center','maco'),
							'text-right' => esc_html__('Text Right','maco')
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '1column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_2' ),
							array( 'header_center_set', '=', 'header_center_display' ),
							array( 'header_1_layout', '=', '3column-header' ),
						),
						'default'  => 'text-center'
					),
					array(
						'id'       => 'header_center_display',
						'type'     => 'select',
						'title'    => esc_html__('Header Center Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'horizontal',
						'required' => array(
							array( 'header_1_layout', '=', array( '1column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_2' ),
							array( 'header_center_set', '=', 'header_center_display' ),
						),
					),
					array(
						'id'       => 'header_center_float',
						'type'     => 'button_set',
						'title'    => '',
						'subtitle' => '',
						'options'  => array(
							'header_center_nofloat'     => esc_html__('Make Full Width', 'maco'),
							'header_center_float'     => esc_html__('Make Column', 'maco'),
						),
						'default'  => 'header_center_float',
						'required' => array(
							array( 'header_1_layout', '=', array( '1column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_2' ),
							array( 'header_center_set', '=', 'header_center_display' ),
							array( 'header_center_display', '=', 'vertical' ),
						),
					),
					array(
						'id'    => 'header_center_notif',
						'type'  => 'info',
						'notice' => false,
						'title' => esc_html__( 'Center column section not available for current choice.', 'maco' ),
						'required' => array(
							array( 'header_1_layout', '=', '2column-header' ),
							array( 'header_col_3', '=', 'header_3_col_2' ),
						),
					),
					/*center section end*/

					/*right section*/
					array(
						'id'       => 'header_right_set',
						'type'     => 'button_set',
						'title'    => esc_html__('Header Right Setting', 'maco'),
						'subtitle' => '',
						'options'  => array(
							'header_right_content'     => esc_html__('Header Right Content', 'maco'),
							'header_right_display'     => esc_html__('Header Right Display', 'maco'),
						),
						'default'  => 'header_right_content',
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
						),
					),
					array(
						'id'      => 'header_customize_right',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Header Right Content', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the header right', 'maco' ),
						'options' => array(
							'enabled'  => array(
								'maco-menus'   => esc_html__('Menus','maco'),
								'maco-search' => esc_html__('Search Button','maco'),
							),
							'disabled' => array(
								'maco-sec-menus'   => esc_html__('Secondary Menus','maco'),
								'maco-logo' => esc_html__('Logo','maco'),
								'maco-info'   => esc_html__('Header Info','maco'),
							)
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_content' ),
						),
					),
					array(
						'id'       => 'header_right_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Header Right Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__('Text Left','maco'),
							'text-center' => esc_html__('Text Center','maco'),
							'text-right' => esc_html__('Text Right','maco')
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
							array( 'header_1_layout', '=', '3column-header' ),
						),
						'default'  => 'text-center'
					),
					array(
						'id'       => 'header_right_display',
						'type'     => 'select',
						'title'    => esc_html__('Header Right Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'horizontal',
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
						),
					),
					array(
						'id'       => 'header_right_item_padding',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'left'          => false,
						'right'         => false,
						'top'			=> true,
						'bottom'		=> true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Header Right Item', 'maco' ),
						'default'  => array(
							'padding-top'    => '0',
							'padding-left'   => 'auto',
							'padding-bottom' => '0',
							'padding-right'  => 'auto',
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
						),
					),
					array(
						'id'       => 'header_right_item_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'left'          => true,
						'right'         => true,
						'top'			=> false,
						'bottom'		=> false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Header Item', 'maco' ),
						'default'  => array(
							'margin-top'    => 'auto',
							'margin-left'   => '0',
							'margin-bottom' => 'auto',
							'margin-right'  => '20px',
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
							array( 'header_right_display', '=', 'horizontal' ),
						),
					),
					array(
						'id'       => 'header_right_float',
						'type'     => 'button_set',
						'title'    => '',
						'subtitle' => '',
						'options'  => array(
							'header_right_nofloat'     => esc_html__('Make Full Width', 'maco'),
							'header_right_float'     => esc_html__('Make Column', 'maco'),
						),
						'default'  => 'header_right_float',
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
							array( 'header_right_display', '=', 'vertical' ),
						),
					),
					array(
						'id'       => 'header_right_item_ver_padding',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'left'          => false,
						'right'         => false,
						'top'			=> true,
						'bottom'		=> true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Vertical Row', 'maco' ),
						'default'  => array(
							'padding-top'    => '0',
							'padding-left'   => 'auto',
							'padding-bottom' => '0',
							'padding-right'  => 'auto',
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
							array( 'header_right_display', '=', 'vertical' ),
							array( 'header_right_float', '=', 'header_right_nofloat' ),
						),
					),
					array(
						'id'       => 'header_right_item_ver_bord',
						'type'     => 'border',
						'title'    => esc_html__( 'Header Right Border', 'maco' ),
						'all'      => false,
						'default'  => array(
							'border-color'  => '#efefef',
							'border-style'  => 'solid',
							'border-top'    => '1px',
							'border-right'  => false,
							'border-bottom' => '1px',
							'border-left'   => false,
						),
						'required' => array(
							array( 'header_1_layout', '=', array( '2column-header', '3column-header' )),
							array( 'header_col_3', '=', 'header_3_col_3' ),
							array( 'header_right_set', '=', 'header_right_display' ),
							array( 'header_right_display', '=', 'vertical' ),
							array( 'header_right_float', '=', 'header_right_nofloat' ),
						),
					),
					array(
						'id'    => 'header_right_notif',
						'type'  => 'info',
						'notice' => false,
						'title' => esc_html__( 'Right column section not available for current choice.', 'maco' ),
						'required' => array(
							array( 'header_1_layout', '=', '1column-header' ),
							array( 'header_col_3', '=', 'header_3_col_3' ),
						),
					),
					/*right section end */

				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-credit-card',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'class' => 'header-alt-sub',
				'title' => esc_html__('Header Alternative', 'maco'),
				'fields' => array(

					/* 1.4. Header Alternative Options */
					array(
						'id'        => 'header_scheme',
						'type'      => 'button_set',
						'title'     => esc_html__('Alternative Header Scheme', 'maco'),
						'options' 	 => array(
							'enable' 	=> esc_html__('Enable','maco'),
							'disable' => esc_html__('Disable','maco'),
						),
						'default'  => 'enable'
					),
					array(
						'id'       => 'header_text_color',
						'type'     => 'color',
						'title'    => esc_html__('Header text color', 'maco'),
						'subtitle' => esc_html__('Set header text color', 'maco'),
						'default'  => '#ffffff',
						'validate' => 'color',
						'output'   => array('body .alt-head .main-menu ul.sm-clean>li>a, body .alt-head .search-wrap #btn-search i, body .alt-head .main-menu ul.sm-clean>li.current-menu-item>a, .alt-head .site-title a, #header.alt-head .head-info-text span'),
						'required' => array('header_scheme','=','enable'),
					),
					array(
						'id' => 'header_alt_logo',
						'type' => 'media',
						'url' => true,
						'compiler' => 'true',
						'title' => esc_html__('Alternative Logo', 'maco'), 
						'desc' => esc_html__('Upload your logo image here (any size).', 'maco'),
						'required' => array('header_scheme','=','enable'),
						'default'  	=> array(
							'url'	=>''
						),
					),
					array(
						'id' => 'header_alt_bg',
						'type' => 'background',
						'output' => array('header#header.inner-head-wrap.alt-head'),
						'title' => esc_html__('Header Alternative Background', 'maco'),
						'subtitle' => esc_html__('Header background with image, color, etc.', 'maco'),
						'default' => 'transparent',
						'required' => array('header_scheme','=','enable'),
					),
					/* end of header alternative options*/

					array(
						'id'        => 'space_fixed_alt',
						'type'      => 'button_set',
						'title'     => esc_html__('Header Fixed Space', 'maco'),
						'options' 	 => array(
							'on' 	=> esc_html__('Enable','maco'),
							'off' => esc_html__('Disable','maco'),
						),
						'default'  => 'off'
					),
				),
			);

			/* Header Mobile*/
			$this->sections[] = array(
				'icon' => 'el-icon-credit-card',
				'icon_class' => 'icon-large',
				'id' => 'header-mobile-sub-id',
				'class' => 'header-mobile-sub-class',
				'subsection' => true,
				'title' => esc_html__('Mobile Header', 'maco'),
				'fields' => array(

					array(
						'id'       => 'header_mob_bg_def',
						'type'     => 'color',
						'title'    => esc_html__('Header Mobile Default Background', 'maco'),
						'default'  => 'transparent',
						'validate' => 'color',
					),

					array(
						'id'       => 'header_mob_bg_alt',
						'type'     => 'color',
						'title'    => esc_html__('Header Mobile Alternative Background', 'maco'),
						'default'  => '#000000',
						'validate' => 'color',
						'required' => array('header_scheme','=','enable'),
					),

					array(
						'id'       => 'mobile_padding_head',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'bottom'         => false,
						'top'         => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Header Mobile Padding', 'maco' ),
						'default'  => array(
							'padding-top'    => 'auto',
							'padding-bottom' => 'auto',
							'padding-left'   => '45px',
							'padding-right'  => '45px'
						),
					),

					array(
						'id'       => 'mobile_margin_logo',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'top'         => true,
						'bottom'         => true,
						'left'	=> false,
						'right'	=> false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Logo Mobile Margin', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-bottom' => '0',
							'margin-left'   => 'auto',
							'margin-right'  => 'auto'
						),
					),

					array(
						'id'       => 'mobile_margin_menu',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'top'         => true,
						'bottom'         => true,
						'left'	=> false,
						'right'	=> false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Mobile Menu', 'maco' ),
						'default'  => array(
							'margin-top'    => '15px',
							'margin-bottom' => '0',
							'margin-left'   => 'auto',
							'margin-right'  => 'auto'
						),
					),

				)
			);

			$this->sections[] = array(
				'icon' => ' el-icon-search',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'header-search-sub-id',
				'class' => 'header-search-sub-class',
				'title' => esc_html__('Search Bar', 'maco'),
				'fields' => array(

					/* 1.5. Search*/
					array(
						'id'       => 'search_bar_style',
						'type'     => 'select',
						'title'    => esc_html__('Search Bar Style', 'maco'),
						'options'  => array(
							'default'		=> esc_html__('Default Search Bar', 'maco'),
							'expand'		=> esc_html__('Expanded Search Content', 'maco'),
						),
						'default'  => 'expand',
					),
					array(
						'id'		=>'search_bar_title',
						'type' 		=> 'text',
						'title' 	=> esc_html__('Search Bar Title', 'maco'),
						'default' 	=> '',
						'required' => array('search_bar_style','=','expand'),
					),
					array(
						'id'		=>'search_sug_title',
						'type' 		=> 'text',
						'title' 	=> esc_html__('Search Suggestion Title', 'maco'),
						'default' 	=> '',
						'required' => array('search_bar_style','=','expand'),
					),
					array(
						'id'       => 'search_sug_text',
						'type'     => 'textarea',
						'title'    => esc_html__('Search Suggestion Description', 'maco'), 
						'default' 	=> '',
						'required' => array('search_bar_style','=','expand'),
					),
				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-fontsize',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'header-typo-sub-id',
				'class' => 'header-typo-sub-class',
				'title' => esc_html__('Header Typography', 'maco'),
				'fields' => array(

					/*menu typography*/
					array(
						'id'=>'header1-menu-typography',
						'type' => 'typography',
						'title' => esc_html__('Menu Typography', 'maco'),
						'compiler'=>true, // Use if you want to hook in your own CSS compiler
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>true, // Select a backup non-google font in addition to a google font
						'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to false
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'output' => array('#header #primary-menu li a, #header #secondary-menu li a, #header .head-info-text span, .header-info-url a'), // An array of CSS selectors to apply this font style to dynamically
						'units'=>'px', 'em', // Defaults to px
						'subtitle'=> esc_html__('This typography only work for Header style 1 (Default header style).', 'maco'),
						'default'=> array(

							'font-weight' => '500',
							'font-family' => 'Karla',
							'google' => true,
							'font-backup' => 'Georgia, serif',
							'font-size'   => '16px',
							'line-height' => '25.6px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
							'text-align' => 'inherit',
						)
					),

					/* header mobile typography */
					array(
						'id'=>'header-mobile-typography',
						'type' => 'typography', 
						'title' => esc_html__('Header Mobile Typography', 'maco'),
						'compiler'=>true, // Use if you want to hook in your own CSS compiler
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-family'=>false,
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to false
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'units'=>'px', 'em', // Defaults to px
						'subtitle'=> esc_html__('Set website menu font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-weight' => '500',
							'google' => true,
							'font-size'   => '16px',
							'line-height' => '25.6px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
							'text-align' => 'center',
						)
					),
					
				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-text-width',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'header-menus-sub-id',
				'class' => 'header-menus-sub-class',
				'title' => esc_html__('Header Menu Style', 'maco'),
				'fields' => array(

					/* 1.5. Search*/
					array(
						'id'       => 'menus_choose_style',
						'type'     => 'select',
						'title'    => esc_html__('Menu Style Choices', 'maco'),
						'options'  => array(
							'style-1'		=> esc_html__('Style 1', 'maco'),
							'style-2'		=> esc_html__('Style 2', 'maco'),
							'style-3'		=> esc_html__('Style 3', 'maco'),
							'style-4'		=> esc_html__('Style 4', 'maco'),
							'style-5'		=> esc_html__('Style 5', 'maco'),
							'style-6'		=> esc_html__('Style 6', 'maco'),
							'style-7'		=> esc_html__('Style 7', 'maco'),
							'style-8'		=> esc_html__('Style 8', 'maco'),
							'style-9'		=> esc_html__('Style 9', 'maco'),
							'style-10'		=> esc_html__('Style 10', 'maco'),
							'style-11'		=> esc_html__('Style 11', 'maco'),
							'style-12'		=> esc_html__('Style 12', 'maco'),
							'style-13'		=> esc_html__('Style 13', 'maco'),
							'style-14'		=> esc_html__('Style 14', 'maco'),
						),
						'default'  => 'style-1',
					),
				),
			);
			
			/*-----------------------------------------------------------------------------------
			2. Content Options
				2.1. Content Container
				2.2. Content Wrapper Type
				2.3. Boxed Content
					2.3.1. Boxed Content Options
			-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-fullscreen',
				'icon_class' => 'icon-large',
				'title' => esc_html__('Content Options', 'maco'),
				'fields' => array(

					/* 2.1. Content Container*/
					array(
						'id' => 'content_background',
						'type' => 'background',
						'output' => array('#content'),
						'title' => esc_html__('Content Custom Background', 'maco'),
						'subtitle' => esc_html__('Content background with image, color, etc.', 'maco'),
						'default' => 'transparent',
					),
					/* end of content container */

					/* 2.2. Content Wrapper Type */
					array(
						'id'       => 'wrap_opt',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Wrapper Option', 'maco' ),
						'subtitle' => esc_html__( 'Select Your Wrapper Type', 'maco' ),
						'options' => array(
							'default' => array('alt' => 'default', 'img' => get_template_directory_uri() .'/img/wrap-1.jpg'),
							'bordered' => array('alt' => 'bordered', 'img' => get_template_directory_uri() .'/img/wrap-2.jpg'),
						),
						'default'  => 'default'
					),

					array(
						'id'       => 'bordered_title',
						'type'     => 'color',
						'output'   => array( '.bordered' ),
						'title'    => esc_html__( 'Border Frame Color', 'maco' ),
						'subtitle' => esc_html__( 'Pick a border color for the frame (default: #111111).', 'maco' ),
						'default'  => '#111111',
						'validate' => 'color',
						'required' => array( 'wrap_opt', '=', 'bordered' ),
					),
					array(
						'id'       => 'bordered_width',
						'type'     => 'dimensions',
						'units'    => array('px'),
						'title'    => esc_html__('Border Frame Vertical', 'maco'),
						'subtitle' => esc_html__('Define width for vertical border frame', 'maco'),
						'output'   => array('.bordered.left-border, .bordered.right-border'),
						'height'   => false,
						'default'  => array(
							'Width'   => '25', 
							'Height'  => false
						),
						'required' => array( 'wrap_opt', '=', 'bordered' ),
					),
					array(
						'id'       => 'bordered_height',
						'type'     => 'spacing',
						'output'   => array( '.bordered.bottom-border, .bordered.top-border' ),
						'mode'     => 'padding',
						'all'      => true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Border Frame Horizontal', 'maco' ),
						'subtitle' => esc_html__( 'Define width for horizontal border frame', 'maco' ),
						'default'  => array(
							'padding-top'    => '12px',
							'padding-right'  => '12px',
							'padding-bottom' => '12px',
							'padding-left'   => '12px'
						),
						'required' => array( 'wrap_opt', '=', 'bordered' ),
					),
					/* end of content wrapper type */

					/* 2.3. Boxed Content */
					array(
						'id'       => 'content_boxed',
						'type'     => 'switch',
						'title'    => esc_html__( 'Use Boxed Content', 'maco' ),
						'subtitle' => esc_html__( 'Make your content boxed', 'maco' ),
						'default'  => false,
					),
					array(
						'id'       => 'content_boxed_width',
						'type'     => 'dimensions',
						'units'    => array('px', '%'),
						'title'    => esc_html__('Content Boxed Width.', 'maco'),
						'subtitle' => esc_html__('Define width for content box.', 'maco'),
						'output'   => array('#content'),
						'height'   => false,
						'default'  => array(
							'Width'   => '1170', 
							'Height'  => false
						),
						'required' => array(
							array('content_boxed','=', true),
						),
					),

					/* 2.3.1. Boxed Content Options */
					array(
						'id'       => 'content_padding',
						'type'     => 'spacing',
						'output'   => array( '#content' ),
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Boxed Content', 'maco' ),
						'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
						'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
						'default'  => array(
							'padding-top'    => '0',
							'padding-right'  => '0',
							'padding-bottom' => '0',
							'padding-left'   => '0'
						),
						'required' => array(
							array('content_boxed','=', true),
						),
					),
					array(
						'id'       => 'content_margin',
						'type'     => 'spacing',
						'output'   => array( '#content' ),
						'mode'     => 'margin',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Boxed Content', 'maco' ),
						'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
						'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-right'  => 'auto',
							'margin-bottom' => '0',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array('content_boxed','=', true),
						),
					),
					/* end of content boxed */
				)
			);
			
			/* body content typograpgy */
			$this->sections[] = array(
				'icon' => ' el-icon-fontsize',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'content-typography-sub-id',
				'class' => 'content-typography-sub-class',
				'title' => esc_html__('Content Typography', 'maco'),
				'fields' => array(

					/* main content typography */
					array(
						'id'=>'content-body-font',
						'type' => 'typography', 
						'title' => esc_html__('Body Typography', 'maco'),
						'compiler' => true,
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>true, // Select a backup non-google font in addition to a google font
						'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to false
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website body font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

			                'font-style'  => '300',
			                'font-family' => 'Roboto',
			                'font-backup' => 'Georgia, serif',
			                'font-size'   => '16px',
			                'line-height' => '25.6px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
							'text-align' => 'inherit',
							'google' => true,
						)
					),


					array(
						'id'=>'content-heading-font',
						'type' => 'typography', 
						'compiler' => true,
						'title' => esc_html__('Heading Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>true, // Select a backup non-google font in addition to a google font
						'font-style'=>true, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>false,
						'line-height'=>false,
						'word-spacing'=>false, // Defaults to false
						'letter-spacing'=>false, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(
							
							'font-style'  => '700',
			                'font-family' => 'Oswald',
			                'font-backup' => "'Arial Black', Gadget, sans-serif",
							'text-align' => 'inherit',
							'google' => true,
						)
					),

					/* Heading Type */
					array(
						'id'       => 'content_heading_select',
						'type'     => 'button_set',
						'title'    => 'Heading Type Typography',
						'subtitle' => '',
						'options'  => array(
							'h1_typo'    => esc_html__('H1 Typography', 'maco'),
							'h2_typo'    => esc_html__('H2 Typography', 'maco'),
							'h3_typo'    => esc_html__('H3 Typography', 'maco'),
							'h4_typo'    => esc_html__('H4 Typography', 'maco'),
							'h5_typo'    => esc_html__('H5 Typography', 'maco'),
							'h6_typo'    => esc_html__('H6 Typography', 'maco'),
						),
						'default'  => 'h1_typo',
					),

					array(
						'id'=>'heading1_typo',
						'type' => 'typography', 
						'title' => esc_html__('Heading 1 Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-family'=>false,
						'font-weight'=>false,
						'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'text-align'=>false,
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to true
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'required' => array(
							array( 'content_heading_select', '=', 'h1_typo' ),
						),
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-family' => 'inherit',
							'font-backup' => 'inherit',
							'google'      => true,
							'font-size'   => '42px',
							'line-height' => '47.25px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
						)
					),

					array(
						'id'=>'heading2_typo',
						'type' => 'typography', 
						'title' => esc_html__('Heading 2 Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-family'=>false,
						'font-weight'=>false,
						'text-align'=>false,
						'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to true
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'required' => array(
							array( 'content_heading_select', '=', 'h2_typo' ),
						),
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-family' => 'inherit',
							'font-backup' => 'inherit',
							'google'      => true,
							'font-size'   => '36px',
							'line-height' => '45px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
						)
					),

					array(
						'id'=>'heading3_typo',
						'type' => 'typography', 
						'title' => esc_html__('Heading 3 Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-family'=>false,
						'text-align'=>false,
						'font-weight'=>false,
						'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to true
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'required' => array(
							array( 'content_heading_select', '=', 'h3_typo' ),
						),
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-family' => 'inherit',
							'font-backup' => 'inherit',
							'google'      => true,
							'font-size'   => '24px',
							'line-height' => '30px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
						)
					),

					array(
						'id'=>'heading4_typo',
						'type' => 'typography', 
						'title' => esc_html__('Heading 4 Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-family'=>false,
						'text-align'=>false,
						'font-weight'=>false,
						'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to true
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'required' => array(
							array( 'content_heading_select', '=', 'h4_typo' ),
						),
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-family' => 'inherit',
							'font-backup' => 'inherit',
							'google'      => true,
							'font-size'   => '18px',
							'line-height' => '23.4px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
						)
					),

					array(
						'id'=>'heading5_typo',
						'type' => 'typography', 
						'title' => esc_html__('Heading 5 Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-family'=>false,
						'text-align'=>false,
						'font-weight'=>false,
						'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to true
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'required' => array(
							array( 'content_heading_select', '=', 'h5_typo' ),
						),
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-family' => 'inherit',
							'font-backup' => 'inherit',
							'google'      => true,
							'font-size'   => '16px',
							'line-height' => '22px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
						)
					),

					array(
						'id'=>'heading6_typo',
						'type' => 'typography', 
						'title' => esc_html__('Heading 6 Typography', 'maco'),
						'google'=>true, // Disable google fonts. Won't work if you haven't defined your google api key
						'font-backup'=>false, // Select a backup non-google font in addition to a google font
						'font-family'=>false,
						'text-align'=>false,
						'font-weight'=>false,
						'font-style'=>false, // Includes font-style and weight. Can use font-style or font-weight to declare
						'subsets'=>false, // Only appears if google is true and subsets not set to false
						'font-size'=>true,
						'line-height'=>true,
						'word-spacing'=>true, // Defaults to true
						'letter-spacing'=>true, // Defaults to false
						'color'=>false,
						'preview'=>true, // Disable the previewer
						'required' => array(
							array( 'content_heading_select', '=', 'h6_typo' ),
						),
						'units'=>'px', // Defaults to px
						'subtitle'=> esc_html__('Set website heading font (leave form empty if you want to use default)', 'maco'),
						'default'=> array(

							'font-family' => 'inherit',
							'font-backup' => 'inherit',
							'google'      => true,
							'font-size'   => '14px',
							'line-height' => '19.6px',
							'letter-spacing'=> '0',
							'word-spacing'=> '0',
						)
					),
				),
			);

			/*-----------------------------------------------------------------------------------
				4. Blog Options
					4.1. Blog Pagination Type
					4.2. Blog Padding
			-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-th-list',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'title' => esc_html__('Blog Options', 'maco'),
				'fields' => array(

					array(
						'id'       => 'blog_masonry_column',
						'type'     => 'select',
						'title'    => esc_html__('Blog Column', 'maco'),
						'options'  => array(
							'column-1'   => esc_html__('Column 1', 'maco'),
							'column-2'   => esc_html__('Column 2', 'maco'),
							'column-3'   => esc_html__('Column 3', 'maco'),
							'column-4'   => esc_html__('Column 4', 'maco'),
						),
						'default'  => 'column-3',
					),
					array(
						'id'       => 'loop_blog_style',
						'type'     => 'select',
						'title'    => esc_html__( 'Blog Loop Layout Type', 'maco' ),
						'subtitle' => esc_html__( 'Select Your Blog Loop Layout Type', 'maco' ),
						'options'  => array(
							'fullwidth' => esc_html__( 'Full Width', 'maco' ),
							'sidebar' => esc_html__( 'Sidebar', 'maco' ),
						),
						'default'  => 'fullwidth'
					),
					
					/* 4.1. Blog Pagination Type */
					array(
						'id'       => 'loop_nav_type',
						'type'     => 'select',
						'title'    => esc_html__('Blog Pagination Type', 'maco'),
						'options'  => array(
							'nav_default'   => esc_html__('Default Pagination', 'maco'),
							'nav_pagina'   => esc_html__('Number Pagination', 'maco'),
							'nav_infinite'    => esc_html__('Infinite Loop Pagination', 'maco'),
						),
						'default'  => 'nav_default'
					),
					array(
						'id'       => 'blog_infinite_style',
						'type'     => 'select',
						'title'    => esc_html__('Blog Infinite Button Style', 'maco'),
						'options'  => array(
							'style-1'   => esc_html__('Style 1', 'maco'),
							'style-2'   => esc_html__('Style 2', 'maco'),
							'style-3'    => esc_html__('Style 3', 'maco'),
						),
						'default'  => 'style-1',
						'required' => array(
							array('loop_nav_type','=', array( 'nav_infinite' ))
						),
					),
					/* end of blog pagination type*/

					/* 4.2. Blog Padding */
					array(
						'id'       => 'blog_item_gap',
						'type'     => 'spacing',
						'output'   => array( '.main-blog-loop .blog-item' ),
						'mode'     => 'margin',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'top'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Post Item Margin Bottom', 'maco' ),
						'subtitle' => esc_html__( 'Add a margin gap to each posts.', 'maco' ),
						'default'  => array(
							'margin-top'    => '0px',
							'margin-right'  => 'auto',
							'margin-bottom' => '30px',
							'margin-left'   => 'auto'
						),
					),
					array(
						'id'       => 'blog_padding',
						'type'     => 'spacing',
						'output'   => array( '.blog-content-wrap .blog' ),
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Blog', 'maco' ),
						'subtitle' => esc_html__( 'Padding top and bottom for Blog Page.', 'maco' ),
						'default'  => array(
							'padding-top'    => '60px',
							'padding-right'  => '0',
							'padding-bottom' => '60px',
							'padding-left'   => '0'
						),
					),
					/* end of blog padding */
				)
			);

			/*-----------------------------------------------------------------------------------
				4. Blog Options
					4.1. Blog Pagination Type
					4.2. Blog Padding
			-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-th-list',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'title' => esc_html__('Archive Options', 'maco'),
				'fields' => array(

					array(
						'id'       => 'archive_hide_title',
						'type'     => 'button_set',
						'title'    => esc_html__('Archive Page Hide Title', 'maco'),
						'subtitle' => '',
						'options'  => array(
							'hide_title'     => esc_html__('Hide Title', 'maco'),
							'show_title'     => esc_html__('Show Title', 'maco'),
						),
						'default'  => 'show_title',
					),
					/* end of blog pagination type*/

					/* 4.2. Blog Padding */
					array(
						'id'       => 'archive_padding',
						'type'     => 'spacing',
						'output'   => array( '.archive #content' ),
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Archive', 'maco' ),
						'subtitle' => esc_html__( 'Padding top and bottom for Archive Page.', 'maco' ),
						'default'  => array(
							'padding-top'    => '60px',
							'padding-right'  => '0',
							'padding-bottom' => '60px',
							'padding-left'   => '0'
						),
					),
					/* end of blog padding */
				)
			);

			/*-----------------------------------------------------------------------------------*/
			/*  5. Single Post Options
					5.1. Single Post Layout
					5.2. Single Post Padding
			/*-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-th-list',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'title' => esc_html__('Single Post Options', 'maco'),
				'fields' => array(

					/* 5.1. Single Post Layout */
					array(
						'id'       => 'blog_type',
						'type'     => 'select',
						'title'    => esc_html__( 'Single Post Layout Type', 'maco' ),
						'subtitle' => esc_html__( 'Select Your Single Post Layout Type', 'maco' ),
						'options'  => array(
							'fullwidth' => esc_html__( 'Full Width', 'maco' ),
							'sidebar' => esc_html__( 'Sidebar', 'maco' ),
						),
						'default'  => 'sidebar'
					),
					/* end of single post layout */

					/* 5.2. Single Post Padding */
					array(
						'id'       => 'single_blog_padding',
						'type'     => 'spacing',
						'output'   => array( '.single-post-wrap .blog' ),
						'mode'     => 'padding',
						'all'      => false,
						'top'           => true,
						'bottom'        => true,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Single Post', 'maco' ),
						'subtitle' => esc_html__( 'Padding top and bottom for Single Post.', 'maco' ),
						'default'  => array(
							'padding-top'    => '60px',
							'padding-right'  => '0',
							'padding-bottom' => '60px',
							'padding-left'   => '0'
						),
					),
					/* end of single post padding */
				),
			);

			/*-----------------------------------------------------------------------------------*/
			/*  6. Single Portfolio Options
					6.1. Single Portfolio Style
					6.2. Single Portfolio Padding
					6.3. Single Portfolio Link
			/*-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-th-list',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'title' => esc_html__('Single Portfolio Options', 'maco'),
				'fields' => array(

					/* 6.1. Single Portfolio Padding */
					array(
						'id'       => 'single_porto_style',
						'type'     => 'select',
						'title'    => esc_html__('Single Portfolio Style', 'maco'),
						'options'  => array(
							'style-1'   => esc_html__('Single Portfolio 1', 'maco'),
							'style-2'   => esc_html__('Single Portfolio 2', 'maco'),
							'use-builder'    => esc_html__('Single Portfolio Builder', 'maco'),
						),
						'default'  => 'style-1',
					),

					/* 6.2. Single Portfolio Padding */
					array(
						'id'       => 'single_porto_padding',
						'type'     => 'spacing',
						'output'   => array( '.single-portfolio-wrap' ),
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Single Portfolio', 'maco' ),
						'subtitle' => esc_html__( 'Padding top and bottom for Single Portfolio.', 'maco' ),
						'default'  => array(
							'padding-top'    => '60',
							'padding-right'  => '0',
							'padding-bottom' => '60',
							'padding-left'   => '0'
						),
					),
					/* end of single post padding */

					/* 6.3. Single Portfolio Link */
					array(
						'id'=>'portfolio_back_link',
						'type'     => 'select',
						'data'     => 'pages',
						'args'  => array(
							'posts_per_page' => -1,
						),
						'title' => esc_html__('Portfolio Link Page', 'maco'),
						'subtitle' => esc_html__( 'Insert your portfolio page link.', 'maco' ),
						'desc' => esc_html__( 'This link will work in single portfolio default as back button link.', 'maco' ),
					),
				)
			);

			/*-----------------------------------------------------------------------------------
				7. 404 Options
			-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-th-list',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'title' => esc_html__('404 Options', 'maco'),
				'fields' => array(

					/* 404 Background Image */
					array(
						'id' => '404_img_bg',
						'type' => 'background',
						'output' => array('body.error404'),
						'title' => esc_html__('404 Body Background', 'maco'),
						'subtitle' => esc_html__('404 background with image, color, etc.', 'maco'),
						'default' => '',
					),
					/* end of 404 background image */
				)
			);

			/*-----------------------------------------------------------------------------------
				8. Page Loader Options
			-----------------------------------------------------------------------------------*/
			$this->sections[] = array(
				'icon' => 'el-icon-refresh',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'title' => esc_html__('Page Loader Options', 'maco'),
				'fields' => array(

					/* 404 Background Image */
					array(
						'id' => 'page_loader_bg',
						'type' => 'background',
						'output' => array('#preloader'),
						'title' => esc_html__('Loader Background', 'maco'),
						'subtitle' => esc_html__('404 background with image, color, etc.', 'maco'),
						'default' => '',
					),

					array(
						'id' 		=> 'page_loader_img',
						'type' 		=> 'media',
						'url' 		=> true,
						'compiler' 	=> 'true',
						'title'    	=> esc_html__( 'Loader Image', 'maco' ),
						'subtitle' 	=> esc_html__( 'Format GIF is better.', 'maco' ),
						'default'  	=> array(
							'url'	=>''
						),
					),

					array(
						'id'       => 'loader_size',
						'type'     => 'dimensions',
						'units'    => array('px'),
						'title'    => esc_html__('Loader Size.', 'maco'),
						'subtitle' => esc_html__('Define size for loader image (px)', 'maco'),
						'default'  => array(
							'Width'   => '40', 
							'Height'  => '40'
						),
					),
					/* end of 404 background image */
				)
			);

			/*-----------------------------------------------------------------------------------
				3. Footer Options
					3.1. Footer Style Type
					3.2. Footer Type
					3.3. Footer Container
					3.4. Footer Padding
					3.5. Boxed Footer
					3.6. Footer 2 Options
					3.7. Footer Options
			-----------------------------------------------------------------------------------*/

			$this->sections[] = array(
				'icon' => ' el-icon-photo',
				'icon_class' => 'icon-large',
				'title' => esc_html__('Footer Builder', 'maco'),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-photo',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'footer-general-sub-id',
				'class' => 'footer-general-sub-class',
				'title' => esc_html__('General Footer', 'maco'),
				'fields' => array(

					/* 3.1. Footer Style Type */
					array(
						'id'       => 'footer_style_type',
						'type'     => 'select',
						'title'    => esc_html__('Footer Style Type', 'maco'),
						'options'  => array(
							'bottom-footer'		=> esc_html__('Always on Bottom of desktop.', 'maco'),
							'fixed-footer'		=> esc_html__('Fixed Footer.', 'maco'),
						),
						'default'  => 'bottom-footer'
					),
					/* end of footer style type*/

					/* 3.2. Footer Type */
					array(
						'id'       => 'footer_type',
						'type'     => 'image_select',
						'title'    => esc_html__( 'Footer Type', 'maco' ),
						'subtitle' => esc_html__( 'Select Your Footer Type', 'maco' ),
						'options' => array(
							'no-footer' => array('alt' => 'no-footer', 'img' => get_template_directory_uri() .'/img/footer-no.png'),
							'default' => array('alt' => 'default', 'img' => get_template_directory_uri() .'/img/footer-1.png'),
						),
						'default'  => 'default'
					),
					
					array(
						'id'       => 'footer_general_opt_select',
						'type'     => 'button_set',
						'title'    => '',
						'subtitle' => '',
						'options'  => array(
							'footer-dimensions'		=> esc_html__('Footer Dimensions', 'maco'),
							'footer-background' 	=> esc_html__('Footer Background', 'maco'),
							'footer-features'		=> esc_html__('Footer Features', 'maco'),
						),
						'default'  => 'footer-dimensions'
					),

					/* 3.3. Footer Container */
					/* end of footer container */

					/* 3.4. Footer Padding */
					array(
						'id'       => 'footer_padding',
						'type'     => 'spacing',
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Footer', 'maco' ),
						'subtitle' => esc_html__( 'Allow your users to choose the spacing or padding they want.', 'maco' ),
						'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
						'default'  => array(
							'padding-top'    => '40px',
							'padding-right'  => '0',
							'padding-bottom' => '40px',
							'padding-left'   => '0'
						),
						'required' => array( 
							array( 'footer_type', '=', array('default')),
							array( 'footer_general_opt_select', '=', 'footer-dimensions' ),
						),
					),

					/* footer fatures */
					array(
						'id' => 'foot_logo',
						'type' => 'media',
						'url' => true,
						'compiler' => 'true',
						'title' => esc_html__('Footer Logo', 'maco'), 
						'desc' => esc_html__('Upload your logo image here (any size).', 'maco'),
						'required' => array( 
							array( 'footer_type', '=', array('default')),
							array( 'footer_general_opt_select', '=', 'footer-features' ),
						),
					),

					array(
						'id' => 'foot_address',
						'type' => 'textarea',
						'title' => esc_html__('Footer Address', 'maco'), 
						'required' => array( 
							array( 'footer_type', '=', array('default')),
							array( 'footer_general_opt_select', '=', 'footer-features' ),
						),
					),

					array(
						'id'=>'footer-text',
						'type' => 'editor',
						'title' => esc_html__('Footer Copyright', 'maco'), 
						'subtitle' => esc_html__('Add Your Copyright Here', 'maco'),
						'default' => esc_html__('Built by Themes Awesome', 'maco'),
						'required' => array(
							array( 'footer_type', '=', array('default') ),
							array( 'footer_general_opt_select', '=', 'footer-features' ),
						),
					),

					/* 3.5. Boxed Footer */
					array(
						'id' => 'footer_background',
						'type' => 'background',
						'title' => esc_html__('Footer Custom Background', 'maco'),
						'subtitle' => esc_html__('Footer background with image, color, etc.', 'maco'),
						'default' => array(
							'background-color'  => '#111111',
							'background-repeat'  => 'no-repeat',
							'background-size'  => 'inherit',
							'background-attachment'  => 'inherit',
							'background-position'  => 'center center',
						),
						'required' => array(
							array( 'footer_general_opt_select', '=', 'footer-background' ),
						),
					),
					array(
						'id'       => 'footer_boxed',
						'type'     => 'switch',
						'title'    => esc_html__( 'Use Boxed Footer', 'maco' ),
						'subtitle' => esc_html__( 'Make your footer boxed', 'maco' ),
						'default'  => false,
						'required' => array(
							array( 'footer_type', '=', array('default')),
						),
					),
					array(
						'id'       => 'footer_boxed_width',
						'type'     => 'dimensions',
						'units'    => array('px', '%'),
						'title'    => esc_html__('Content Boxed Width.', 'maco'),
						'subtitle' => esc_html__('Define width for footer box.', 'maco'),
						'output'   => array('#footer'),
						'height'   => false,
						'default'  => array(
							'Width'   => '1170', 
							'Height'  => false
						),
						'required' => array(
							array('footer_boxed','=', true),
						),
					),
					array(
						'id'       => 'footer_margin',
						'type'     => 'spacing',
						'output'   => array( '#footer' ),
						'mode'     => 'margin',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Boxed Footer', 'maco' ),
						'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
						'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-right'  => 'auto',
							'margin-bottom' => '0',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array('footer_boxed','=', true),
						),
					),
					
					/* 3.6. Footer 2 Options */
				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-photo',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'footer-style-sub-id',
				'class' => 'footer-style-sub-class',
				'title' => esc_html__('Footer Style', 'maco'),
				'fields' => array(

					array(
						'id'=>'footer_layout',
						'type' => 'image_select',
						'compiler'=>true,
						'title' => esc_html__('Footer Column Layout', 'maco'), 
						'subtitle' => esc_html__('Select footer between 1, 2, 3 or 4 column layout.', 'maco'),
						'options' => array(
								'1column-footer' => array('alt' => esc_html__( '1column-footer', 'maco' ), 'img' => get_template_directory_uri() .'/img/col-opt1.png'),
								'2column-footer' => array('alt' => esc_html__( '2column-footer', 'maco' ), 'img' => get_template_directory_uri() .'/img/col-opt2.png'),
								'3column-footer' => array('alt' => esc_html__( '3column-footer', 'maco' ), 'img' => get_template_directory_uri() .'/img/col-opt3.png'),
								'4column-footer' => array('alt' => esc_html__( '4column-footer', 'maco' ), 'img' => get_template_directory_uri() .'/img/col-opt4.png'),
							),
						'default' => '1column-footer',
						'required' => array( 'footer_type', '=', 'default' ),
					),
					array(
						'id'       => 'footer_col_4',
						'type'     => 'button_set',
						'options'  => array(
							'footer_col_1_sec'     => esc_html__( 'Footer First Column', 'maco' ),
							'footer_col_2_sec'     => esc_html__( 'Footer Second Column', 'maco' ),
							'footer_col_3_sec'     => esc_html__( 'Footer Third Column', 'maco' ),
							'footer_col_4_sec'     => esc_html__( 'Footer Fourth Column', 'maco' ),
						),
						'default'  => 'footer_col_1_sec',
						'required' => array( 'footer_type', '=', 'default' ),
					),

					/* 1st footer column */
					array(
						'id'       => 'foot_style_col1_set',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Footer Column 1 Setting', 'maco' ),
						'options'  => array(
							'footer_col1_content'	=> esc_html__( 'Column 1 Content', 'maco' ),
							'footer_col1_display'	=> esc_html__( 'Column 1 Display', 'maco' ),
							'footer_col1_align'		=> esc_html__( 'Column 1 Align', 'maco' ),
							'footer_col1_margin'	=> esc_html__( 'Column 1 Margin', 'maco' ),
						),
						'default'  => 'footer_col1_content',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_1_sec' ),
						),
					),
					array(
						'id'      => 'footer_customize_first',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Footer First Column', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the footer first column', 'maco' ),
						'options' => array(
							'enabled'  => array(
								'maco-copyright' => esc_html__('Copyright','maco'),
							),
							'disabled' => array(
								'maco-social'   => esc_html__('Social','maco'),
								'maco-foot-text'   => esc_html__('Text','maco'),
								'maco-foot-logo' => esc_html__('Footer Logo','maco'),
								'maco-foot-menu' => esc_html__('Footer Menu','maco'),
							)
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_1_sec' ),
							array( 'foot_style_col1_set', '=', 'footer_col1_content' ),
						),
					),
					array(
						'id'       => 'footer_first_display',
						'type'     => 'select',
						'title'    => esc_html__('Footer First Column Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'vertical',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_1_sec' ),
							array( 'foot_style_col1_set', '=', 'footer_col1_display' ),
						),
					),
					array(
						'id'       => 'foot_col1_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Footer Column 1 Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__( 'Text Left', 'maco' ),
							'text-center' => esc_html__( 'Text Center', 'maco' ),
							'text-right' => esc_html__( 'Text Right', 'maco' )
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_1_sec' ),
							array( 'foot_style_col1_set', '=', 'footer_col1_align' ),
						),
						'default'  => 'text-left'
					),
					array(
						'id'       => 'foot_col1_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'top'         => true,
						'left'          => true,
						'bottom'         => true,
						'right'          => true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Footer Column Item', 'maco' ),
						'default'  => array(
							'margin-top'    => '0px',
							'margin-right'  => 'auto',
							'margin-bottom' => '0px',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_1_sec' ),
							array( 'foot_style_col1_set', '=', 'footer_col1_margin' ),
						),
					),

					/* 2nd footer column */
					array(
						'id'       => 'foot_style_col2_set',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Footer Column 2 Setting', 'maco' ),
						'options'  => array(
							'footer_col2_content'	=> esc_html__( 'Column 2 Content', 'maco' ),
							'footer_col2_display'	=> esc_html__( 'Column 2 Display', 'maco' ),
							'footer_col2_align'		=> esc_html__( 'Column 2 Align', 'maco' ),
							'footer_col2_margin'	=> esc_html__( 'Column 2 Margin', 'maco' ),
						),
						'default'  => 'footer_col2_content',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_2_sec' ),
						),
					),
					array(
						'id'      => 'footer_customize_second',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Footer Second Column', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the footer second column', 'maco' ),
						'options' => array(
							'enabled'  => array(
								'maco-foot-text'   => esc_html__('Text','maco'),
							),
							'disabled' => array(
								'maco-social'   => esc_html__('Social','maco'),
								'maco-copyright' => esc_html__('Copyright','maco'),
								'maco-foot-logo' => esc_html__('Footer Logo','maco'),
								'maco-foot-menu' => esc_html__('Footer Menu','maco'),
							)
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_2_sec' ),
							array( 'foot_style_col2_set', '=', 'footer_col2_content' ),
						),
					),
					array(
						'id'       => 'footer_second_display',
						'type'     => 'select',
						'title'    => esc_html__('Footer Second Column Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'vertical',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_2_sec' ),
							array( 'foot_style_col2_set', '=', 'footer_col2_display' ),
						),
					),
					array(
						'id'       => 'foot_col2_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Footer Column 2 Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__('Text Left', 'maco'),
							'text-center' => esc_html__('Text Center', 'maco'),
							'text-right' => esc_html__('Text Right', 'maco')
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_2_sec' ),
							array( 'foot_style_col2_set', '=', 'footer_col2_align' ),
						),
						'default'  => 'text-left'
					),
					array(
						'id'       => 'foot_col2_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'top'         => true,
						'left'          => true,
						'bottom'         => true,
						'right'          => true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Footer Column Item', 'maco' ),
						'default'  => array(
							'margin-top'    => '0px',
							'margin-right'  => 'auto',
							'margin-bottom' => '0px',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '2column-footer', '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_2_sec' ),
							array( 'foot_style_col2_set', '=', 'footer_col2_margin' ),
						),
					),
					array(
						'id'    => 'footer_col2_notif',
						'type'  => 'info',
						'notice' => false,
						'title' => esc_html__( 'Second Column not available for current choice.', 'maco' ),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', '1column-footer' ),
							array( 'footer_col_4', '=', 'footer_col_2_sec' ),
						),
					),

					/* 3rd footer column */
					array(
						'id'       => 'foot_style_col3_set',
						'type'     => 'button_set',
						'title'    => esc_html__('Footer Column 3 Setting', 'maco'),
						'options'  => array(
							'footer_col3_content'	=> esc_html__('Column 3 Content', 'maco'),
							'footer_col3_display'	=> esc_html__('Column 3 Display', 'maco'),
							'footer_col3_align'		=> esc_html__('Column 3 Align', 'maco'),
							'footer_col3_margin'	=> esc_html__('Column 3 Margin', 'maco'),
						),
						'default'  => 'footer_col3_content',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_3_sec' ),
						),
					),
					array(
						'id'      => 'footer_customize_third',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Footer Third Column', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the footer third column', 'maco' ),
						'options' => array(
							'enabled'  => array(
								'maco-foot-logo' => esc_html__('Footer Logo','maco'),
							),
							'disabled' => array(
								'maco-social'   => esc_html__('Social','maco'),
								'maco-foot-text'   => esc_html__('Text','maco'),
								'maco-copyright' => esc_html__('Copyright','maco'),
								'maco-foot-menu' => esc_html__('Footer Menu','maco'),
							)
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_3_sec' ),
							array( 'foot_style_col3_set', '=', 'footer_col3_content' ),
						),
					),
					array(
						'id'       => 'footer_third_display',
						'type'     => 'select',
						'title'    => esc_html__('Footer Third Column Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'vertical',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_3_sec' ),
							array( 'foot_style_col3_set', '=', 'footer_col3_display' ),
						),
					),
					array(
						'id'       => 'foot_col3_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Footer Column 3 Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__('Text Left', 'maco'),
							'text-center' => esc_html__('Text Center', 'maco'),
							'text-right' => esc_html__('Text Right', 'maco')
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_3_sec' ),
							array( 'foot_style_col3_set', '=', 'footer_col3_align' ),
						),
						'default'  => 'text-left'
					),
					array(
						'id'       => 'foot_col3_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'top'         => true,
						'left'          => true,
						'bottom'         => true,
						'right'          => true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Footer Column Item', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-right'  => 'auto',
							'margin-bottom' => '0',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '3column-footer', '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_3_sec' ),
							array( 'foot_style_col3_set', '=', 'footer_col3_margin' ),
						),
					),
					array(
						'id'    => 'footer_col3_notif',
						'type'  => 'info',
						'notice' => false,
						'title' => esc_html__( 'Third Column not available for current choice.', 'maco' ),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_3_sec' ),
						),
					),

					/* 4th footer column */
					array(
						'id'       => 'foot_style_col4_set',
						'type'     => 'button_set',
						'title'    => esc_html__('Footer Column 4 Setting', 'maco'),
						'options'  => array(
							'footer_col4_content'	=> esc_html__('Column 4 Content', 'maco'),
							'footer_col4_display'	=> esc_html__('Column 4 Display', 'maco'),
							'footer_col4_align'		=> esc_html__('Column 4 Align', 'maco'),
							'footer_col4_margin'	=> esc_html__('Column 4 Margin', 'maco'),
						),
						'default'  => 'footer_col4_content',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_4_sec' ),
						),
					),
					array(
						'id'      => 'footer_customize_fourth',
						'type'    => 'sorter',
						'title'   => esc_html__( 'Footer Fourth Column', 'maco' ),
						'desc'    => esc_html__( 'Organize how you want the layout to appear on the footer fourth column', 'maco' ),
						'options' => array(
							'enabled'  => array(
								'maco-social'   => esc_html__('Social','maco'),
							),
							'disabled' => array(
								'maco-foot-text'   => esc_html__('Text','maco'),
								'maco-copyright' => esc_html__('Copyright','maco'),
								'maco-foot-logo' => esc_html__('Footer Logo','maco'),
								'maco-foot-menu' => esc_html__('Footer Menu','maco'),
							)
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_4_sec' ),
							array( 'foot_style_col4_set', '=', 'footer_col4_content' ),
						),
					),
					array(
						'id'       => 'footer_fourth_display',
						'type'     => 'select',
						'title'    => esc_html__('Footer Fourth Column Display', 'maco'),
						'options'  => array(
							'horizontal'		=> esc_html__('Horizontal Item', 'maco'),
							'vertical'		=> esc_html__('Vertical Item', 'maco'),
						),
						'default'  => 'vertical',
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_4_sec' ),
							array( 'foot_style_col4_set', '=', 'footer_col4_display' ),
						),
					),
					array(
						'id'       => 'foot_col4_align',
						'type'     => 'button_set',
						'title'    => esc_html__( 'Footer Column 4 Align', 'maco' ),
						'options'  => array(
							'text-left' => esc_html__('Text Left', 'maco'),
							'text-center' => esc_html__('Text Center', 'maco'),
							'text-right' => esc_html__('Text Right', 'maco')
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_4_sec' ),
							array( 'foot_style_col4_set', '=', 'footer_col4_align' ),
						),
						'default'  => 'text-left'
					),

					array(
						'id'       => 'foot_col4_margin',
						'type'     => 'spacing',
						'mode'     => 'margin',
						'all'      => false,
						'top'         => true,
						'left'          => true,
						'bottom'         => true,
						'right'          => true,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Margin Footer Column Item', 'maco' ),
						'default'  => array(
							'margin-top'    => '0',
							'margin-right'  => 'auto',
							'margin-bottom' => '0',
							'margin-left'   => 'auto'
						),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '4column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_4_sec' ),
							array( 'foot_style_col4_set', '=', 'footer_col4_margin' ),
						),
					),
					array(
						'id'    => 'footer_col4_notif',
						'type'  => 'info',
						'notice' => false,
						'title' => esc_html__( 'Fourth Column not available for current choice.', 'maco' ),
						'required' => array(
							array( 'footer_type', '=', 'default' ),
							array( 'footer_layout', '=', array( '1column-footer', '2column-footer', '3column-footer' )),
							array( 'footer_col_4', '=', 'footer_col_4_sec' ),
						),
					),

					/* end of footer style type*/
				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-photo',
				'icon_class' => 'icon-large',
				'subsection' => true,
				'id' => 'footer-widget-sub-id',
				'class' => 'footer-widget-sub-class',
				'title' => esc_html__('Footer Widget', 'maco'),
				'fields' => array(

					/* 3.7. Footer Options */
					array(
						'id'=>'footer-layout',
						'type' => 'image_select',
						'compiler'=>true,
						'title' => esc_html__('Footer Widget Layout', 'maco'), 
						'subtitle' => esc_html__('Select footer and widget alignment. Choose between 1, 2, 3 or 4 column layout.', 'maco'),
						'options' => array(
								'1widget-footer' => array('alt' => esc_html__('1widget-footer', 'maco'), 'img' => get_template_directory_uri() .'/img/widget-1.png'),
								'2widget-footer' => array('alt' => esc_html__('2widget-footer', 'maco'), 'img' => get_template_directory_uri() .'/img/widget-2.png'),
								'3widget-footer' => array('alt' => esc_html__('3widget-footer', 'maco'), 'img' => get_template_directory_uri() .'/img/widget-3.png'),
								'4widget-footer' => array('alt' => esc_html__('4widget-footer', 'maco'), 'img' => get_template_directory_uri() .'/img/widget-4.png')
							),
						'default' => '3widget-footer',
						'required' => array( 'footer_type', '=', array('default') ),
					),

					/* 3.8. Footer Area Padding */
					array(
						'id'       => 'footer_widget_padding',
						'type'     => 'spacing',
						'output'   => array( '#footer .footer-widget-wrapper' ),
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Footer Widget', 'maco' ),
						'default'  => array(
							'padding-top'    => '0',
							'padding-right'  => '0',
							'padding-bottom' => '0',
							'padding-left'   => '0'
						),
						'required' => array( 'footer_type', '=', array('default') ),
					),
					array(
						'id'       => 'footer_bottom_padding',
						'type'     => 'spacing',
						'output'   => array( '#footer .footer-bottom' ),
						'mode'     => 'padding',
						'all'      => false,
						'right'         => false,
						'left'          => false,
						'units'         => array( 'px' ),
						'units_extended'=> 'true',
						'display_units' => 'true',
						'title'    => esc_html__( 'Padding Footer Bottom', 'maco' ),
						'default'  => array(
							'padding-top'    => '0',
							'padding-right'  => '0',
							'padding-bottom' => '0',
							'padding-left'   => '0'
						),
						'required' => array( 'footer_type', '=', array('default') ),
					),
					array(
						'id'       => 'footer_widget_border',
						'type'     => 'border',
						'title'    => esc_html__( 'Footer Widget Border', 'maco' ),
						'output'   => array( '.footer-widget-wrapper' ),
						'all'      => false,
						'default'  => array(
							'border-color'  => '#efefef',
							'border-style'  => 'solid',
							'border-top'    => '0px',
							'border-right'  => false,
							'border-bottom' => false,
							'border-left'   => false,
						)
					),
					array(
						'id'       => 'footer_bottom_border',
						'type'     => 'border',
						'title'    => esc_html__( 'Footer Bottom Border', 'maco' ),
						'output'   => array( '.footer-bottom' ),
						'all'      => false,
						'default'  => array(
							'border-color'  => '#efefef',
							'border-style'  => 'solid',
							'border-top'    => '0px',
							'border-right'  => false,
							'border-bottom' => false,
							'border-left'   => false,
						)
					),

				),
			);

			$this->sections[] = array(
				'icon' => ' el-icon-credit-card',
				'icon_class' => 'icon-large',
				'title' => esc_html__('Other Options', 'maco'),
			);

			$this->sections[] = array(
				'icon' => 'el-icon-twitter',
				'title' => esc_html__('Social Profile', 'maco'),
				'subsection' => true,
				'fields' => array(

					array(
						'id'=>'facebook_profile',
						'type' => 'text',
						'title' => esc_html__('Facebook Profile', 'maco'),
						'validate' => 'url',
						'default' => 'http://facebook.com/#'
						),

					array(
						'id'=>'twitter_profile',
						'type' => 'text',
						'title' => esc_html__('twitter Profile', 'maco'),
						'validate' => 'url',
						'default' => 'http://twitter.com/#'
						),


					array(
						'id'=>'google_profile',
						'type' => 'text',
						'title' => esc_html__('Google+ Profile', 'maco'),
						'validate' => 'url',
						'default' => 'http://google.com/#'
						),


					array(
						'id'=>'linkedin_profile',
						'type' => 'text',
						'title' => esc_html__('linkedin Profile', 'maco'),
						'validate' => 'url',
						'default' => 'http://linkedin.com/#'
						),


					array(
						'id'=>'pinterest_profile',
						'type' => 'text',
						'title' => esc_html__('Pinterest Profile', 'maco'),
						'validate' => 'url',
						'default' => 'http://pinterest.com/#'
						),

					array(
						'id'=>'dribble_profile',
						'type' => 'text',
						'title' => esc_html__('Dribble Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'flickr_profile',
						'type' => 'text',
						'title' => esc_html__('Flickr Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'behance_profile',
						'type' => 'text',
						'title' => esc_html__('Behance Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'youtube_profile',
						'type' => 'text',
						'title' => esc_html__('Youtube Profile', 'maco'),
						'validate' => 'url',
						'default' => 'https://www.youtube.com/'
						),

					array(
						'id'=>'soundcloud_profile',
						'type' => 'text',
						'title' => esc_html__('Soundcloud Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'codepen_profile',
						'type' => 'text',
						'title' => esc_html__('Codepen Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'deviantart_profile',
						'type' => 'text',
						'title' => esc_html__('Deviantart Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'digg_profile',
						'type' => 'text',
						'title' => esc_html__('Digg Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'dropbox_profile',
						'type' => 'text',
						'title' => esc_html__('Dropbox Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'github_profile',
						'type' => 'text',
						'title' => esc_html__('Github Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'instagram_profile',
						'type' => 'text',
						'title' => esc_html__('Instagram Profile', 'maco'),
						'validate' => 'url',
						'default' => 'https://instagram.com/'
						),

					array(
						'id'=>'skype_profile',
						'type' => 'text',
						'title' => esc_html__('Skype Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'spotify_profile',
						'type' => 'text',
						'title' => esc_html__('Spotify Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'steam_profile',
						'type' => 'text',
						'title' => esc_html__('Steam Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'trello_profile',
						'type' => 'text',
						'title' => esc_html__('Trello Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'tumblr_profile',
						'type' => 'text',
						'title' => esc_html__('Tumblr Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'vimeo_profile',
						'type' => 'text',
						'title' => esc_html__('Vimeo Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'wechat_profile',
						'type' => 'text',
						'title' => esc_html__('Wechat Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'weibo_profile',
						'type' => 'text',
						'title' => esc_html__('Weibo Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'wordpress_profile',
						'type' => 'text',
						'title' => esc_html__('WordPress Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'xing_profile',
						'type' => 'text',
						'title' => esc_html__('Xing Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'yahoo_profile',
						'type' => 'text',
						'title' => esc_html__('Yahoo Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),

					array(
						'id'=>'yelp_profile',
						'type' => 'text',
						'title' => esc_html__('Yelp Profile', 'maco'),
						'validate' => 'url',
						'default' => ''
						),
					/* end of single post padding */
				),
			);
		}

		public function setHelpTabs() {

			// Custom page help tabs, displayed using the help API. Tabs are shown in order of definition.
			$this->args['help_tabs'][] = array(
				'id' => 'redux-opts-1',
				'title' => esc_html__('Theme Information 1', 'maco'),
				'content' => esc_html__('<p>Please go to themesawesome.com to get support</p>', 'maco')
			);
		}


		public function setArguments() {

			$theme = wp_get_theme(); // For use with some settings. Not necessary.

			$this->args = array(
				// TYPICAL -> Change these values as you need/desire
				'opt_name' => 'maco_framework', // This is where your data is stored in the database and also becomes your global variable name.
				'display_name' => $theme->get('Name'), // Name that appears at the top of your panel
				'display_version' => $theme->get('Version'), // Version that appears at the top of your panel
				'menu_type' => 'menu', //Specify if the admin menu should appear or not. Options: menu or submenu (Under appearance only)
				'allow_sub_menu' => true, // Show the sections below the admin menu item or not
				'menu_title' => esc_html__('Options', 'maco'),
				'page' => esc_html__('Options', 'maco'),
				// You will need to generate a Google API key to use this feature.
				// Please visit: https://developers.google.com/fonts/docs/developer_api#Auth
				'google_api_key' => 'AIzaSyAX_2L_UzCDPEnAHTG7zhESRVpMPS4ssII', // Must be defined to add google fonts to the typography module
				//'admin_bar' => false, // Show the panel pages on the admin bar
				'global_variable' => '', // Set a different name for your global variable other than the opt_name
				'dev_mode' => false, // Show the time the page took to load, etc
				'customizer' => false, // Enable basic customizer support
				// OPTIONAL -> Give you extra features
				'page_priority' => null, // Order where the menu appears in the admin area. If there is any conflict, something will not show. Warning.
				'page_parent' => 'themes.php', // For a full list of options, visit: http://codex.wordpress.org/Function_Reference/add_submenu_page#Parameters
				'page_permissions' => 'manage_options', // Permissions needed to access the options panel.
				'menu_icon' => '', // Specify a custom URL to an icon
				'last_tab' => '', // Force your panel to always open to a specific tab (by id)
				'page_icon' => 'icon-themes', // Icon displayed in the admin panel next to your menu_title
				'page_slug' => '_options', // Page slug used to denote the panel
				'save_defaults' => true, // On load save the defaults to DB before user clicks save or not
				'default_show' => true, // If true, shows the default value next to each field that is not the default value.
				'default_mark' => '', // What to print by the field's title if the value shown is default. Suggested: *
				// CAREFUL -> These options are for advanced use only
				'transient_time' => 60 * MINUTE_IN_SECONDS,
				'output' => true, // Global shut-off for dynamic CSS output by the framework. Will also disable google fonts output
				'output_tag' => true, // Allows dynamic CSS to be generated for customizer and google fonts, but stops the dynamic CSS from going to the head
				//'domain'              => 'redux-framework', // Translation domain key. Don't change this unless you want to retranslate all of Redux.
				//'footer_credit'       => '', // Disable the footer credit of Redux. Please leave if you can help it.
				// FUTURE -> Not in use yet, but reserved or partially implemented. Use at your own risk.
				'database' => '', // possible: options, theme_mods, theme_mods_expanded, transient. Not fully functional, warning!
				'show_import_export' => true, // REMOVE
				'system_info' => false, // REMOVE
				'help_tabs' => array(),
				'help_sidebar' => '', // esc_html__( '', $this->args['domain'] );            
			);


		}

	}

	new MACO_Framework_Config();
}

function maco_footer_copyright() {


	$options = get_option('maco_framework');
	$copyright_footer = $options['footer-text'];
	if(!empty($copyright_footer)) {
		echo wp_specialchars_decode( $copyright_footer );
	}
}