<?php

function maco_header_general_ext_opt() {

	$maco_header_general_opt = array(

		/* 1.2. Header Type */
		array(
			'id'       => 'header_animated',
			'type'     => 'switch',
			'title'    => esc_html__( 'Use Animated Header', 'maco' ),
			'subtitle' => esc_html__( 'Make your header animated after page loaded', 'maco' ),
			'default'  => true,
		),
		array(
			'id'       => 'fixed_header',
			'type'     => 'switch',
			'title'    => esc_html__( 'Use Fixed Header', 'maco' ),
			'subtitle' => esc_html__( 'Make your header as sticky header.', 'maco' ),
			'default'  => false,
		),
		array(
			'id'       => 'header_fixed_type',
			'type'     => 'select',
			'title'    => esc_html__( 'Header Fixed Type', 'maco' ),
			'options'  => array(
				'header_fixed_noscroll'     => esc_html__( 'Header Fixed No Scroll', 'maco' ),
				'header_fixed_scroll'     => esc_html__( 'Header Fixed Scroll', 'maco' ),
			),
			'default'  => 'header_fixed_noscroll',
			'required' => array(
				array( 'fixed_header', '=', true ),
			),
		),
		array(
			'id'       => 'space_when_scroll',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'all'      => false,
			'right'         => false,
			'left'         => false,
			'bottom'         => false,
			'units'         => array( 'px' ),
			'units_extended'=> 'true',
			'display_units' => 'true',
			'title'    => esc_html__( 'Header Space When Scroll', 'maco' ),
			'default'  => array(
				'padding-top'    => '40px',
				'padding-right'  => '0',
				'padding-bottom' => '40px',
				'padding-left'   => '0'
			),
			'required' => array(
				array( 'header_fixed_type', '=', 'header_fixed_scroll' ),
			),
		),

		/* end of header type */

		/* logo dimensions tab */
		array(
			'id'       => 'header_general_opt_select',
			'type'     => 'button_set',
			'title'    => '',
			'subtitle' => '',
			'options'  => array(
				'header-logo'     => esc_html__( 'Header Logo', 'maco' ),
				'header-dimension'   => esc_html__( 'Header Dimensions', 'maco' ),
				'header-background'   => esc_html__( 'Header Background', 'maco' ),
				'header-widget'		=> esc_html__( 'Header Widget', 'maco' ),
			),
			'default'  => 'header-logo'
		),
		/* end of header_general_opt_select */

		array(
			'id' 		=> 'logo_upload',
			'type' 		=> 'media',
			'url' 		=> true,
			'compiler' 	=> 'true',
			'title'    	=> esc_html__( 'Header Logo', 'maco' ),
			'default'  	=> array(
				'url'	=>''
			),
			'required' 	=> array( 'header_general_opt_select', '=', 'header-logo' ),
		),
		array(
			'id'       => 'logo_padding',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'all'      => false,
			'right'    => false,
			'left'     => false, 
			'units'         => array( 'px' ),
			'units_extended'=> 'true',
			'display_units' => 'true',
			'title'    => esc_html__( 'Padding Logo', 'maco' ),
			'subtitle' => esc_html__( 'A gap space for your logo image and title.', 'maco' ),
			'default'  => array(
				'padding-top'    => '5px',
				'padding-bottom' => '0',
			),
			'required' 	=> array( 'header_general_opt_select', '=', 'header-logo' ),
		),

		/* header dimensions */
		array(
			'id'       => 'header_container_width',
			'type'     => 'dimensions',
			'units'    => array('px', '%'),
			'title'    => esc_html__('Header Container Width.', 'maco'),
			'subtitle' => esc_html__('Define width for header container', 'maco'),
			'height'   => false,
			'default'  => array(
				'width'   => '1170', 
				'Height'  => false
			),
			'required' => array(
				array( 'header_general_opt_select', '=', 'header-dimension' ),
			),
		),

		array(
			'id'       => 'header_padding',
			'type'     => 'spacing',
			'mode'     => 'padding',
			'all'      => false,
			'units'         => array( 'px' ),
			'units_extended'=> 'true',
			'display_units' => 'true',
			'title'    => esc_html__( 'Padding Header', 'maco' ),
			'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
			'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
			'default'  => array(
				'padding-top'    => '80px',
				'padding-right'  => '0',
				'padding-bottom' => '80px',
				'padding-left'   => '0'
			),
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-dimension' ),
			),
		),

		/* header custom background */
		array(
			'id' => 'header_background',
			'type' => 'background',
			'title' => esc_html__('Header Custom Background', 'maco'),
			'subtitle' => esc_html__('Header background with image, color, etc.', 'maco'),
			'default' => array(
				'background-color'  => 'transparent',
				'background-repeat'  => 'no-repeat',
				'background-size'  => 'inherit',
				'background-attachment'  => 'inherit',
				'background-position'  => 'center center',
			),
			'required' => array(
				array( 'header_general_opt_select', '=', 'header-background' ),
			),
		),
		array(
			'id' => 'header_fixed_background',
			'type'     => 'color',
			'title' => esc_html__('Header Fixed When Scroll Background', 'maco'),
			'subtitle' => esc_html__('Header fixed background with image, color, etc.', 'maco'),
			'default' => '#ffffff',
			'validate' => 'color',
			'required' => array(
				array( 'header_general_opt_select', '=', 'header-background' ),
				array( 'fixed_header', '=', true ),
				array( 'header_fixed_type', '=', 'header_fixed_scroll' ),
			),
		),
		array(
			'id' => 'header_fixed_color',
			'type'     => 'color',
			'title' => esc_html__('Header Fixed When Scroll Color', 'maco'),
			'subtitle' => esc_html__('Header fixed text color.', 'maco'),
			'default' => '#000000',
			'validate' => 'color',
			'required' => array(
				array( 'header_general_opt_select', '=', 'header-background' ),
				array( 'fixed_header', '=', true ),
				array( 'header_fixed_type', '=', 'header_fixed_scroll' ),
			),
		),

		/* header info */
		array(
			'id'		=> 'header_info_icon_1',
			'type'		=> 'select',
			'data'		=> 'elusive-icons',
			'title'		=> esc_html__( 'Header Info 1 Icon', 'maco' ),
			'enqueue_frontend' => true,
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-widget' ),
			),
		),

		array(
			'id'=>'header_info_1',
			'type' => 'text',
			'title' => esc_html__('Header Info 1', 'maco'),
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-widget' ),
			),
			'default' => ''
		),

		array(
			'id'		=> 'header_info_icon_2',
			'type'		=> 'select',
			'data'		=> 'elusive-icons',
			'title'		=> esc_html__( 'Header Info 2 Icon', 'maco' ),
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-widget' ),
			),
		),

		array(
			'id'=>'header_info_2',
			'type' => 'text',
			'title' => esc_html__('Header Info 2', 'maco'),
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-widget' ),
			),
			'default' => ''
		),

		array(
			'id'=>'header_info_link',
			'type' => 'text',
			'title' => esc_html__('Info Link Text', 'maco'),
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-widget' ),
			),
			'default' => ''
		),

		array(
			'id'=>'header_info_url',
			'type' => 'text',
			'title' => esc_html__('Header Info URL', 'maco'),
			'required' => array( 
				array( 'header_general_opt_select', '=', 'header-widget' ),
			),
			'validate' => 'url',
			'default' => ''
		),

		/* 1.3. Boxed Header Options */
		array(
			'id'       => 'header_boxed',
			'type'     => 'switch',
			'title'    => esc_html__( 'Use Boxed Header', 'maco' ),
			'subtitle' => esc_html__( 'Make your header boxed', 'maco' ),
			'default'  => false,
		),
		array(
			'id'       => 'header_boxed_width',
			'type'     => 'dimensions',
			'units'    => array('px', '%'),
			'title'    => esc_html__('Header Boxed Width.', 'maco'),
			'subtitle' => esc_html__('Define width for header box.', 'maco'),
			'output'   => array('header#header.inner-head-wrap'),
			'height'   => false,
			'default'  => array(
				'Width'   => '1170', 
				'Height'  => false
			),
			'required' => array(
				array('header_boxed','=', true),
			),
		),
		array(
			'id'       => 'header_margin',
			'type'     => 'spacing',
			'output'   => array( 'header#header' ),
			'mode'     => 'margin',
			'all'      => false,
			'right'         => false,
			'left'          => false,
			'units'         => array( 'px' ),
			'units_extended'=> 'true',
			'display_units' => 'true',
			'title'    => esc_html__( 'Margin Header', 'maco' ),
			'subtitle' => esc_html__( 'Allow your users to choose the spacing or margin they want.', 'maco' ),
			'desc'     => esc_html__( 'You can enable or disable any piece of this field. Top, Right, Bottom, Left, or Units.', 'maco' ),
			'default'  => array(
				'margin-top'    => '0',
				'margin-right'  => 'auto',
				'margin-bottom' => '0',
				'margin-left'   => 'auto'
			),
			'required' => array(
				array('header_boxed','=', true),
			),
		),
		/* end of header boxed options */

	);

return $maco_header_general_opt;
}