<?php

function maco_header_alt_ext_opt() {

	$maco_header_alt_opt = array(		

		/* 1.4. Header Alternative Options */
		array(
			'id'        => 'header_scheme',
			'type'      => 'button_set',
			'title'     => esc_html__('Alternative Header Scheme', 'maco'),
			'options' 	 => array(
				'enable' 	=> esc_html__('Enable','maco'),
				'disable' => esc_html__('Disable','maco'),
			),
			'default'  => 'enable'
		),
		array(
			'id'       => 'header_text_color',
			'type'     => 'color',
			'title'    => esc_html__('Header text color', 'maco'),
			'subtitle' => esc_html__('Set header text color', 'maco'),
			'default'  => '#ffffff',
			'validate' => 'color',
			'output'   => array('body .alt-head .main-menu ul.sm-clean>li>a, body .alt-head .search-wrap #btn-search i, body .alt-head .main-menu ul.sm-clean>li.current-menu-item>a, .alt-head .site-title a, #header.alt-head .head-info-text span'),
			'required' => array('header_scheme','=','enable'),
		),
		array(
			'id' => 'header_alt_logo',
			'type' => 'media',
			'url' => true,
			'compiler' => 'true',
			'title' => esc_html__('Alternative Logo', 'maco'), 
			'desc' => esc_html__('Upload your logo image here (any size).', 'maco'),
			'required' => array('header_scheme','=','enable'),
			'default'  	=> array(
				'url'	=>''
			),
		),
		array(
			'id' => 'header_alt_bg',
			'type' => 'background',
			'output' => array('header#header.inner-head-wrap.alt-head'),
			'title' => esc_html__('Header Alternative Background', 'maco'),
			'subtitle' => esc_html__('Header background with image, color, etc.', 'maco'),
			'default' => 'transparent',
			'required' => array('header_scheme','=','enable'),
		),
		/* end of header alternative options*/

		array(
			'id'        => 'space_fixed_alt',
			'type'      => 'button_set',
			'title'     => esc_html__('Header Fixed Space', 'maco'),
			'options' 	 => array(
				'on' 	=> esc_html__('Enable','maco'),
				'off' => esc_html__('Disable','maco'),
			),
			'default'  => 'off'
		),

	);

return $maco_header_alt_opt;
}