<?php

if(function_exists("register_field_group"))
{
	register_field_group(array (
		'id' => 'acf_gallery-meta',
		'title' => 'Gallery Meta',
		'fields' => array (
			array (
				'key' => 'field_52ddeb8a1f132',
				'label' => 'Maco Gallery',
				'name' => 'maco_gallery',
				'type' => 'gallery',
				'preview_size' => 'thumbnail',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'gallery',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'acf_after_title',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));

	register_field_group(array (
		'id' => 'acf_video-format',
		'title' => 'Video Format',
		'fields' => array (
			array (
				'key' => 'field_531178e127a32',
				'label' => 'Video Url',
				'name' => 'video_url',
				'type' => 'text',
				'instructions' => 'For Vimeo/Youtube and Some Of Video Provider that support oEmbed. Just add the url here',
				'default_value' => '',
				'placeholder' => '',
				'prepend' => '',
				'append' => '',
				'formatting' => 'none',
				'maxlength' => '',
			),
			array (
				'key' => 'field_531178b427a31',
				'label' => 'Video Embed',
				'name' => 'video_embed',
				'type' => 'textarea',
				'instructions' => 'If you\'re more comfortable with just embed code. Paste in here',
				'default_value' => '',
				'placeholder' => '',
				'maxlength' => '',
				'formatting' => 'none',
			),
			array (
				'key' => 'field_5311797127a33',
				'label' => 'Video File',
				'name' => 'video_file',
				'type' => 'file',
				'instructions' => 'If You prefer to upload your own video file. Upload Here',
				'save_format' => 'url',
				'library' => 'all',
			),
		),
		'location' => array (
			array (
				array (
					'param' => 'post_format',
					'operator' => '==',
					'value' => 'video',
					'order_no' => 0,
					'group_no' => 0,
				),
			),
		),
		'options' => array (
			'position' => 'acf_after_title',
			'layout' => 'default',
			'hide_on_screen' => array (
			),
		),
		'menu_order' => 0,
	));
}

if( function_exists('acf_add_local_field_group') ):

acf_add_local_field_group(array(
	'key' => 'group_5a0298e18bd9c',
	'title' => 'Gallery Dimension',
	'fields' => array(
		array(
			'key' => 'field_5a029c54b404c',
			'label' => 'Gallery Info',
			'name' => '',
			'type' => 'message',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'message' => 'This options only work for Single Portfolio Style 1, go to Options > Content Options > Single Portfolio Options and select your single portfolio style type. Leave the value blank if you want to use default image size.',
			'new_lines' => 'wpautop',
			'esc_html' => 0,
		),
		array(
			'key' => 'field_5a0299cecd969',
			'label' => 'Force Crop',
			'name' => 'force_crop',
			'type' => 'true_false',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'message' => 'Force your images to crop to your defined dimension',
			'default_value' => 0,
			'ui' => 0,
			'ui_on_text' => '',
			'ui_off_text' => '',
		),
		array(
			'key' => 'field_5a03e9e95bfb9',
			'label' => 'Item Per Row',
			'name' => 'item_per_row',
			'type' => 'number',
			'instructions' => 'How much items show per row',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => 2,
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5a029b87414a2',
			'label' => 'Gallery Width',
			'name' => 'gallery_width',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => 'Define your gallery images width',
			'prepend' => '',
			'append' => 'px',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5a029bba414a3',
			'label' => 'Gallery Height',
			'name' => 'gallery_height',
			'type' => 'number',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => 'Define your gallery images width',
			'prepend' => '',
			'append' => 'px',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5a03e7f5f2828',
			'label' => 'Vertical Gap',
			'name' => 'vertical_gap',
			'type' => 'number',
			'instructions' => 'Give each gallery row a space gap',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => 'px',
			'min' => '',
			'max' => '',
			'step' => '',
		),
		array(
			'key' => 'field_5a03e81bf2829',
			'label' => 'Horizontal Gap',
			'name' => 'horizontal_gap',
			'type' => 'number',
			'instructions' => 'Give each gallery row a space gap',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array(
				'width' => '50',
				'class' => '',
				'id' => '',
			),
			'default_value' => '',
			'placeholder' => '',
			'prepend' => '',
			'append' => '',
			'min' => '',
			'max' => '',
			'step' => '',
		),
	),
	'location' => array(
		array(
			array(
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'maco-portfolio',
			),
			array(
				'param' => 'post_format',
				'operator' => '==',
				'value' => 'gallery',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'acf_after_title',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

/* Masonry Setting */
acf_add_local_field_group(array (
	'key' => 'group_587f052388007',
	'title' => 'Masonry Setting',
	'fields' => array (
		array (
			'layout' => 'horizontal',
			'choices' => array (
				'default' => 'Default',
				'wider' => 'Wider',
			),
			'default_value' => 'default',
			'other_choice' => 0,
			'save_other_choice' => 0,
			'allow_null' => 0,
			'return_format' => 'value',
			'key' => 'field_587f0532ec099',
			'label' => 'Masonry Size Item',
			'name' => 'masonry_size_item',
			'type' => 'radio',
			'instructions' => 'This option is useful when You use Masonry. Choose one of this option if You want the size different.',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'maco-portfolio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

/* Portfolio Features */
acf_add_local_field_group(array (
	'key' => 'group_5948b3bfaff22',
	'title' => 'Portfolio Features',
	'fields' => array (
		array (
			'key' => 'field_595ddf511b398',
			'label' => 'Portfolio Alternative Image',
			'name' => 'portfolio_alternative_image',
			'type' => 'image',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'return_format' => 'url',
			'preview_size' => 'thumbnail',
			'library' => 'all',
			'min_width' => '',
			'min_height' => '',
			'min_size' => '',
			'max_width' => '',
			'max_height' => '',
			'max_size' => '',
			'mime_types' => '',
		),
		array (
			'key' => 'field_5948b3e180ed9',
			'label' => 'Portfolio Details',
			'name' => 'portfolio_details',
			'type' => 'repeater',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'collapsed' => '',
			'min' => 0,
			'max' => 0,
			'layout' => 'block',
			'button_label' => 'Add Detail',
			'sub_fields' => array (
				array (
					'key' => 'field_5948b43280eda',
					'label' => 'Detail Name',
					'name' => 'detail_name',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
				array (
					'key' => 'field_5948b43b80edb',
					'label' => 'Detail Text',
					'name' => 'detail_text',
					'type' => 'text',
					'instructions' => '',
					'required' => 0,
					'conditional_logic' => 0,
					'wrapper' => array (
						'width' => '',
						'class' => '',
						'id' => '',
					),
					'default_value' => '',
					'placeholder' => '',
					'prepend' => '',
					'append' => '',
					'maxlength' => '',
				),
			),
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'maco-portfolio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'normal',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

acf_add_local_field_group(array (
	'key' => 'group_58c7b9c7c54ac',
	'title' => 'Header Choice',
	'fields' => array (
		array (
			'key' => 'field_58c7b9d20beeb',
			'label' => 'Header Style Choice',
			'name' => 'header_style_choice',
			'type' => 'select',
			'instructions' => '',
			'required' => 0,
			'conditional_logic' => 0,
			'wrapper' => array (
				'width' => '',
				'class' => '',
				'id' => '',
			),
			'choices' => array (
				'default' => 'Default Header',
				'alternative' => 'Alternative Header',
			),
			'default_value' => array (
				0 => 'default',
			),
			'allow_null' => 0,
			'multiple' => 0,
			'ui' => 0,
			'ajax' => 0,
			'return_format' => 'value',
			'placeholder' => '',
		),
	),
	'location' => array (
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'page',
			),
		),
		array (
			array (
				'param' => 'post_type',
				'operator' => '==',
				'value' => 'maco-portfolio',
			),
		),
	),
	'menu_order' => 0,
	'position' => 'side',
	'style' => 'default',
	'label_placement' => 'top',
	'instruction_placement' => 'label',
	'hide_on_screen' => '',
	'active' => 1,
	'description' => '',
));

endif;