<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-item'); ?>>

	<?php 
	if ( class_exists( 'acf' ) ) { ?>
	<div class="featured-video clearfix">
		<?php 
			$video_url = get_field('video_url');
			$video_embed = get_field('video_embed');
			$video_file = get_field('video_file');
			
			if($video_url !== ''){ 
				echo wp_oembed_get( esc_url( $video_url ));
			} 

			elseif($video_embed !== '') { 
				echo wp_specialchars_decode(  $video_embed );
			}

			elseif($video_file !== '') {  ?>
			<?php echo do_shortcode( '[video src="'. esc_url( $video_file ).'"]' ) ?>  
		<?php } ?>
	</div>
	<?php } ?>

	<div class="post-content-wrap">
		<div class="post-content<?php if ( !has_post_thumbnail()) { ?> no-thumb<?php } ?>">

			<div class="loop-post-head the-post-head clearfix">
				<div class="post-meta clearfix">
					<div class="meta-info">
						<span class="date span-head">
							<span><?php esc_html_e( 'Posted On', 'maco' ); ?></span>
							<a href="<?php the_permalink(); ?>">
								<span><?php echo get_the_date('F'); ?></span> <span><?php echo get_the_date('d'); ?></span><?php esc_html_e( ',', 'maco' ); ?> <span><?php echo get_the_date('Y'); ?></span>
							</a>
						</span>
						<span class="standard-post-categories span-head">
							<?php the_category(' '); ?>
						</span>
					</div>
				</div>

				<h2 class="post-title entry-title">
					<a href="<?php the_permalink(); ?>">
						<?php the_title(); ?>
					</a>
				</h2>
			</div>

			<div class="post-text">
				<?php the_excerpt(); ?>
			</div>

			<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e( 'Read More', 'maco' ); ?></a>
		</div>
	</div>
</article>