<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-item'); ?>>

	<?php
	if ( class_exists( 'acf' ) ) {
	$images = get_field('maco_gallery');
	if( $images){ ?>

	<div class="slider-wrapper">
		<div class="standard-carousel-slider post-gallery carousel-container">
			<div class="carousel-wrapper owl-carousel owl-theme">
				<?php foreach( $images as $image ): ?>
				<div class="carousel-slide">
					<img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php echo esc_attr( $image['alt'] ); ?>" />  
				</div>
				<?php endforeach; ?>
			</div>
		</div>
	</div>
	<?php } 
	}
	else { 
		if ( has_post_thumbnail()) { ?>
		<div class="post-thumb">
			<a href="<?php the_permalink(); ?>">
				<?php the_post_thumbnail(); ?>

				<div class="maco-overlay"></div>
			</a>
		</div><!-- thumbnail-->
		<?php }
	} ?>

	<div class="post-content-wrap">
		<div class="post-content<?php if ( !has_post_thumbnail()) { ?> no-thumb<?php } ?>">

			<div class="loop-post-head the-post-head clearfix">
				<div class="post-meta clearfix">
					<div class="meta-info">
						<span class="date span-head">
							<span><?php esc_html_e( 'Posted On', 'maco' ); ?></span>
							<a href="<?php the_permalink(); ?>">
								<span><?php echo get_the_date('F'); ?></span> <span><?php echo get_the_date('d'); ?></span><?php esc_html_e( ',', 'maco' ); ?> <span><?php echo get_the_date('Y'); ?></span>
							</a>
						</span>
						<span class="standard-post-categories span-head">
							<?php the_category(' '); ?>
						</span>
					</div>
				</div>

				<h2 class="post-title entry-title">
					<a href="<?php the_permalink(); ?>">
						<?php the_title(); ?>
					</a>
				</h2>
			</div>

			<div class="post-text">
				<?php the_excerpt(); ?>
			</div>

			<a href="<?php the_permalink(); ?>" class="read-more"><?php esc_html_e( 'Read More', 'maco' ); ?></a>
		</div>
	</div>
</article>