<article id="post-<?php the_ID(); ?>" <?php post_class( 'blog-item hentry single-post-style blog-1-post-style clearfix'); ?>>

	<div class="post-content-wrap clearfix">
		<div class="post-content">

			<?php
			if ( class_exists( 'acf' ) ) {
			$images = get_field('maco_gallery');
			if( $images){ ?>

			<div class="slider-wrapper">
				<div class="standard-carousel-slider post-gallery carousel-container">
					<div class="carousel-wrapper owl-carousel owl-theme">
						<?php foreach( $images as $image ): ?>
						<div class="carousel-slide item">
							<img src="<?php echo esc_url( $image['url'] ); ?>" alt="<?php echo esc_attr( $image['alt'] ); ?>" />  
						</div>
						<?php endforeach; ?>
					</div>

					<div class="post-car-arrow-wrap on-bottom clearfix">
					</div>
				</div>
			</div>
			<?php }
			} ?>
			
			<div class="single-post-head the-post-head clearfix">
				<div class="single-title-wrap">
					<div class="post-meta clearfix">
						<div class="meta-info">
							<span class="author span-head">
								<span><?php esc_html_e( 'By', 'maco' ); ?></span>
								<span class="vcard"><a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>"> <?php echo get_the_author_meta( 'display_name' ); ?></a></span>
							</span>
							<span class="date span-head">
								<span><?php esc_html_e( 'Posted On', 'maco' ); ?></span>
								<a href="<?php the_permalink(); ?>">
									<span><?php echo get_the_date('F'); ?></span> <span><?php echo get_the_date('d'); ?></span><?php esc_html_e( ',', 'maco' ); ?> <span><?php echo get_the_date('Y'); ?></span>
								</a>
							</span>
							<span class="standard-post-categories span-head">
								<span class="category-text"><?php esc_html_e( 'Categories : ', 'maco' ); ?></span>
								<?php the_category(' '); ?>
							</span>
						</div>
					</div>

					<h1 class="post-title entry-title"><?php the_title(); ?></h1>
				</div>
			</div>

			<div class="post-text entry-content clearfix">
				<?php 
					the_content(); 
					wp_link_pages( array(
						'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'maco' ) . '</span>',
						'after'       => '</div>',
						'link_before' => '<span>',
						'link_after'  => '</span>',
						'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'maco' ) . ' </span>%',
						'separator'   => '<span class="screen-reader-text">, </span>',
					) ); 
				?>
			</div>
			<div class="meta-bottom clearfix">
				<div class="tag-wrapper"><?php the_tags('','',''); ?></div>
			</div>
		</div>
	</div>

	<!-- pagination start -->
	<div class="next-prev-post clearfix">
		<?php $next_post = get_next_post();
		$previous_post = get_previous_post(); ?>
		
		<?php if ( get_previous_post() ) : ?>
		<div class="prev-post column column-2">
			<div class="inner-nav clearfix">
				<a href="<?php echo get_permalink( $previous_post->ID ); ?>">
					<span class="the-nav-link"><?php esc_html_e( 'Previous Post', 'maco' ); ?></span>
					<h4 class="the-nav-title"><?php echo get_the_title( $previous_post->ID ); ?></h4>
				</a>
			</div>
		</div>
		<?php endif; ?>
		
		<?php if ( get_next_post() ) : ?>
		<div class="next-post column column-2">
			<div class="inner-nav clearfix">
				<a href="<?php echo get_permalink( $next_post->ID ); ?>">
					<span class="the-nav-link"><?php esc_html_e( 'Next Post', 'maco' ); ?></span>
					<h4 class="the-nav-title"><?php echo get_the_title( $next_post->ID ); ?></h4>
				</a>
			</div>
		</div>
		<?php endif; ?>
	</div>
	<!-- pagination end -->

	<!-- Author Info -->
	<?php $author_desc = get_the_author_meta('description'); 
	if(!empty($author_desc)) { ?>
	<div class="post-author clearfix">
		<div class="author-wrap clearfix">
			
			<figure class="author-ava">
				<?php echo get_avatar( get_the_author_meta('ID'), '100' ); ?>
			</figure>

			<div class="author-desc">
				<div class="author-name">
					<span><?php esc_html_e( 'Written by', 'maco' ); ?></span> <a href="<?php echo get_author_posts_url( get_the_author_meta( 'ID' ) ); ?>" title="<?php echo get_the_author_meta( 'display_name' ); ?>" rel="author"><?php echo get_the_author_meta( 'display_name' ); ?></a>
				</div>
				<?php the_author_meta('description'); ?>
			</div>
		</div>
	</div>
	<?php } ?>
	<!-- end of author -->

	<?php if ( !post_password_required()) {
		get_template_part( 'inc/part/related', 'post' ); 
	} ?>

</article><!-- #post-<?php the_ID(); ?> -->

<?php 
	if ( is_singular() ) wp_enqueue_script( "comment-reply" ); 
	if ( comments_open() || '0' != get_comments_number() ) comments_template(); 
?>