<?php

if ( ! function_exists( 'maco_header_part' ) ) {
	function maco_header_part( $template, $name = null ) {
		get_template_part( 'template/' . $template, $name );
	}
}

if ( ! function_exists( 'maco_footer_part' ) ) {
	function maco_footer_part( $template, $name = null ) {
		get_template_part( 'template/' . $template, $name );
	}
}

// Set the content width based on the theme's design and stylesheet.
if ( ! isset( $content_width ) ) {
	$content_width = 1200; /* pixels */
}

/*
-----------------------------------------------------------------------------------
SETUP THEME
-----------------------------------------------------------------------------------
*/

if ( ! function_exists( 'maco_setup' ) ) :

	function maco_setup() {
		// several theme support
		add_theme_support( 'automatic-feed-links' );
		if ( class_exists( 'acf' ) ) {
			add_theme_support( 'post-formats', array( 'gallery', 'video' ) );
		}
		add_theme_support( 'custom-background' );
		$maco_def_bg = array(
			'default-color' => '#ffffff',
		);
		add_theme_support( 'custom-background', $maco_def_bg );
		add_theme_support( 'post-thumbnails' );
		add_theme_support( 'html5', array( 'comment-list', 'comment-form', 'search-form' ) );
		add_theme_support( 'html5', array( 'gallery', 'caption' ) );
		load_theme_textdomain( 'maco', get_template_directory() . '/languages' );
		add_theme_support( 'title-tag' );

	}
endif;
add_action( 'after_setup_theme', 'maco_setup' );

function maco_opening_body() {
	printf( '<!-- TA Start Body -->' );
}

add_action( 'wp_body_open', 'maco_opening_body' );

function maco_thumbnail_setup() {
	add_image_size( 'maco-portfolio-widget-thumb', 100, 100, true );

	add_image_size( 'maco-related', 370, 250, true );

	add_image_size( 'maco-post-block', 535, 355, true );

	add_image_size( 'maco-latestpost-widget_thumb', 75, 60, true );

	add_image_size( 'maco-portfolio-widget_thumb', 250, 250, true );

	add_image_size( 'maco-portfolio-grid1_thumb', 250, 250, true );

}

add_action( 'after_setup_theme', 'maco_thumbnail_setup' );

/*
-----------------------------------------------------------------------------------
ACF
-----------------------------------------------------------------------------------
*/

add_filter( 'acf/settings/show_admin', '__return_false' );

/*
-----------------------------------------------------------------------------------
SCRIPTS & STYLES
-----------------------------------------------------------------------------------
*/

function maco_scripts() {

	// All necessary CSS
	$options = get_option( 'maco_framework' );

	wp_enqueue_style( 'maco-plugin', get_template_directory_uri() . '/css/plugin.css', array(), null );
	wp_enqueue_style( 'maco-style', get_stylesheet_uri(), array( 'maco-plugin' ) );
	wp_enqueue_style( 'maco-font', get_template_directory_uri() . '/css/font.css', array(), null );

	wp_enqueue_style( 'maco-responsive', get_template_directory_uri() . '/css/responsive.css', array(), null );

	// All Necessary Script
	wp_enqueue_script( 'modernizr', get_template_directory_uri() . '/js/modernizr.js', array( 'jquery' ), '', false );
	wp_enqueue_script( 'respond', get_template_directory_uri() . '/js/respond.js', array( 'jquery' ), '', false );
	wp_enqueue_script( 'fitvids', get_template_directory_uri() . '/js/fitvids.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'classie', get_template_directory_uri() . '/js/classie.js', array( 'jquery' ), '', false );
	wp_enqueue_script( 'wow', get_template_directory_uri() . '/js/wow.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'easing', get_template_directory_uri() . '/js/easing.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'smartmenus', get_template_directory_uri() . '/js/smartmenus.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'owlcarousel', get_template_directory_uri() . '/js/owlcarousel.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'infinitescroll', get_template_directory_uri() . '/js/infinitescroll.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'isotope', get_template_directory_uri() . '/js/isotope.js', array( 'jquery', 'imagesloaded' ), '', $in_footer = true );
	wp_enqueue_script( 'headroom', get_template_directory_uri() . '/js/headroom.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'animeonscroll', get_template_directory_uri() . '/js/animeonscroll.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'bootstrap', get_template_directory_uri() . '/js/bootstrap.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'lightgallery', get_template_directory_uri() . '/js/lightgallery.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'stickykit', get_template_directory_uri() . '/js/stickykit.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'thumbsplugin', get_template_directory_uri() . '/js/thumbsplugin.js', array( 'jquery' ), '', $in_footer = true );
	wp_enqueue_script( 'maco-main', get_template_directory_uri() . '/js/main.js', array( 'jquery' ), '', true );

	if ( class_exists( 'Redux' ) ) {

		$options                = get_option( 'maco_framework' );
		$search_bar_style       = $options['search_bar_style'];
		$maco_footer_style_type = $options['footer_style_type'];

		$maco_right  = $options['header_customize_right']['enabled'];
		$maco_center = $options['header_customize_center']['enabled'];
		$maco_left   = $options['header_customize_left']['enabled'];

		if ( $search_bar_style == 'expand' ) {
			if ( $maco_right || $maco_center || $maco_left ) {
				if ( isset( $maco_right['maco-search'] ) || isset( $maco_center['maco-search'] ) || isset( $maco_left['maco-search'] ) ) {
					wp_enqueue_script( 'maco-header1', get_template_directory_uri() . '/js/header1.js', array( 'jquery' ), '', true );
				}
			}
		}

		/*footer*/
		if ( $maco_footer_style_type == 'fixed-footer' ) {
			wp_enqueue_script( 'maco-footer-fixed', get_template_directory_uri() . '/js/footer-fixed.js', array( 'jquery' ), '', true );
		}
	} else {
		wp_enqueue_script( 'maco-header1', get_template_directory_uri() . '/js/header1.js', array( 'jquery' ), '', true );
	}

	if ( is_singular() && comments_open() && get_option( 'thread_comments' ) ) {
		wp_enqueue_script( 'comment-reply' );
	}
}

add_action( 'wp_enqueue_scripts', 'maco_scripts' );

/* customizer scripts */
function maco_customizer_live_preview() {
	wp_enqueue_script( 'maco-color-customizer', get_template_directory_uri() . '/js/color-customizer.js', array( 'jquery', 'customize-preview' ), null, true );
}
add_action( 'customize_preview_init', 'maco_customizer_live_preview' );

/* admin style on admin dashboard */
function maco_admin_style() {
	wp_enqueue_style( 'maco-admin-styles', get_template_directory_uri() . '/css/admin.css' );
}
add_action( 'admin_enqueue_scripts', 'maco_admin_style' );

/* admin style on elementor editor */
if ( is_user_logged_in() ) {
	add_action(
		'elementor/frontend/after_register_styles',
		function() {
			wp_enqueue_style( 'maco-admin-styles2', get_template_directory_uri() . '/css/admin.css' );
		}
	);
}

add_action(
	'elementor/editor/before_enqueue_scripts',
	function() {
		wp_enqueue_style( 'maco-admin-styles1', get_template_directory_uri() . '/css/admin.css' );
	}
);

/*
-----------------------------------------------------------------------------------
THEMESAWESOME LICENSER
-----------------------------------------------------------------------------------
*/
require 'inc/function/lb_helper.php';

// Create a new KonsultanLicenseBoxAPI helper class.
$maco_lbapi = new MacoLicenseBoxAPI();

// Performs background license check, pass TRUE as 1st parameter to perform periodic verifications only.
//$maco_lb_verify_res = $maco_lbapi->verify_license();
$maco_lb_verify_res = get_option( 'maco_lb_verify_res' );
if ( $maco_lb_verify_res == false ) {
	$maco_lb_verify_res = array( 'status' => false );
}

// Performs update check, you can easily change the duration of update checks.
if ( false === ( $lb_update_res = get_transient( 'licensebox_next_update_check' ) ) ) {
	$lb_update_res = $maco_lbapi->check_update();
	set_transient( 'licensebox_next_update_check', $lb_update_res, 12 * HOUR_IN_SECONDS );
}


// If user has a valid license and new updates are available show the update notification in plugins page.
if ( ( $lb_update_res['status'] ) && ( $maco_lb_verify_res['status'] ) ) {
	function maco_licensebox_show_update_notice() {
		global $lb_update_res;
		$lb_update_message   = esc_html( $lb_update_res['message'] );
		$update_notification = <<<LB_UPDATE
<tr class="active">
	<td colspan="3">
		<div class="update-message notice inline notice-warning notice-alt" style="margin: 5px 20px 10px 20px">
			<p>
				<b>$lb_update_message</b>
				<a href="themes.php?page=ta-licensebox" style="text-decoration: underline;">Update now</a>.
			</p>
		</div>
	</td>
</tr>
LB_UPDATE;
		echo wp_specialchars_decode( $update_notification );
	}
	add_action( 'after_plugin_row_' . plugin_basename( __FILE__ ), 'maco_licensebox_show_update_notice', 10, 3 );
}

// If user doesn't have a valid license show the activation pending notification in plugins page.
if ( ! $maco_lb_verify_res['status'] ) {
	function maco_licensebox_show_license_notice() {
		$license_notification = <<<LB_LICENSE
<tr class="active">
	<td colspan="3">
		<div class="notice notice-error inline notice-alt" style="margin: 5px 20px 10px 20px">
			<p>
				<b>License is not set yet, Please enter your license code to use the theme.</b>
				<a href="themes.php?page=ta-licensebox" style="text-decoration: underline;">Enter License Code</a>.
			</p>
		</div>
	</td>
</tr>
LB_LICENSE;
		echo wp_specialchars_decode( $license_notification );
	}
	add_action( 'after_plugin_row_' . plugin_basename( __FILE__ ), 'maco_licensebox_show_license_notice', 10, 3 );
}

// Add plugin settings page link.
function maco_licensebox_add_settings_link( $links ) {
	$settings_link = '<a href="themes.php?page=ta-licensebox">Settings</a>';
	array_push( $links, $settings_link );
	return $links;
}
add_filter( 'plugin_action_links_' . plugin_basename( __FILE__ ), 'maco_licensebox_add_settings_link' );

if ( ! $maco_lb_verify_res['status'] ) {
	function maco_license_admin_notice() {
		echo '<div class="notice notice-warning is-dismissible" style="padding-bottom: 15px;">
             <p>License is not set yet, Please enter your license code to use the theme.</p>
             <a href="themes.php?page=ta-licensebox" style="text-decoration: underline;">Enter License Code</a>
         </div>';
	}
	add_action( 'admin_notices', 'maco_license_admin_notice' );
}

require 'inc/part/ta-updater.php'; // Load the settings page.


/*
-----------------------------------------------------------------------------------
CALL FRAMEWORK
-----------------------------------------------------------------------------------
*/

require_once get_template_directory() . '/inc/option/panel/config.php';

/*
-----------------------------------------------------------------------------------
MENU
-----------------------------------------------------------------------------------
*/

// Register Menus
add_action( 'after_setup_theme', 'maco_register_my_menu' );
function maco_register_my_menu() {
	register_nav_menu( 'header-menu', esc_html__( 'Header Menu (Right/Primary)', 'maco' ) );
	if ( class_exists( 'Redux' ) ) {
		register_nav_menu( 'header-menu-sec', esc_html__( 'Header Menu (Left)', 'maco' ) );
		register_nav_menu( 'footer-menu', esc_html__( 'Footer Menu', 'maco' ) );
	}
}

// MAIN MENU
function maco_main_nav_menu() {
	if ( class_exists( 'Redux' ) ) {
		$options            = get_option( 'maco_framework' );
		$menus_choose_style = $options['menus_choose_style'];

		if ( $menus_choose_style == 'style-1' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--ferdinand',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-2' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--prospero',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-3' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--viola',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-4' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--antonio',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-5' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--miranda',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-6' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--ariel',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-7' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--caliban',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-8' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--iris',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-9' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--stephano',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-10' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--ceres',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-11' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--juno',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-12' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--maria',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-13' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--valentine',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-14' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--sebastian',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		} else {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean',
					'fallback_cb'    => 'maco_header_menu_cb',
				)
			);
		}
	} else {
		wp_nav_menu(
			array(
				'theme_location' => 'header-menu',
				'container'      => 'ul',
				'menu_class'     => 'sm sm-clean menu--ferdinand',
				'fallback_cb'    => 'maco_header_menu_cb',
			)
		);
	}
}

// SECONDARY MENU
if ( class_exists( 'Redux' ) ) {
	function maco_main_nav_menu_left() {
		$options            = get_option( 'maco_framework' );
		$menus_choose_style = $options['menus_choose_style'];

		if ( $menus_choose_style == 'style-1' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--ferdinand',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-2' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--prospero',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-3' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--viola',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-4' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--antonio',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-5' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--miranda',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-6' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--ariel',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-7' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--caliban',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-8' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--iris',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-9' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--stephano',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-10' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--ceres',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-11' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--juno',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-12' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--maria',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-13' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--valentine',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} elseif ( $menus_choose_style == 'style-14' ) {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean menu--sebastian',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		} else {
			wp_nav_menu(
				array(
					'theme_location' => 'header-menu-sec',
					'container'      => 'ul',
					'menu_class'     => 'sm sm-clean',
					'fallback_cb'    => 'maco_header_sec_menu_cb',
				)
			);
		}
	}
}

function maco_add_menuclass( $ulclass ) {
	return preg_replace( '/<a /', '<a class="menu__link" ', $ulclass );
}
add_filter( 'wp_nav_menu', 'maco_add_menuclass' );

if ( class_exists( 'Redux' ) ) {
	// FOOTER MENU
	function maco_footer_menu() {
		wp_nav_menu(
			array(
				'theme_location' => 'footer-menu',
				'container'      => 'ul',
				'menu_class'     => 'sm',
				'fallback_cb'    => 'maco_footer_menu_cb',
			)
		);
	}
}

// FALLBACK IF PRIMARY MENU HAVEN'T SET YET

function maco_header_menu_cb() {
	echo '<ul id="menu-top-menu" class="menus sm sm-clean menu--ferdinand">';
	wp_list_pages( 'title_li=' );
	echo '</ul>';
}

if ( class_exists( 'Redux' ) ) {
	function maco_header_menu_sec_cb() {
		echo '<ul id="menu-top-menu-sec" class="menus sm sm-clean">';
		wp_list_pages( 'title_li=' );
		echo '</ul>';
	}

	function maco_footer_menu_cb() {
		echo '<ul id="menu-footer-menu" class="menus">';
		wp_list_pages( 'title_li=' );
		echo '</ul>';
	}
}

/*
-----------------------------------------------------------------------------------
WIDGET
-----------------------------------------------------------------------------------
*/

// SETUP DEFAULT SIDEBAR
function maco_widgets_init() {
	register_sidebar(
		array(
			'name'          => esc_html__( 'Primary Sidebar', 'maco' ),
			'id'            => 'primary-sidebar',
			'before_widget' => '<div id="%1$s" class="widget %2$s">',
			'after_widget'  => '</div>',
			'before_title'  => '<h4 class="widget-title"><span>',
			'after_title'   => '</span></h4>',
		)
	);
}
add_action( 'widgets_init', 'maco_widgets_init' );

/*
-----------------------------------------------------------------------------------
PAGINATION
-----------------------------------------------------------------------------------
*/

function maco_pagination( $pages = '', $range = 2 ) {
	$showitems = ( $range * 2 ) + 1;

	global $paged;
	if ( empty( $paged ) ) {
		$paged = 1;
	}

	if ( $pages == '' ) {
		global $wp_query;
		$pages = $wp_query->max_num_pages;
		if ( ! $pages ) {
			$pages = 1;
		}
	}

	if ( 1 != $pages ) {
		echo "<div class='navigation-paging pagination-num'>";
		if ( $paged > 2 && $paged > $range + 1 && $showitems < $pages ) {
			echo "<a href='" . get_pagenum_link( 1 ) . "'>" . esc_html__( 'First', 'maco' ) . '</a>';
		}
		if ( $paged > 1 && $showitems < $pages ) {
			echo "<a href='" . get_pagenum_link( $paged - 1 ) . "'>&lsaquo;</a>";
		}

		for ( $i = 1; $i <= $pages; $i++ ) {
			if ( 1 != $pages && ( ! ( $i >= $paged + $range + 1 || $i <= $paged - $range - 1 ) || $pages <= $showitems ) ) {
				echo ( esc_html( $paged ) == esc_html( $i ) ) ? "<span class='btn current'>" . esc_html( $i ) . '</span>' : "<a href='" . get_pagenum_link( $i ) . "' class='btn inactive' >" . esc_html( $i ) . '</a>';
			}
		}

		if ( $paged < $pages && $showitems < $pages ) {
			echo "<a href='" . get_pagenum_link( $paged + 1 ) . "'>&rsaquo;</a>";
		}
		if ( $paged < $pages - 1 && $paged + $range - 1 < $pages && $showitems < $pages ) {
			echo "<a href='" . get_pagenum_link( $pages ) . "'>" . esc_html__( 'Last', 'maco' ) . '</a>';
		}
		echo "</div>\n";
	}
}

/*
-----------------------------------------------------------------------------------
PLACEHOLDER
-----------------------------------------------------------------------------------
*/

/* Add Placehoder in comment Form Fields (Name, Email, Website) */

add_filter( 'comment_form_default_fields', 'maco_comment_placeholders' );
function maco_comment_placeholders( $fields ) {
	$fields['author'] = str_replace(
		'<input',
		'<input placeholder="' . esc_html__( 'Your Name', 'maco' ) . '"',
		$fields['author']
	);
	$fields['email']  = str_replace(
		'<input',
		'<input placeholder="' . esc_html__( 'Your Email', 'maco' ) . '"',
		$fields['email']
	);
	$fields['url']    = str_replace(
		'<input',
		'<input placeholder="' . esc_html__( 'Website URL', 'maco' ) . '"',
		$fields['url']
	);
	return $fields;
}

/* Add Placehoder in comment Form Field (Comment) */
add_filter( 'comment_form_defaults', 'maco_textarea_placeholder' );

function maco_textarea_placeholder( $fields ) {
	$fields['comment_field'] = str_replace(
		'<textarea',
		'<textarea placeholder="' . esc_html__( 'Your thoughts..', 'maco' ) . '"',
		$fields['comment_field']
	);

	return $fields;
}

/*
-----------------------------------------------------------------------------------
CUSTOM FUNCTIONS
-----------------------------------------------------------------------------------
*/

require_once get_template_directory() . '/inc/function/custom.php';
require_once get_template_directory() . '/inc/function/navigation.php';
require_once get_template_directory() . '/inc/function/aq_resizer.php';
require_once get_template_directory() . '/inc/function/comment.php';
require_once get_template_directory() . '/inc/function/akmanda-customizer.php';
require_once get_template_directory() . '/inc/function/meta-box.php';
require_once get_template_directory() . '/inc/function/thefooter.php';

/* Customizer Inline Style */
require_once get_template_directory() . '/inc/function/inline-styles.php';

// INSTALL NECESSARY PLUGINS
require_once get_template_directory() . '/class-tgm.php'; /*activate plugin function*/

/* body custom class */
add_filter( 'body_class', 'maco_body_custom_class' );
function maco_body_custom_class( $classes ) {

	if ( class_exists( 'Redux' ) ) {
		$classes[] = 'header-style-1';
	} else {
		$classes[] = 'header-style-1 no-redux';
	}
	return $classes;
}

function maco_post_custom_class( $classes ) {
	global $post;

	if ( class_exists( 'Redux' ) ) {
		$options                  = get_option( 'maco_framework' );
		$maco_blog_masonry_column = $options['blog_masonry_column'];
		if ( is_front_page() && is_home() ) {
			$classes[] = 'blog-item masonry-blog column ' . $maco_blog_masonry_column . '';
		} elseif ( is_front_page() ) {
			$classes[] = 'blog-item masonry-blog column ' . $maco_blog_masonry_column . '';
		} elseif ( is_home() ) {
			$classes[] = 'blog-item masonry-blog column ' . $maco_blog_masonry_column . '';
		} elseif ( is_archive() || is_search() ) {
			$classes[] = 'blog-item masonry-blog column column-3';
		} elseif ( is_page() || is_single( 'post' ) || is_singular( 'post' ) ) {
			$classes[] = '';
		}
	} else {
		if ( ! is_singular( array( 'post', 'page' ) ) ) {
			$classes[] = 'blog-item masonry-blog column column-3';
		}
	}

	return $classes;
}
add_filter( 'post_class', 'maco_post_custom_class' );
