<?php get_header(); ?>
<?php
	$curauth = (isset($_GET['author_name'])) ? get_user_by('slug', $author_name) : get_userdata(intval($author));
?>

<!-- CONTENT START
============================================= -->
<section id="content" class="blog-content-wrap clearfix">

	<!-- BLOG START
	============================================= -->
	<div class="blog archives clearfix">
		<div class="container">
			<div class="author-box clearfix">
				<figure class="author-ava">
					<?php if ( class_exists( 'acf' ) ) {
					$author_id1 						= $curauth->ID;
					$maco_select_your_profile_image 	= get_field('select_your_profile_image', 'user_'. $author_id1);
					$maco_upload_profile_image 		= get_field('upload_profile_image', 'user_'. $author_id1);
						$maco_author_img = aq_resize($maco_upload_profile_image,  200 , 200, true);

						if( $maco_select_your_profile_image == 'upload' ) { ?>
							<img src="<?php echo esc_url( $maco_author_img ); ?>" alt="<?php echo esc_attr( 'Author' ); ?>">
						<?php }
						else { ?>
							<?php echo get_avatar( $curauth->user_email, '200' ); ?>
						<?php } ?>
					<?php }
					else { ?>
							<?php echo get_avatar( $curauth->user_email, '200' ); ?>
					<?php } ?>
				</figure>

				<div class="author-desc">
					<h2><?php echo esc_html( $curauth->display_name ); ?></h2>
					<p><?php echo esc_html( $curauth->user_description ); ?></p>
				</div>
			</div>

			<div class="row">

				<!-- BLOG LOOP START
				============================================= -->
				<div class="blog-section author-post masonry-post post-masonry-style clearfix">

					<h3 class="post-by"><?php esc_html_e( 'Stories by', 'maco' ); ?> <?php echo esc_html( $curauth->display_name ); ?></h3>

					<div class="blog-section main-blog-loop infinite-container content-section">

					<?php if ( have_posts() ) : ?>
						<?php while ( have_posts() ) : the_post(); 

							get_template_part( 'inc/format/loop', get_post_format() );

						endwhile; ?>
						
					<?php else : ?>

					<p><?php esc_html_e('No posts by this author.', 'maco'); ?></p>

					<?php endif; ?>

					</div>

					<div class="blog-standard pagination clearfix">
						<?php maco_content_nav($pages = '', $range = 2); ?>
					</div>
				
				</div>
				<!-- BLOG LOOP END -->

			</div><!-- row -->
		</div><!-- container -->
	</div><!-- search-result -->

</section>
<!-- CONTENT END -->

<?php maco_footer_choice(); ?>