<?php
$output = '';
$id = rand().time();
$atts = vc_map_get_attributes( 'sns_store_info', $atts );
extract( $atts );

$class = 'sns-store-info';
if ($style) $class .= ' style-'.esc_attr($style);
$class .= ' '.esc_attr( manh_getCSSAnimation( $css_animation ) );
if ($extra_class) $class .= ' '.esc_attr($extra_class);

$ico_phone = esc_html__('Phone: ', 'manh-shortcodes');
$ico_phone2 = esc_html__('Mobile: ', 'manh-shortcodes');
$ico_address = esc_html__('Address: ', 'manh-shortcodes');
$ico_email = esc_html__('E-Mail: ', 'manh-shortcodes');
if ($style == 2) {
	$ico_phone = '<span class="vc_icon_element-icon '.esc_attr($icon_phone).'"></span><div>';
	$ico_phone2 = '<span class="vc_icon_element-icon '.esc_attr($icon_phone2).'"></span><div>';
	$ico_address = '<span class="vc_icon_element-icon '.esc_attr($icon_address).'"></span><div>';
	$ico_email = '<span class="vc_icon_element-icon '.esc_attr($icon_email).'"></span><div>';
}elseif($style == 3){
	$ico_phone = '<span class="vc_icon_element-icon '.esc_attr($icon_phone).'"></span><div><span class="label">'.$ico_phone.'</span>';
	$ico_phone2 = '<span class="vc_icon_element-icon '.esc_attr($icon_phone2).'"></span><div><span class="label">'.$ico_phone2.'</span>';
	$ico_address = '<span class="vc_icon_element-icon '.esc_attr($icon_address).'"></span><div><span class="label">'.$ico_address.'</span>';
	$ico_email = '<span class="vc_icon_element-icon '.esc_attr($icon_email).'"></span><div><span class="label">'.$ico_email.'</span>';
}else{
	$ico_phone = '<span class="label">'.$ico_phone.'</span><div>';
	$ico_phone2 = '<span class="label">'.$ico_phone2.'</span><div>';
	$ico_address = '<span class="label">'.$ico_address.'</span><div>';
	$ico_email = '<span class="label">'.$ico_email.'</span><div>';
}

$output = '<div class="'.$class.'">';
if ( $title ) {
	$output .= '<h3 class="wpb_heading"><span>'.esc_html($title).'</span></h3>';
}
$output .= '<div class="store-info">';
if ( $logo_store ) {
	$logo_store = preg_replace('/[^\d]/', '', $logo_store);
	$img_src =   wp_get_attachment_image_src( $logo_store , '');
	$output .= '<div class="store-logo logo-retina"><img src="'.$img_src[0].'" alt="'.esc_html__("Store Logo",'manh-shortcodes').'"/></div>';
}
if ( $short_intro ) {
	$output .= '<div class="store-intro">'.nl2br(esc_html($short_intro)).'</div>';
}
if ( $address ) {
	$output .= '<div class="store-address">'.$ico_address;
	if ( $direction_link != '' ) {
		$output .= '<a href="'.esc_attr($direction_link).'" target="_blank">'.esc_html($address).'</a>';
	}else{
		$output .= esc_html($address);
	}
	$output .= '</div></div>';
}
if ( $phone || $phone2 ) {
	$output .= '<div class="store-phone">'.$ico_phone;
	$phone_html = '';
	//if ( $phone != '' ) {
		if ( strpos($phone, ':') == false ) {
			$phone_html .= '<a href="tel:'.str_replace(' ', '', esc_html($phone) ).'">'.esc_html($phone).'</a>';
		}else{
			$phone_html .= esc_html($phone);
		}
	//}
	$output .= $phone_html.'</div></div>';
}
if ( $phone2 ) {
	$output .= '<div class="store-phone">'.$ico_phone2;
	$phone_html = '';
	//if ( $phone2 != '' ) {
		if ( $phone_html != '' ) { $phone_html .= '<br/>'; }
		if ( strpos($phone2, ':') == false ) {
			$phone_html .= '<a href="tel:'.str_replace(' ', '', esc_html($phone2) ).'">'.esc_html($phone2).'</a>';
		}else{
			$phone_html .= esc_html($phone2);
		}
	//}
	$output .= $phone_html.'</div></div>';
}
if ( $email ) {
	$output .= '<div class="store-email">'.$ico_email;
	$email_html = '';
	if ( $email != '' ) {
		if ( strpos($email, ':') == false ) {
			$email_html .= '<a href="mailto:'.esc_html($email).'">'.esc_html($email).'</a>';
		}else{
			$email_html .= esc_html($email);
		}
	}
	$output .= $email_html.'</div></div>';
}

$output .= '</div>';
$output .= '</div>';

echo $output;