<?php
$output = '';
$atts = vc_map_get_attributes( 'sns_list_posts', $atts );
extract( $atts );

global $post;
$args = array(
	'post_status' => 'publish',
	'post_type' => 'post',
	'orderby' => ($orderby) ? $orderby : 'date',
	'order' => ($sortorder) ? $sortorder : 'DESC',
	'posts_per_page' => (int)$number_limit,
	'ignore_sticky_posts' => 1,
);
if(!empty($category)){
	$cat_id = explode(',', $category );
	$args['tax_query'] = array(
		array(
			'taxonomy' => 'category',
			'field' => 'slug',
			'terms' => $cat_id
		)
	);
}
$lp_query = new WP_Query( $args );
$uq = rand().time();
$class = 'sns-list-posts';
if ( $show_author == '1' ) $class .= ' show-author';
if ( $show_date == '1' ) $class .= ' show-date';
$class .= ( trim($extra_class)!='' )?' '.esc_attr($extra_class):'';
$class .= ' '.esc_attr( manh_getCSSAnimation( $css_animation ) );
$class .= ' '.esc_attr($style);
$class .= ' item-style-'.esc_attr($item_style);

if( $lp_query->have_posts() ) :
	$output .= '<div id="sns_listposts'.$uq.'" class="'.$class.'">';
	if ( $title != '' ) $output .= '<h3 class="wpb_heading"><span>'.esc_attr($title).'</span></h3>';
	
	if ( $style == 'style1' ) {
		if ( $thumbnail == '' ) { $thumbnail = 'manh_blog_tiny_thumb'; }
		$output .= '<div class="list-post">';
		while ( $lp_query->have_posts() ) : $lp_query->the_post();
			$output .= '<div class="item-post">';
			$img = wp_get_attachment_image_src(get_post_thumbnail_id($post->ID),  $thumbnail);
			if( isset( $img['0'] ) && $img['0'] != '' ){
				$output .= '<div class="post-img"><a href="'.esc_url( get_permalink() ).'"><img src="'.$img['0'].'" alt="'.get_the_title().'"/></a></div>';
			}
			$output .= '<div class="post-title"><a title="'.get_the_title().'" href="'.esc_url( get_permalink() ).'">'.manh_limitwords(get_the_title(), 8).'</a></div>';
			if ( $show_author == '1' ) {
				$output .= '<div class="post-author"><a class="author-link" href="'.esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ).'">'.get_the_author_meta('display_name').'</a></div>';
			}
			if ( $show_date == '1' ) {
				$output .= '<div class="post-date"><span>'.get_the_date().'</span></div>';
			}
			if ( $show_desc == '1' ) {
				$output .= '<div class="post-excerpt">';
	            if( empty( $post->post_excerpt ) ) {
	            	$readmore = '<span>'.esc_html__('Read More', 'manh-shortcodes').'</span>';
	                $output .= manh_limitwords(strip_shortcodes(get_the_content($readmore)), 12);
	            } else {
	                $output .='<div>'.manh_excerpt(12, '<div class="dot-more">...</div>').'</div>';
	            }
			    $output .= '</div>';
			}
			$output .= '</div>';
		endwhile;
		$output .= '</div>';
	}elseif ( $style == 'style2' ) {
		$data = '';
		$data .= ' data-desktop="'.$number_desktop.'"';
		$data .= ' data-tabletl="'.$number_tablet.'"';
		$data .= ' data-tabletp="'.$number_tabletp.'"';
		$data .= ' data-mobilel="'.$number_mobilel.'"';
		$data .= ' data-mobilep="'.$number_mobilep.'"';
		$output .= '<div class="list-post"><div class="owl-carousel"'.$data.'>';
		if ( $thumbnail == '' ) { $thumbnail = 'manh_blog_large_thumb'; }
		ob_start();
		while ( $lp_query->have_posts() ) : $lp_query->the_post(); ?>
			<div class="item-post">
				<div class="post-img">
					<a href="<?php echo esc_url( get_permalink() ) ;?>">
						<?php echo get_the_post_thumbnail($post->ID, $thumbnail); ?>
					</a>
					<?php if ( $show_date == '1' && $item_style == '2') : ?>
					<div class="post-date">
						<?php printf( '<a href="%1$s" rel="bookmark"><time class="entry-date published" datetime="%2$s">%3$s</time></a>',
				            get_permalink(),
				            esc_attr( get_the_date( DATE_W3C ) ),
				            get_the_date()
				        );?>
					</div><?php endif; ?>
				</div>
				<div class="post-info">
					<?php if ( $item_style == '1' && ( $show_author == '1' || $show_date == '1' || $show_cat == '1') ) { ?>
					<div class="post-meta">
<?php if ( $show_date == '1' ) : ?>
	<div class="post-date">
		<?php printf( '<a href="%1$s" rel="bookmark"><time class="entry-date published" datetime="%2$s">%3$s</time></a>',
            get_permalink(),
            esc_attr( get_the_date( DATE_W3C ) ),
            get_the_date()
        );?>
	</div><?php endif; ?><?php if ( $show_cat == '1' ) :
$post_categories = get_the_terms( $post->ID, 'category' );
if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
$cate_name = wp_list_pluck( $post_categories, 'name' );
$cate_id = wp_list_pluck( $post_categories, 'term_id' );
echo '<div class="post-cat">'.esc_html__('In: ', 'manh-shortcodes').'<a href="' . get_category_link($cate_id[0]) . '">' .$cate_name[0] . '</a></div>';
}?>
<?php endif; ?><?php if ( $show_author == '1' ) : ?><div class="post-author">
	<?php echo esc_html__('By:', 'manh-shortcodes') . ' <a class="author-link" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . get_the_author_meta('display_name') . '</a>';?></div>
<?php endif; ?>
					</div>
					<?php } ?>
					<h5 class="post-title"><a href="<?php echo esc_url( get_permalink() ) ;?>"><?php echo get_the_title(); ?></a></h5>
					<?php if ( $item_style == '2' && ( $show_author == '1' || $show_date == '1' || $show_cat == '1') ) { ?>
					<div class="post-meta">
<?php if ( $show_cat == '1' ) :
$post_categories = get_the_terms( $post->ID, 'category' );
if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
$cate_name = wp_list_pluck( $post_categories, 'name' );
$cate_id = wp_list_pluck( $post_categories, 'term_id' );
echo '<div class="post-cat">'.esc_html__('In: ', 'manh-shortcodes').'<a href="' . get_category_link($cate_id[0]) . '">' .$cate_name[0] . '</a></div>';
}?>
<?php endif; ?><?php if ( $show_author == '1' ) : ?><div class="post-author">
	<?php echo esc_html__('By:', 'manh-shortcodes') . ' <a class="author-link" href="' . esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ) . '">' . get_the_author_meta('display_name') . '</a>';?></div>
<?php endif; ?>
					</div>
					<?php } ?>
					<?php if ( $show_desc == '1' ) { ?>
					<div class="post-excerpt">
		                <?php 
		                if( empty( $post->post_excerpt ) ) {
		                	$readmore = '<span>'.esc_html__('Read More', 'manh-shortcodes').'</span>';
		                    echo manh_limitwords(strip_shortcodes(get_the_content($readmore)), 18);
		                } else { ?>
		                    <p><?php echo manh_excerpt(12, ''); ?></p>
		                    <a class="more-link" href="<?php echo esc_url( get_permalink() ) ;?>"><?php echo esc_html__( 'read more','manh-shortcodes' ); ?></a>
		                <?php } ?>
		            </div>
			        <?php }else{ ?>
			        	<?php if (1==0 && $item_style == '2') { ?>
			        	<a class="more-link" href="<?php echo esc_url( get_permalink() ) ;?>"><?php echo esc_html__( 'read more','manh-shortcodes' ); ?></a>
			        	<?php } ?>
			        <?php } ?>
				</div>
			</div>
		<?php
		endwhile;
		$output .= ob_get_clean();
		$output .= '</div></div>';
	}elseif ( $style == 'style3' ) {
		$output .= '<div class="list-post special-slick-syncing"><div class="row">';
		if ( $thumbnail == '' ) { $thumbnail = 'manh_blog_large_thumb'; }
		ob_start();
		?>
		<div class="list-post-info slider-for col-md-4 col-sm-12">
		<?php
		while ( $lp_query->have_posts() ) : $lp_query->the_post(); ?>
			<div class="post-info">
				<?php if ( $show_cat == '1' ) { ?>
					<div class="post-meta">
						<?php 
						$post_categories = get_the_terms( $post->ID, 'category' );
						if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
						    $cate_name = wp_list_pluck( $post_categories, 'name' );
						    $cate_id = wp_list_pluck( $post_categories, 'term_id' );
						    $length = count($cate_id);
						    echo '<a class="post-cat" href="' . get_category_link($cate_id[$length - 1]) . '">' .$cate_name[$length - 1] . '</a>';
						}
						?>
					</div>
				<?php } ?>
				<h4 class="post-title second-font"><a href="<?php echo esc_url( get_permalink() ) ;?>"><?php echo get_the_title(); ?></a></h4>
				<div class="post-excerpt">
	                <?php 
	                if( empty( $post->post_excerpt ) ) {
	                	$readmore = '<span>'.esc_html__('Read More', 'manh-shortcodes').'</span>';
	                    echo manh_limitwords(strip_shortcodes(get_the_content($readmore)), 18);
	                } else { ?>
	                    <p><?php echo manh_excerpt(12, ''); ?></p>
	                    <a class="more-link button" href="<?php echo esc_url( get_permalink() ) ;?>"><?php echo esc_html__( 'Read more','manh-shortcodes' ); ?></a>
	                <?php } ?>
	            </div>
			</div>
		<?php
		endwhile; ?>
		</div>
		<div class="list-post-thumb slider-nav col-md-8 col-sm-12">
		<?php
		while ( $lp_query->have_posts() ) : $lp_query->the_post(); ?>
			<div class="post-img"><a href="<?php echo esc_url( get_permalink() ) ;?>"><?php echo get_the_post_thumbnail($post->ID, $thumbnail); ?></a></div>
		<?php
		endwhile; ?>
		</div>
		<?php
		$output .= ob_get_clean();
		$output .= '</div></div>';
	}

	$output .= '</div>';
endif;
wp_reset_postdata();
echo $output;
