<?php
// SNS Time Count Down
add_shortcode('sns_time_countdown', 'manh_time_countdown_template');
add_action('vc_after_init', 'manh_time_countdown_settings');
function manh_time_countdown_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_time_countdown'))
        include $template;
    return ob_get_clean();
}
function manh_time_countdown_settings() {
	$extra_class = manh_extra_class();
	vc_map( array(
		"name"  => esc_html__("SNS Time Count Down", 'manh-shortcodes'),
		"base" => "sns_time_countdown",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Show time count down', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Date", 'manh-shortcodes'),
				"param_name" => "thedate" ,
				"value" => '2022/04/25 11:45:30',
				'description' => esc_html__( 'The format date is Y/m/d H:i:s. EX: 2022/04/25 11:45:30', 'manh-shortcodes' ),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'manh-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style1",'manh-shortcodes') => 'style1',
					esc_html__("Style2",'manh-shortcodes') => 'style2',
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	));
}