<?php
// SNS Store Info
add_shortcode('sns_store_info', 'manh_store_info_template');
add_action('vc_after_init', 'manh_store_info_settings');
function manh_store_info_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_store_info'))
        include $template;
    return ob_get_clean();
}
function manh_store_info_settings() {
	$extra_class = manh_extra_class();
	vc_map( array(
		"name"  => esc_html__("SNS Store Info", 'manh-shortcodes'),
		"base" => "sns_store_info",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Store info: Address, Phone, Email, ...', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title", 'manh-shortcodes'),
				"param_name" => "title" ,
				"value" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'manh-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Show label",'manh-shortcodes') => '1',
					esc_html__("Show icon",'manh-shortcodes') => '2',
					esc_html__("Show icon and label",'manh-shortcodes') => '3',
				),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Logo Store", 'manh-shortcodes'),
		      "param_name" => "logo_store",
		    ),
			array(
				"type" => "textarea",
				"heading" => esc_html__("Short Intro", 'manh-shortcodes'),
				"param_name" => "short_intro"
			),
		    array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon for Address', 'manh-shortcodes' ),
				'param_name' => 'icon_address',
				'value' => 'fa fa-adjust',
				'settings' => array(
					'emptyIcon' => false,
					'type' => 'ionicons',
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'style',
					'value' => array('2', '3'),
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				"type" => "textarea",
				"heading" => esc_html__("Address", 'manh-shortcodes'),
				"param_name" => "address"
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Direction Link for Address", 'manh-shortcodes'),
				"param_name" => "direction_link"
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon for E-Mail', 'manh-shortcodes' ),
				'param_name' => 'icon_email',
				'value' => 'fa fa-adjust',
				'settings' => array(
					'emptyIcon' => false,
					'type' => 'ionicons',
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'style',
					'value' => array('2', '3'),
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("E-Mail", 'manh-shortcodes'),
				"param_name" => "email"
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon for Phone', 'manh-shortcodes' ),
				'param_name' => 'icon_phone',
				'value' => 'fa fa-adjust',
				'settings' => array(
					'emptyIcon' => false,
					'type' => 'ionicons',
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'style',
					'value' => array('2', '3'),
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Phone", 'manh-shortcodes'),
				"param_name" => "phone"
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon for Mobile Number', 'manh-shortcodes' ),
				'param_name' => 'icon_phone2',
				'value' => 'fa fa-adjust',
				'settings' => array(
					'emptyIcon' => false,
					'type' => 'ionicons',
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'style',
					'value' => array('2', '3'),
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Mobile Number", 'manh-shortcodes'),
				"param_name" => "phone2"
			),
			
			
			vc_map_add_css_animation(),
			$extra_class,
		)
	));
}