<?php
// SNS Social Links
add_shortcode('sns_social_links', 'manh_social_links_template');
add_action('vc_after_init', 'manh_social_links_settings');
function manh_social_links_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_social_links'))
        include $template;
    return ob_get_clean();
}
function manh_social_links_settings() {
	$extra_class = manh_extra_class();
	vc_map( array(
		"name"  => esc_html__("SNS Social Links", 'manh-shortcodes'),
		"base" => "sns_social_links",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Display link to your social links', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Label for Follow us", 'manh-shortcodes'),
				"param_name" => "label_followus" ,
				"value" => esc_html__("Follow us on:", 'manh-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'manh-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Rounded",'manh-shortcodes') => '1',
					esc_html__("Circle",'manh-shortcodes') => '2',
					esc_html__("Simple",'manh-shortcodes') => '3',
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Facebook link", 'manh-shortcodes'),
				"param_name" => "facebook_link" ,
				"value" => ""
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Twitter link", 'manh-shortcodes'),
				"param_name" => "twitter_link" ,
				"value" => ""
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Youtube link", 'manh-shortcodes'),
				"param_name" => "youtube_link" ,
				"value" => ""
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Pinterest link", 'manh-shortcodes'),
				"param_name" => "pinterest_link" ,
				"value" => ""
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Instagram link", 'manh-shortcodes'),
				"param_name" => "instagram_link" ,
				"value" => ""
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	));
}