<?php
// SNS Single Testimonial
add_shortcode('sns_single_testimonial', 'manh_single_testimonial_template');
add_action('vc_after_init', 'manh_single_testimonial_settings');
function manh_single_testimonial_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_single_testimonial'))
        include $template;
    return ob_get_clean();
}
function manh_single_testimonial_settings() {
	$extra_class = manh_extra_class();
	$css_animation = manh_css_animation();
	
	vc_map( array(
		"name"  => esc_html__("SNS Single Testimonial", 'manh-shortcodes'),
		"base" => "sns_single_testimonial",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Display single Testimonial', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textarea",
				"heading" => esc_html__("Testimonial content", 'manh-shortcodes'),
				"param_name" => "testimonial_content"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Style",'manh-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style 1",'manh-shortcodes') => 'style1',
					esc_html__("Style 2",'manh-shortcodes') => 'style2',
					// esc_html__("Style 3",'manh-shortcodes') => 'style3',
					// esc_html__("Style 4",'manh-shortcodes') => 'style4',
				),
			),
			array(
		        "type" => "attach_image",
		        "heading" => esc_html__("Author avatar", 'manh-shortcodes'),
		        "param_name" => "author_avatar",
		        "dependency" => Array('element' => "style", 'value' => 'style2')
		    ),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Author name",'manh-shortcodes'),
				"param_name" => "author_name",
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Author position",'manh-shortcodes'),
				"param_name" => "author_position",
				"admin_label" => true,
			),
			
			$extra_class,
			$css_animation,
		)
	));
}