<?php
// SNS Info Box
add_shortcode('sns_popup_video', 'manh_popup_video_template');
add_action('vc_after_init', 'manh_popup_video_settings');
function manh_popup_video_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_popup_video'))
        include $template;
    return ob_get_clean();
}
function manh_popup_video_settings() {
	$extra_class = manh_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Popup Video", 'manh-shortcodes'),
		"base" => "sns_popup_video",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Popup video', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Video link", 'manh-shortcodes'),
				"param_name" => "video_link" ,
				"description" => esc_html__("You can use video url from Youtube, Vimeo", 'manh-shortcodes'),
				"value" => "",
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Background image for video", 'manh-shortcodes'),
		      "param_name" => "bg_image_video",
		    ),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("Height for wrap", 'manh-shortcodes'),
				"param_name" => "height_wrap" ,
				"value" => esc_html__("680px", 'manh-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title", 'manh-shortcodes'),
				"param_name" => "title",
				"value" => esc_html__("Your Title Here ...",'manh-shortcodes'),
				"admin_label" => true 
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Sub title", 'manh-shortcodes'),
				"param_name" => "sub_title" ,
				"value" => esc_html__("Your sub title here ...",'manh-shortcodes'),
				"description" => esc_html__("It's margin-top for title, example: 5px", 'manh-shortcodes')
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}