<?php
// SNS Info Box
add_shortcode('sns_loginregister', 'manh_loginregistertemplate');
add_action('vc_after_init', 'manh_loginregistersettings');
function manh_loginregistertemplate($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_loginregister'))
        include $template;
    return ob_get_clean();
}
function manh_loginregistersettings() {
	$extra_class = manh_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Login and Register", 'manh-shortcodes'),
		"base" => "sns_loginregister",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Contain login, register link, welcome text,....', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Want to use welcome text", 'manh-shortcodes'),
				"param_name" => "welcome_text",
				"value" => "",
				'description' => __( 'Example: Hello/Hi/Welcome...', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Login text link", 'manh-shortcodes'),
				"param_name" => "login_text" ,
				"description" => esc_html__("Example: Login", 'manh-shortcodes'),
				"value" => esc_html__("Login", 'manh-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Want to use seperator between Login and Register?", 'manh-shortcodes'),
				"param_name" => "seperator",
				"value" => esc_html__("|",'manh-shortcodes'),
				'description' => __( 'Example: or', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Register text link", 'manh-shortcodes'),
				"param_name" => "register_text" ,
				"description" => esc_html__("Example: Sign up", 'manh-shortcodes'),
				"value" => esc_html__("Register", 'manh-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Logout text link", 'manh-shortcodes'),
				"param_name" => "logout_text" ,
				"description" => esc_html__("Example: Logout", 'manh-shortcodes'),
				"value" => esc_html__("Logout", 'manh-shortcodes')
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}