<?php
// SNS List Post
add_shortcode('sns_list_posts', 'manh_list_posts_template');
add_action('vc_after_init', 'manh_list_posts_settings');
function manh_list_posts_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_list_posts'))
        include $template;
    return ob_get_clean();
}
function manh_list_posts_settings() {
	$extra_class = manh_extra_class();
	$cat_value = manh_cat();
		vc_map( array(
		"name" => esc_html__("SNS List Post",'manh-shortcodes'),
		"base" => "sns_list_posts",
		"icon" => "sns_icon_listposts",
		"class" => "sns_listposts",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Show List Posts", 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"value" =>  esc_html__("Latest News",'manh-shortcodes'),
				"admin_label" => true,
			),
			array(
				"type" => "checkbox",
				"value" => $cat_value,
				"class" => "",
				"heading" => esc_html__("Categories",'manh-shortcodes'),
				"description" => esc_html__( "If you dont sellect category, the default is sellected all category", 'manh-shortcodes' ),
				"param_name" => "category"
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show category?",'manh-shortcodes'),
				"param_name" => "show_cat",
				"class" => "",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '2',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show date?",'manh-shortcodes'),
				"param_name" => "show_date",
				"class" => "",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '2',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show author?",'manh-shortcodes'),
				"param_name" => "show_author",
				"class" => "",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '2',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show description?",'manh-shortcodes'),
				"param_name" => "show_desc",
				"class" => "",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Template style",'manh-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Style1 - List",'manh-shortcodes') =>  'style1',
					esc_html__("Style2 - Carousel",'manh-shortcodes') => 'style2',
					esc_html__("Style3 - Slick slider",'manh-shortcodes') => 'style3',
				),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Item style",'manh-shortcodes'),
				"param_name" => "item_style",
				"class" => "",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style2'),
				),
				"value" => array(
					esc_html__("Default - style 1",'manh-shortcodes') => '1',
					esc_html__("Style 2",'manh-shortcodes') =>  '2',
				),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Want to choose thumbnail",'manh-shortcodes'),
				"param_name" => "thumbnail",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '',
					esc_html__("manh_blog_tiny_footer_thumb",'manh-shortcodes') => 'manh_blog_tiny_footer_thumb',
					esc_html__("manh_blog_tiny_thumb",'manh-shortcodes') => 'manh_blog_tiny_thumb',
					esc_html__("manh_blog_small_thumb",'manh-shortcodes') => 'manh_blog_small_thumb',
					esc_html__("manh_blog_large_thumb",'manh-shortcodes') => 'manh_blog_large_thumb',
					esc_html__("WP thumbnail",'manh-shortcodes') => 'thumbnail',
					esc_html__("WP medium",'manh-shortcodes') => 'medium',
					esc_html__("WP large",'manh-shortcodes') => 'large',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Posts number limit",'manh-shortcodes'),
				"param_name" => "number_limit",
				"value" => "4"
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Order By",'manh-shortcodes'),
				"param_name" => "orderby",
				"class" => "",
				"value" => array(
					esc_html__("Date",'manh-shortcodes') => 'date',
					esc_html__("Title",'manh-shortcodes') =>  'title',
					esc_html__("author",'manh-shortcodes') =>  'author',
					esc_html__("Random",'manh-shortcodes') =>  'rand',
					esc_html__("Comment Count",'manh-shortcodes') =>  'comment_count',
					esc_html__("Menu Order",'manh-shortcodes') =>  'menu_order',
				),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Sort order",'manh-shortcodes'),
				"param_name" => "sortorder",
				"class" => "",
				"value" => array(
					esc_html__("ASC",'manh-shortcodes') => 'ASC',
					esc_html__("DESC",'manh-shortcodes') =>  'DESC',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'manh-shortcodes'),
				"param_name" => "number_desktop",
				"value" => "5",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style2'),
				),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'manh-shortcodes'),
				"param_name" => "number_tablet",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style2'),
				),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'manh-shortcodes'),
				"param_name" => "number_tabletp",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style2'),
				),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'manh-shortcodes'),
				"param_name" => "number_mobilel",
				"value" => "2",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style2'),
				),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'manh-shortcodes'),
				"param_name" => "number_mobilep",
				"value" => "1",
				'dependency' => array(
					'element' => 'style',
					'value' => array('style2'),
				),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}