<?php
// SNS Instagram
add_shortcode('sns_instagram', 'manh_instagram_template');
add_action('vc_after_init', 'manh_instagram_settings');
function manh_instagram_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_instagram'))
        include $template;
    return ob_get_clean();
}
function manh_instagram_settings() {
	$extra_class = manh_extra_class();
		vc_map( array(
		"name" => esc_html__("SNS Instagram",'manh-shortcodes'),
		"base" => "sns_instagram",
		"icon" => "sns_icon_listposts",
		"class" => "sns_listposts",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Show instagram feed", 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"value" =>  esc_html__("Instagram",'manh-shortcodes'),
				"admin_label" => true,
			),
			array(
				'type' => 'textarea_html',
				"heading" => esc_html__("Want to show Description?", 'manh-shortcodes'),
				"param_name" => "content",
				"admin_label" => true 
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Dispplay type",'manh-shortcodes'),
				"param_name" => "type",
				"class" => "",
				"value" => array(
					esc_html__("New feed",'manh-shortcodes') => 'new',
					esc_html__("By tag",'manh-shortcodes') =>  'tag',
				),
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Tag name",'manh-shortcodes'),
				"param_name" => "tag",
				"value" =>  esc_html__("sns_manh",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'type',
					'value' => array('tag'),
				),
			),
			// array(
			// 	"type" => "textfield",
			// 	"class" => "",
			// 	"heading" => esc_html__("User id",'manh-shortcodes'),
			// 	"param_name" => "user_id",
			// 	"value" =>  esc_html__("5922978930",'manh-shortcodes'),
			// 	'dependency' => array(
			// 		'element' => 'type',
			// 		'value' => array('new'),
			// 	),
			// 	"admin_label" => true,
			// ), 
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Access token",'manh-shortcodes'),
				"param_name" => "access_token",
				"value" =>  esc_html__("IGQVJWaXVJaWhzbnVneEpiVjF5dmFlZAzBXMjNJZAVFhaUhDT1J0QWtDMGtfcnlESHBwWmdjbjZAkOHBsNjljNWtHSnBKdnZAYWDdxaFl4TzFoTWJwWUYtYnVqdDBtX1RyclFycHBlY3NrT3lkTkhmb05JawZDZD",'manh-shortcodes'),
				"admin_label" => true,
				'description' => __( 'How to get: User id and Access token http://domain.com', 'manh-shortcodes' ),
			),
			
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Dispplay style",'manh-shortcodes'),
				"param_name" => "style",
				"value" => array(
					esc_html__("Grid",'manh-shortcodes') =>  'grid',
					esc_html__("Grid Special",'manh-shortcodes') =>  'grid-special',
					esc_html__("Carousel",'manh-shortcodes') => 'carousel',
				),
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Follow link",'manh-shortcodes'),
				"param_name" => "follow_link",
				"value" =>  esc_html__("",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'style',
					'value' => array('grid-special', 'carousel'),
				),
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Instagram name",'manh-shortcodes'),
				"param_name" => "instagram_name",
				"value" =>  esc_html__("",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'style',
					'value' => array('grid-special', 'carousel'),
				),
				"admin_label" => true,
			), 
			// array(
			// 	"type" => "dropdown",
			// 	"class" => "",
			// 	"heading" => esc_html__("Photo size",'manh-shortcodes'),
			// 	"param_name" => "size",
			// 	"value" => array(
			// 		esc_html__("Standard",'manh-shortcodes') => '',
			// 		esc_html__("Low",'manh-shortcodes') => 'low',
			// 		esc_html__("Thumbnail",'manh-shortcodes') => 'thumbnail',
			// 	),
			// ),

			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number limit",'manh-shortcodes'),
				"param_name" => "limit",
				"value" => "8",
				'dependency' => array(
					'element' => 'style',
					'value' => array('grid', 'carousel'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column on row",'manh-shortcodes'),
				"param_name" => "number",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('grid'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'manh-shortcodes'),
				"param_name" => "number_desktop",
				"value" => "5",
				'dependency' => array(
					'element' => 'style',
					'value' => array('carousel'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'manh-shortcodes'),
				"param_name" => "number_tablet",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('carousel'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'manh-shortcodes'),
				"param_name" => "number_tabletp",
				"value" => "4",
				'dependency' => array(
					'element' => 'style',
					'value' => array('carousel'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'manh-shortcodes'),
				"param_name" => "number_mobilel",
				"value" => "2",
				'dependency' => array(
					'element' => 'style',
					'value' => array('carousel'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'manh-shortcodes'),
				"param_name" => "number_mobilep",
				"value" => "1",
				'dependency' => array(
					'element' => 'style',
					'value' =>array('carousel'),
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}