<?php
// SNS Info Box
add_shortcode('sns_info_inline', 'manh_info_inline_template');
add_action('vc_after_init', 'manh_info_inline_settings');
function manh_info_inline_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_info_inline'))
        include $template;
    return ob_get_clean();
}
function manh_info_inline_settings() {
	$extra_class = manh_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Info Inline", 'manh-shortcodes'),
		"base" => "sns_info_inline",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Contain: icon, title, link, ... and display inline', 'manh-shortcodes' ),
		"params" => array(
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Style', 'manh-shortcodes' ),
				'value' => array(
					esc_html__( 'Default', 'manh-shortcodes' ) => '',
					esc_html__( 'Social', 'manh-shortcodes' ) => 'social',
					esc_html__( 'Social Rounded', 'manh-shortcodes' ) => 'social_rounded',
				),
				'param_name' => 'style',
			),
			// array(
			// 	'type' => 'checkbox',
			// 	'heading' => __( 'Use icon?', 'manh-shortcodes' ),
			// 	'param_name' => 'use_icon',
			// 	'description' => __( 'Use icon in content', 'manh-shortcodes' ),
			// ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Use icon?', 'manh-shortcodes' ),
				'value' => array(
					esc_html__( 'No', 'manh-shortcodes' ) => '',
					esc_html__( 'Font Awesome', 'manh-shortcodes' ) => 'fontawesome',
					esc_html__( 'Ionicons', 'manh-shortcodes' ) => 'ionicons',
				),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_ionicons',
				'value' => '', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'type' => 'ionicons',
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'ionicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use label?', 'manh-shortcodes' ),
				'param_name' => 'use_label',
				'description' => __( 'Use label in content', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Label", 'manh-shortcodes'),
				"param_name" => "label",
				"value" => esc_html__("Your label here ...",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'use_label',
					'value' => 'true',
				),
				
			),
			array(
				'type' => 'checkbox',
				'heading' => __( 'Use link?', 'manh-shortcodes' ),
				'param_name' => 'use_link',
				'description' => __( 'Use link in content', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Link", 'manh-shortcodes'),
				"param_name" => "link" ,
				"description" => esc_html__("Enter the  link. Do't forget to include http:// ", 'manh-shortcodes'),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				"value" => esc_html__("http://", 'manh-shortcodes'),
				"admin_label" => true 
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Link type', 'manh-shortcodes' ),
				'value' => array(
					esc_html__( 'Default', 'manh-shortcodes' ) => '0',
					esc_html__( 'Use mailto:', 'manh-shortcodes' ) => '1',
					esc_html__( 'Use tel:', 'manh-shortcodes' ) => '2',
				),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				'param_name' => 'href_type',
			),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Link target', 'manh-shortcodes' ),
				'value' => array(
					esc_html__( 'Same window', 'manh-shortcodes' ) => '_self',
					esc_html__( 'New window', 'manh-shortcodes' ) => '_blank',
				),
				'dependency' => array(
					'element' => 'use_link',
					'value' => 'true',
				),
				'param_name' => 'target',
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}