<?php
// SNS Info Box
add_shortcode('sns_info_box', 'manh_info_box_template');
add_action('vc_after_init', 'manh_info_box_settings');
function manh_info_box_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_info_box'))
        include $template;
    return ob_get_clean();
}

function manh_info_box_settings() {
	$extra_class = manh_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Info Box", 'manh-shortcodes'),
		"base" => "sns_info_box",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Box contain: icon, title, description', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'Style 1', 'manh-shortcodes' ) => '1',
					esc_html__( 'Style 2', 'manh-shortcodes' ) => '2',
					esc_html__( 'Style 3', 'manh-shortcodes' ) => '3',
					// esc_html__( 'Style 4 - Align left and icon have circle background', 'manh-shortcodes' ) => '4',
					// esc_html__( 'Style 5 - Align left and icon have circle background, box have rectangle background', 'manh-shortcodes' ) => '5',
					// esc_html__( 'Style 6 - Align center and icon have rectangle background, all contents display block', 'manh-shortcodes' ) => '6',
				),
				"heading" => esc_html__("Box style", 'manh-shortcodes'),
				"param_name" => "box_style"
		    ),
		    array(
				"type" => "dropdown",
				"heading" => esc_html__("Want use effect when hover for icon",'manh-shortcodes'),
				"param_name" => "want_effect",
				"class" => "",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '2',
				),
				'dependency' => array(
					'element' => 'box_style',
					'value' => array('1'),
				),
			),
			// array(
			// 	"type" => "colorpicker",
			// 	"value" => "",
			// 	"heading" => esc_html__("Background color for Box", 'manh-shortcodes'),
			// 	'dependency' => array(
			// 		'element' => 'box_style',
			// 		'value' => array('2'),
			//    ),
			// 	"param_name" => "bg_color"
		 //    ),
		 //    array(
			// 	"type" => "textfield",
			// 	"heading" => esc_html__("Border radius for Box", 'manh-shortcodes'),
			// 	"param_name" => "border_radius" ,
			// 	"description" => esc_html__("It's css border-radius", 'manh-shortcodes'),
			// 	"value" => esc_html__("30px 0px", 'manh-shortcodes'),
			// 	'dependency' => array(
			// 		'element' => 'box_style',
			// 		'value' => array('5'),
			//     ),
			// ),
			array(
				'type' => 'dropdown',
				'heading' => esc_html__( 'Icon library', 'manh-shortcodes' ),
				'value' => array(
					esc_html__( 'Media', 'manh-shortcodes' ) => 'media',
					esc_html__( 'Font Awesome', 'manh-shortcodes' ) => 'fontawesome',
					esc_html__( 'Ionicons', 'manh-shortcodes' ) => 'ionicons',
					esc_html__( 'Open Iconic', 'manh-shortcodes' ) => 'openiconic',
					esc_html__( 'Typicons', 'manh-shortcodes' ) => 'typicons',
					esc_html__( 'Entypo', 'manh-shortcodes' ) => 'entypo',
					esc_html__( 'Linecons', 'manh-shortcodes' ) => 'linecons',
				),
				'param_name' => 'icon_type',
				'description' => esc_html__( 'Select icon library.', 'manh-shortcodes' ),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Image", 'manh-shortcodes'),
		      "param_name" => "icon_image",
		      'dependency' => array(
					'element' => 'icon_type',
					'value' => 'media',
			   ),
		    ),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_fontawesome',
				'value' => 'fa fa-adjust', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false,
					'iconsPerPage' => 4000,
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'fontawesome',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_ionicons',
				'value' => '', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'ionicons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'ionicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_openiconic',
				'value' => 'vc-oi vc-oi-dial', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'openiconic',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'openiconic',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_typicons',
				'value' => 'typcn typcn-adjust-brightness', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'typicons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'typicons',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_entypo',
				'value' => 'entypo-icon entypo-icon-note', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'entypo',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'entypo',
				),
			),
			array(
				'type' => 'iconpicker',
				'heading' => esc_html__( 'Icon', 'manh-shortcodes' ),
				'param_name' => 'icon_linecons',
				'value' => 'vc_li vc_li-heart', // default value to backend editor admin_label
				'settings' => array(
					'emptyIcon' => false, // default true, display an "EMPTY" icon?
					'type' => 'linecons',
					'iconsPerPage' => 4000, // default 100, how many icons per/page to display
				),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => 'linecons',
				),
				'description' => esc_html__( 'Select icon from library.', 'manh-shortcodes' ),
			),
			array(
				"type" => "colorpicker",
				"value" => "",
				"heading" => esc_html__("Color for icon", 'manh-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('linecons','fontawesome','ionicons','entypo','typicons','openiconic'),
				),
				// 'dependency' => array(
				// 	'element' => 'box_style',
				// 	'value' => array('1','5'),
				// ),
				"param_name" => "icon_color"
		    ),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("Max height for image", 'manh-shortcodes'),
				"param_name" => "mheight_size" ,
				"value" => esc_html__("70px",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('media'),
				),
				"description" => esc_html__("It's max height for Image", 'manh-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Font size for icon", 'manh-shortcodes'),
				"param_name" => "icon_font_size" ,
				"value" => esc_html__("",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'icon_type',
					'value' => array('linecons', 'fontawesome', 'ionicons', 'entypo','typicons','openiconic'),
				),
				'dependency' => array(
					'element' => 'box_style',
					'value' => array('1', '2'),
				),
				"description" => esc_html__("It's font-size for icon you sellected, example: 24px", 'manh-shortcodes')
			),
			// array(
			// 	"type" => "textfield",
			// 	"heading" => esc_html__("Box icon size", 'manh-shortcodes'),
			// 	"param_name" => "max_width" ,
			// 	"description" => esc_html__("It's width/height for box contain icon, example: 40px", 'manh-shortcodes'),
			// 	'dependency' => array(
			// 		'element' => 'box_style',
			// 		'value' => array('1', '2', '4', '6'),
			// 	),
			// 	"value" => esc_html__("", 'manh-shortcodes')
			// ),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Custom Link", 'manh-shortcodes'),
				"param_name" => "link" ,
				"description" => esc_html__("Enter the  link. Do't forget to include http:// ", 'manh-shortcodes'),
				'dependency' => array(
					'element' => 'box_style',
					'value' => array('1'),
				),
				"value" => esc_html__("", 'manh-shortcodes')
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title", 'manh-shortcodes'),
				"param_name" => "title",
				"value" => esc_html__("",'manh-shortcodes'),
				// 'dependency' => array(
				// 	'element' => 'box_style',
				// 	'value' => array('1', '2'),
				// ),
				"admin_label" => true 
			),
			array(
				'type' => 'textarea_html',
				"heading" => esc_html__("Description", 'manh-shortcodes'),
				"param_name" => "content",
				"admin_label" => true,
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}