<?php
// SNS Carousel
add_shortcode('sns_grid_items', 'manh_grid_items_template');
add_action('vc_after_init', 'manh_grid_item_settings');
function manh_grid_items_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_grid_items'))
        include $template;
    return ob_get_clean();
}
function manh_grid_item_settings() {
	//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    	class WPBakeryShortCode_SNS_Grid_Items extends WPBakeryShortCodesContainer {}
    }
	$extra_class = manh_extra_class();
	$css_animation = manh_css_animation();
	if ( function_exists('vc_map') ) vc_map( array(
		"name"  => esc_html__("SNS Grid Items", 'manh-shortcodes'),
		"base" => "sns_grid_items",
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		"description" => esc_html__( 'A grid contain items', 'manh-shortcodes' ),
		"as_parent" => array('except' => 'sns_grid_items'),
	    // "content_element" => true,
	    // "show_settings_on_create" => true,
	    // "is_container" => true,
	    "js_view" => 'VcColumnView',
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number column/row on Desktop",'manh-shortcodes'),
				"param_name" => "n_desktop",
				"value" => esc_html__("1",'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number column/row on Tablet Landscape",'manh-shortcodes'),
				"param_name" => "n_tablet",
				"value" => esc_html__("1",'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number column/row on Tablet Portrait",'manh-shortcodes'),
				"param_name" => "n_tabletp",
				"admin_label" => true,
				"value" =>  esc_html__("1", 'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number column/row on Mobile Landscape",'manh-shortcodes'),
				"param_name" => "n_mobile_l",
				"value" => esc_html__("1",'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number column/row on Mobile Portrait",'manh-shortcodes'),
				"param_name" => "n_mobile_p",
				"value" => esc_html__("1",'manh-shortcodes'),
			),
			$extra_class,
			vc_map_add_css_animation(),
		)
	) );
}