<?php
// SNS Carousel
add_shortcode('sns_carousel', 'manh_carousel_template');
add_action('vc_after_init', 'manh_carousel_settings');
function manh_carousel_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_carousel'))
        include $template;
    return ob_get_clean();
}
function manh_carousel_settings() {
	//Your "container" content element should extend WPBakeryShortCodesContainer class to inherit all required functionality
	if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
    	class WPBakeryShortCode_SNS_Carousel extends WPBakeryShortCodesContainer {}
    }
	$extra_class = manh_extra_class();
	$css_animation = manh_css_animation();
	if ( function_exists('vc_map') ) vc_map( array(
		"name" => esc_html__("SNS Carousel",'manh-shortcodes'),
		"base" => "sns_carousel",
		"class" => "sns_carousel",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Carousel for other shortcodes",'manh-shortcodes' ),

	    "as_parent" => array('except' => 'sns_carousel'),
	    "content_element" => true,
	    "show_settings_on_create" => true,
	    "is_container" => false,
	    "js_view" => 'VcColumnView',

	    "params" => array(
	        // add params same as with any other content element
	        array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" => "",
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Slider Type",'manh-shortcodes'),
				"param_name" => "slider_type",
				"value" => array(
					esc_html__("Horizontal",'manh-shortcodes') => 'h',
					esc_html__("Horizontal center mode",'manh-shortcodes') => 'h-c',
					esc_html__("Horizontal Syncing with paging",'manh-shortcodes') => 'h-s',
					esc_html__("Vertical",'manh-shortcodes') =>  'v'
				)
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Position of image paging",'manh-shortcodes'),
				"param_name" => "pos_paging",
				"value" => array(
					esc_html__("on Top",'manh-shortcodes') => '1',
					esc_html__("on Bottom",'manh-shortcodes') =>  '2'
				),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => 'h-s'
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Show Navigation",'manh-shortcodes'),
				"param_name" => "show_nav",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '0',
					esc_html__("Yes",'manh-shortcodes') =>  '1'
				),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h', 'v' , 'h-c')
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Show Paging",'manh-shortcodes'),
				"param_name" => "show_paging",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '0',
					esc_html__("Yes",'manh-shortcodes') =>  '1'
				),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h', 'v')
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Auto play",'manh-shortcodes'),
				"param_name" => "autoplay",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '0'
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Want to check first/last item active?",'manh-shortcodes'),
				"param_name" => "check_class",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '0',
					esc_html__("Yes",'manh-shortcodes') =>  '1'
				),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number row on column",'manh-shortcodes'),
				"param_name" => "row",
				"value" => esc_html__("1",'manh-shortcodes'),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h', 'v')
				),
			),
	        array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Desktop",'manh-shortcodes'),
				"param_name" => "n_desktop",
				"value" => esc_html__("1",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Laptop",'manh-shortcodes'),
				"param_name" => "n_laptop",
				"value" => esc_html__("1",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Tablet Landscape",'manh-shortcodes'),
				"param_name" => "n_tablet",
				"value" => esc_html__("1",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number items on Tablet Portrait",'manh-shortcodes'),
				"param_name" => "n_tabletp",
				"admin_label" => true,
				"value" =>  esc_html__("1", 'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Mobile Landscape",'manh-shortcodes'),
				"param_name" => "n_mobile_l",
				"value" => esc_html__("1",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number items on Mobile Portrait",'manh-shortcodes'),
				"param_name" => "n_mobile_p",
				"value" => esc_html__("1",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'slider_type',
					'value' => array('h')
				),
			),
			$css_animation,
			$extra_class,
	    ),
	) );
}
