<?php
// SNS Blog Page
add_shortcode('sns_blog_page', 'manh_blog_page_template');
add_action('vc_after_init', 'manh_blog_page_settings');
function manh_blog_page_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_blog_page'))
        include $template;
    return ob_get_clean();
}
function manh_blog_page_settings() {
	$extra_class = manh_extra_class();
	$cat_value = manh_cat();
	vc_map( array(
		"name" => esc_html__("SNS Blog Page",'manh-shortcodes'),
		"base" => "sns_blog_page",
		"icon" => "sns_icon_blogpage",
		"class" => "sns_blogpage",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "To create blog page with some style", 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "checkbox",
				"value" => $cat_value,
				"class" => "",
				"heading" => esc_html__("Categories",'manh-shortcodes'),
				"description" => esc_html__( "If you dont sellect category, the default is sellected all category", 'manh-shortcodes' ),
				"param_name" => "category"
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Blog Style",'manh-shortcodes'),
				"param_name" => "blog_type",
				"value" => array(
					esc_html__("Blog default page", "manh-shortcodes") 	=> "layout1",
					esc_html__("Blog Masonry", "manh-shortcodes")	=>  "masonry",
				),
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Page Navigation",'manh-shortcodes'),
				"param_name" => "pagination",
				"value" => array(
					esc_html__("Default",'manh-shortcodes') => 'def',
					esc_html__("Ajax click load more",'manh-shortcodes') =>  'ajax',
					esc_html__("Ajax auto load more",'manh-shortcodes') =>  'ajax2'
				),
				'description' => esc_html__('Choose Type of navigation.','manh-shortcodes')
			),
            array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number post with each load more",'manh-shortcodes'),
				"param_name" => "masonry_numload",
				"value" => "3",
				'dependency' => array(
					'element' => 'pagination',
					'value' => array('ajax', 'ajax2')
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Post per pages",'manh-shortcodes'),
				"param_name" => "posts_per_page",
				"value" => "6"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Excerpt Length",'manh-shortcodes'),
				"param_name" => "excerpt_length",
				"value" => "75"
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}