<?php
// SNS Banner
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_SNS_Banner extends WPBakeryShortCode {
		function __construct( $settings ) {
			parent::__construct( $settings );
		}
	}
}
add_shortcode('sns_banner', 'manh_banner_template');
add_action('vc_after_init', 'manh_banner_settings');
function manh_banner_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_template('sns_banner'))
        include $template;
    return ob_get_clean();
}
function manh_banner_settings() {
	$extra_class = manh_extra_class();
    vc_map( array(
		"name"  => esc_html__("SNS Banner", 'manh-shortcodes'),
		"base" => "sns_banner",
		"show_settings_on_create" => true ,
		"is_container" => false ,
		"icon" => "vc_icon_snstheme",
		"class" => "vc_icon_snstheme",
		"content_element" => true ,
		"category" => esc_html__('MAnh', 'manh-shortcodes'),
		'description' => esc_html__( 'Banner with image and heading, sub heading, ...', 'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "dropdown",
				'value' => array(
					esc_html__( 'Content text in left center', 'manh-shortcodes' ) => '1',
					esc_html__( 'Content text in left bottom', 'manh-shortcodes' ) => '2',
					// esc_html__( 'Product - Info text in bottom', 'manh-shortcodes' ) => '3',
				),
				"heading" => esc_html__("Banner style", 'manh-shortcodes'),
				"param_name" => "style"
		    ),
		    array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Banner image", "manh-shortcodes"),
		      "param_name" => "image" 
		    ),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Sub heading", 'manh-shortcodes'),
				"param_name" => "sub_heading" ,
				"value" => esc_html__("Sub heading",'manh-shortcodes'),
				"dependency" => array(
					'element' => 'style',
					'value' => array('1')
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Heading/Title", 'manh-shortcodes'),
				"param_name" => "heading" ,
				"value" => esc_html__("Heading",'manh-shortcodes'),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'View link', 'manh-shortcodes' ),
				'param_name' => 'view_link',
				"dependency" => array(
					'element' => 'style',
					'value' => array('1', '2')
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Price", 'manh-shortcodes'),
				"param_name" => "price",
				"value" => esc_html__("$15.00",'manh-shortcodes'),
				"dependency" => array(
					'element' => 'style',
					'value' => '3',
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Wana show original price(discount)?", 'manh-shortcodes'),
				"param_name" => "o_price",
				"value" => esc_html__("$17.00",'manh-shortcodes'),
				"dependency" => array(
					'element' => 'style',
					'value' => '3',
				),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'View button', 'manh-shortcodes' ),
				'param_name' => 'view_btn',
				"dependency" => array(
					'element' => 'style',
					'value' => '3',
				),
			),
			
			$extra_class,
			vc_map_add_css_animation(),
		)
	));
}