<?php
// SNS Product/Post Tags
add_shortcode('sns_tags', 'manh_tags_template');
add_action('vc_after_init', 'manh_tags_settings');
function manh_tags_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_tags'))
        include $template;
    return ob_get_clean();
}
function manh_tags_settings() {
	$extra_class = manh_extra_class();
	$tags_woo = manh_woo_tags_array();
	vc_map( array(
		"name" => esc_html__("SNS Tags",'manh-shortcodes'),
		"base" => "sns_tags",
		"icon" => "sns_icon_tags",
		"class" => "sns_tags",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Display tags of Products/Post",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  "",
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Tags Display",'manh-shortcodes'),
				"param_name" => "tags_display",
				"value" => array(
					esc_html__('For select', 'manh-shortcodes') => "select",
					esc_html__('Query for limit', 'manh-shortcodes') => "query",
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Tag Taxonomy",'manh-shortcodes'),
				"param_name" => "tag_taxonomy",
				"value" => array(
					esc_html__('Post', 'manh-shortcodes') => "post_tag",
					esc_html__('Product', 'manh-shortcodes') => "product_tag",
				),
				'dependency' => array(
					'element' => 'tags_display',
					'value' => 'query',
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Tag number limit",'manh-shortcodes'),
				"param_name" => "number_limit",
				"value" => "10",
				"description" => esc_html__( "The number to query tags for display",'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'tags_display',
					'value' => 'query',
				),
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"heading" => esc_html__("Tag List",'manh-shortcodes'),
				"param_name" => "tag_list",
				"value" => $tags_woo,
				'dependency' => array(
					'element' => 'tags_display',
					'value' => 'select',
				),
			),
			
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}