<?php
// SNS Product
add_shortcode('sns_single_deal', 'manh_sns_single_deal_template');
add_action('vc_after_init', 'manh_single_deal_settings');
function manh_sns_single_deal_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_single_deal'))
        include $template;
    return ob_get_clean();
}
function manh_single_deal_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	// Autocomplete product
    if ( class_exists('Vc_Vendor_Woocommerce') ){
        $manh_vcwoo = 'Vc_Vendor_Woocommerce';
        add_filter( 'vc_autocomplete_sns_single_deal_ids_callback', array(&$manh_vcwoo, 'productIdAutocompleteSuggester',), 10, 1 ); // Get suggestion(find). Must return an array
        add_filter( 'vc_autocomplete_sns_single_deal_ids_render', array(&$manh_vcwoo, 'productIdAutocompleteRender',), 10, 1 ); // Render exact product. Must return an array (label,value)
    }
	vc_map( array(
		"name" => esc_html__("SNS Single Deal",'manh-shortcodes'),
		"base" => "sns_single_deal",
		"icon" => "sns_icon_sns_single_deal",
		"class" => "sns_single_deal",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Show info about single deal product",'manh-shortcodes' ),
		"params" => array(
			array(
				'type' => 'autocomplete',
				'heading' => __( 'Select a product', 'manh-shortcodes' ),
				'param_name' => 'ids',
				'settings' => array(
					'multiple' => false,
					'sortable' => true,
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend
				),
				'save_always' => true,
				'description' => __( 'You can typing id or product name to input form. And should select products is On sale and have "Sale price dates to"', 'manh-shortcodes' ),
			),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("The date", 'manh-shortcodes'),
				"param_name" => "thedate" ,
				"value" => '2021/06/25 11:45:30',
				'description' => esc_html__( 'The format date is Y/m/d H:i:s. EX: 2021/06/25 11:45:30. This option just for your product dont have "Sale price dates to"', 'manh-shortcodes' ),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}