<?php
// SNS Product
add_shortcode('sns_shopby_categories', 'manh_shopby_categories_template');
add_action('vc_after_init', 'manh_shopby_categories_settings');
function manh_shopby_categories_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_shopby_categories'))
        include $template;
    return ob_get_clean();
}
function manh_shopby_categories_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS Shop by Categories",'manh-shortcodes'),
		"base" => "sns_shopby_categories",
		"icon" => "sns_icon_products",
		"class" => "sns_shopby_categories",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Display categories shop",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("Your Main Category Name", 'manh-shortcodes'),
			),
			array(
		      "type" => "attach_image",
		      "heading" => esc_html__("Image for this box - main category", 'manh-shortcodes'),
		      "param_name" => "cat_image",
		    ),
			array(
				"type" => "checkbox",
				"class" => "",
				"value" => $woocat_value,
				"heading" => esc_html__("Select Category List",'manh-shortcodes'),
				"param_name" => "lit_cat",
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Want to use link View All?', 'manh-shortcodes' ),
				'param_name' => 'link',
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}