<?php
// SNS Product
add_shortcode('sns_products', 'manh_products_template');
add_action('vc_after_init', 'manh_products_settings');
function manh_products_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_products'))
        include $template;
    return ob_get_clean();
}
function manh_products_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS Products",'manh-shortcodes'),
		"base" => "sns_products",
		"icon" => "sns_icon_products",
		"class" => "sns_products",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "WooCommerce products",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("New Products", 'manh-shortcodes'),
			),
			array(
				"type" => "checkbox",
				"class" => "",
				"value" => $woocat_value,
				"heading" => esc_html__("Select Category",'manh-shortcodes'),
				"param_name" => "lit_cat",
				"description" => esc_html__("If you don't select any category, It mean is selected all category", 'manh-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Order By",'manh-shortcodes'),
				"admin_label" => true,
				"param_name" => "orderby",
				"value" => array(
					esc_html__('Latest products', 'manh-shortcodes') => "recent",
					esc_html__('Best seller products', 'manh-shortcodes') => "best_selling",
					esc_html__('Top rated products', 'manh-shortcodes') => "top_rate",
					esc_html__('On sale products', 'manh-shortcodes') => "on_sale",
					esc_html__('Hot deal', 'manh-shortcodes') => "hot_deal",
					esc_html__('Featured products', 'manh-shortcodes') => "featured_product",
					esc_html__('Recent review', 'manh-shortcodes') => "recent_review",
				),
				"description" => ""
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Mode View",'manh-shortcodes'),
				"param_name" => "modeview",
				"admin_label" => true,
				"value" => array(
					esc_html__("Gird",'manh-shortcodes') => '1',
					esc_html__("List",'manh-shortcodes') => '2',
					esc_html__("List no carousel",'manh-shortcodes') => '3',
				),
				"description" => esc_html__("Mode View", 'manh-shortcodes')
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Grid style",'manh-shortcodes'),
				"param_name" => "gridstyle",
				"admin_label" => true,
				"value" => array(
					esc_html__("Style 1",'manh-shortcodes') => '',
					esc_html__("Style 2",'manh-shortcodes') => '2',
					esc_html__("Style 3",'manh-shortcodes') => '3',
					esc_html__("Style 4",'manh-shortcodes') => '4',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Thumbnail type",'manh-shortcodes'),
				"param_name" => "thumb_type",
				"value" => array(
					esc_html__("Shop Thumbnail",'manh-shortcodes') => '',
					// esc_html__("MAnh 90x68 Thumbnail",'manh-shortcodes') => '9068',
					// esc_html__("MAnh 90x123 Thumbnail",'manh-shortcodes') => '90123',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('2', '3'),
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Want to choose thumbnail",'manh-shortcodes'),
				"param_name" => "thumbnail",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '',
					esc_html__("shop_catalog",'manh-shortcodes') => 'shop_catalog',
					esc_html__("shop_single",'manh-shortcodes') => 'shop_single',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Navigation",'manh-shortcodes'),
				"param_name" => "use_nav",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') => '2',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Navigation position",'manh-shortcodes'),
				"param_name" => "nav_pos",
				"value" => array(
					esc_html__("In middle box - Default",'manh-shortcodes') => 'middlebox',
					esc_html__("In top right",'manh-shortcodes') => 'topright',
					esc_html__("In top center",'manh-shortcodes') => 'topcenter',
					
				),
				'dependency' => array(
					'element' => 'use_nav',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Paging",'manh-shortcodes'),
				"param_name" => "use_paging",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '2',
					esc_html__("Yes",'manh-shortcodes') => '1',
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Auto play",'manh-shortcodes'),
				"param_name" => "autoplay",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') =>  '0'
				),
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Want to use Link view all?', 'manh-shortcodes' ),
				'param_name' => 'vlink',
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Product number limit",'manh-shortcodes'),
				"param_name" => "number_limit",
				"value" => "10",
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'manh-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_desktop",
				"value" => "5",
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Laptop",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_laptop",
				"value" => "5",
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_tablet",
				"value" => "4",
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_tabletp",
				"value" => "4",
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_mobilel",
				"value" => "2",
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_mobilep",
				"value" => "1",
				'dependency' => array(
					'element' => 'modeview',
					'value' => array('1', '2'),
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}