<?php
// SNS Hot Deals
add_shortcode('sns_hot_deals', 'manh_hot_deals_template');
add_action('vc_after_init', 'manh_hot_deals_settings');
function manh_hot_deals_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_hot_deals'))
        include $template;
    return ob_get_clean();
}
function manh_hot_deals_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	// Autocomplete product
    if ( class_exists('Vc_Vendor_Woocommerce') ){
        $manh_vcwoo = 'Vc_Vendor_Woocommerce';
        add_filter( 'vc_autocomplete_sns_hot_deals_ids_callback', array(&$manh_vcwoo, 'productIdAutocompleteSuggester',), 10, 1 ); // Get suggestion(find). Must return an array
        add_filter( 'vc_autocomplete_sns_hot_deals_ids_render', array(&$manh_vcwoo, 'productIdAutocompleteRender',), 10, 1 ); // Render exact product. Must return an array (label,value)
    }
	vc_map( array(
		"name" => esc_html__("SNS Hot Deals",'manh-shortcodes'),
		"base" => "sns_hot_deals",
		"icon" => "sns_icon_hot_deals",
		"class" => "sns_hot_deals",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Show hot deals",'manh-shortcodes' ),
		"params" => array(
			array(
				'type' => 'autocomplete',
				'heading' => __( 'Select product deals', 'manh-shortcodes' ),
				'param_name' => 'ids',
				'settings' => array(
					'multiple' => true,
					'sortable' => true,
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend
				),
				'save_always' => true,
				'description' => __( 'You can typing id or product name to input form. And should select products are On sale and have "Sale price dates to"', 'manh-shortcodes' ),
			),
			// array(
			// 	"type" => "textfield",
			// 	"heading" => esc_html__("Date", 'manh-shortcodes'),
			// 	"param_name" => "thedate" ,
			// 	"value" => '2022/04/25 11:45:30',
			// 	'description' => esc_html__( 'The format date is Y/m/d H:i:s. EX: 2022/04/25 11:45:30', 'manh-shortcodes' ),
			// ),
			// array(
			// 	"type" => "dropdown",
			// 	"class" => "",
			// 	"heading" => esc_html__("Style",'manh-shortcodes'),
			// 	"param_name" => "style",
			// 	"value" => array(
			// 		esc_html__("Style1",'manh-shortcodes') => 'style1',
			// 		//esc_html__("Style2",'manh-shortcodes') => 'style2',
			// 	),
			// ),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Desktop",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_desktop",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Laptop",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_laptop",
				"value" => "4"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Landscape",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_tablet",
				"value" => "3"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Tablet Portrait",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_tabletp",
				"value" => "3"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display Mobile Landscape",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_mobilel",
				"value" => "2"
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Column display screen Mobile Portrait",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_mobilep",
				"value" => "2"
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}