<?php
// SNS Product
add_shortcode('sns_comingsoon_product', 'manh_comingsoon_product_template');
add_action('vc_after_init', 'manh_comingsoon_product_settings');
function manh_comingsoon_product_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_comingsoon_product'))
        include $template;
    return ob_get_clean();
}
function manh_comingsoon_product_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	// Autocomplete product
    if ( class_exists('Vc_Vendor_Woocommerce') ){
        $manh_vcwoo = 'Vc_Vendor_Woocommerce';
        add_filter( 'vc_autocomplete_sns_comingsoon_product_ids_callback', array(&$manh_vcwoo, 'productIdAutocompleteSuggester',), 10, 1 ); // Get suggestion(find). Must return an array
        add_filter( 'vc_autocomplete_sns_comingsoon_product_ids_render', array(&$manh_vcwoo, 'productIdAutocompleteRender',), 10, 1 ); // Render exact product. Must return an array (label,value)
    }
	vc_map( array(
		"name" => esc_html__("SNS Coming Soon Product",'manh-shortcodes'),
		"base" => "sns_comingsoon_product",
		"icon" => "sns_icon_comingsoon_product",
		"class" => "sns_comingsoon_product",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Show info about coming soon product",'manh-shortcodes' ),
		"params" => array(
			array(
				'type' => 'autocomplete',
				'heading' => __( 'Select coming soon product', 'manh-shortcodes' ),
				'param_name' => 'ids',
				'settings' => array(
					'multiple' => false,
					'sortable' => true,
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend
				),
				'save_always' => true,
				'description' => __( 'You can typing id or product name to input form.', 'manh-shortcodes' ),
			),
		    array(
		        "type" => "attach_image",
		        "heading" => esc_html__("Background image for box", 'manh-shortcodes'),
		        "param_name" => "bg",
		    ),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("The date", 'manh-shortcodes'),
				"param_name" => "thedate" ,
				"value" => '2022/04/25 11:45:30',
				'description' => esc_html__( 'The format date is Y/m/d H:i:s. EX: 2022/04/25 11:45:30', 'manh-shortcodes' ),
			),
		    array(
				'type' => 'textarea_html',
				"heading" => esc_html__("Description", 'manh-shortcodes'),
				"param_name" => "content"
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Want to use Post WCode to show Product Attribute", 'manh-shortcodes'),
				"param_name" => "wcode_pa",
				"value" => esc_html__("product-attributes",'manh-shortcodes'),
				'description' => esc_html__( 'Enter alias of your Post WCode', 'manh-shortcodes' ),
				"admin_label" => true 
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Pre text for Read More button", 'manh-shortcodes'),
				"param_name" => "pretext_readmore",
				"value" => esc_html__("Pre-order for 20%",'manh-shortcodes'),
				"admin_label" => true 
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}