<?php
// SNS Cat Info
if ( class_exists( 'WPBakeryShortCodesContainer' ) ) {
	class WPBakeryShortCode_SNS_Cat_Info extends WPBakeryShortCode {
		function __construct( $settings ) {
			parent::__construct( $settings );
		}
	}
}
add_shortcode('sns_cat_info', 'manh_cat_info_template');
add_action('vc_after_init', 'manh_cat_info_settings');
function manh_cat_info_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_cat_info'))
        include $template;
    return ob_get_clean();
}
function manh_cat_info_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS Cat Info",'manh-shortcodes'),
		"base" => "sns_cat_info",
		"icon" => "sns_icon_cat_info",
		"class" => "sns_cat_info",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "WooCommerce category info",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Category info you want to display",'manh-shortcodes'),
				"admin_label" => true,
				"param_name" => "info_want",
				"value" => array(
					esc_html__('Show number product', 'manh-shortcodes') => "1",
					esc_html__('Just show category name on bottom', 'manh-shortcodes') => "2",
					esc_html__('Show title category when hover', 'manh-shortcodes') => "3",
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Resource type",'manh-shortcodes'),
				//"admin_label" => true,
				"param_name" => "r_type",
				"value" => array(
					esc_html__('From Product Category', 'manh-shortcodes') => "1",
					esc_html__('From custom input', 'manh-shortcodes') => "2",
				),
			),
			array(
				"type" => "dropdown",
				'multiple' => false,
				"heading" => esc_html__("Select category",'manh-shortcodes'),
				//"admin_label" => true,
				"class" => "",
				"value" => $woocat_value,
				"param_name" => "cat",
				'dependency' => array(
					'element' => 'r_type',
					'value' => array('1'),
				),
			),
			array(
		      	"type" => "textfield",
				"heading" => esc_html__("Want to use Custom Name for category?", "manh-shortcodes"),
				"param_name" => "ctitle",
				//"admin_label" => true,
				'dependency' => array(
					'element' => 'r_type',
					'value' => array('1'),
				),
		    ),
		    array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Link for Category', 'manh-shortcodes' ),
				'param_name' => 'clink',
				//"admin_label" => true,
				'dependency' => array(
					'element' => 'r_type',
					'value' => array('2'),
				),
			),
			array(
				"type" => "attach_image",
				"heading" => esc_html__("Image for Category", 'manh-shortcodes'),
				"param_name" => "cat_image",
		    ),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}