<?php
// SNS Cat Info
add_shortcode('sns_banner_product', 'manh_banner_product_template');
add_action('vc_after_init', 'manh_banner_product_settings');
function manh_banner_product_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_banner_product'))
        include $template;
    return ob_get_clean();
}
function manh_banner_product_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	if ( class_exists('Vc_Vendor_Woocommerce') ){
        $manh_vcwoo = 'Vc_Vendor_Woocommerce';
        add_filter( 'vc_autocomplete_sns_banner_product_id_callback', array(&$manh_vcwoo, 'productIdAutocompleteSuggester',), 10, 1 ); // Get suggestion(find). Must return an array
        add_filter( 'vc_autocomplete_sns_banner_product_id_render', array(&$manh_vcwoo, 'productIdAutocompleteRender',), 10, 1 ); // Render exact product. Must return an array (label,value)
    }
	vc_map( array(
		"name" => esc_html__("SNS Banner Product",'manh-shortcodes'),
		"base" => "sns_banner_product",
		"icon" => "sns_icon_banner_product",
		"class" => "sns_banner_product",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "WooCommerce banner for a product",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "attach_image",
				"heading" => esc_html__("Banner for Product", 'manh-shortcodes'),
				"param_name" => "prd_image",
		    ),
			array(
				"type" => "dropdown",
				'multiple' => false,
				"heading" => esc_html__("Want to show category of product?",'manh-shortcodes'),
				"admin_label" => true,
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') => '2',
				),
				"param_name" => "show_cat",
			),
			array(
				"type" => "dropdown",
				'multiple' => false,
				"heading" => esc_html__("Select category",'manh-shortcodes'),
				"admin_label" => true,
				"class" => "",
				"value" => $woocat_value,
				"param_name" => "cat",
				'dependency' => array(
					'element' => 'show_cat',
					'value' => array('1'),
				),
			),
			array(
				'type' => 'autocomplete',
				'heading' => __( 'Select products', 'manh-shortcodes' ),
				'param_name' => 'id',
				'settings' => array(
					'multiple' => false,
					'sortable' => true,
					'unique_values' => true,
					// In UI show results except selected. NB! You should manually check values in backend
				),
				'save_always' => true,
				'description' => __( 'You can typing id or product name to input form. And should select products are On sale and Manage stock', 'manh-shortcodes' ),
			),
			array(
				"type" => "dropdown",
				'multiple' => false,
				"heading" => esc_html__("Want to show price of product?",'manh-shortcodes'),
				"admin_label" => true,
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '1',
					esc_html__("Yes - Show default price",'manh-shortcodes') => '2',
					esc_html__("Yes - Show custom price",'manh-shortcodes') => '3',
				),
				"param_name" => "show_price",
			),
		    array(
				"type" => "textfield",
				"heading" => esc_html__("Want use price label?", 'manh-shortcodes'),
				"param_name" => "price_label",
				"value" => "",
				'description' => __( 'Example: From/Just...', 'manh-shortcodes' ),
				'dependency' => array(
					'element' => 'show_price',
					'value' => array('3'),
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Price of product", 'manh-shortcodes'),
				"param_name" => "price",
				"value" => "",
				'dependency' => array(
					'element' => 'show_price',
					'value' => array('3'),
				),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}