<?php
// SNS Product
add_shortcode('sns_360_degree_product', 'manh_360_degree_product_template');
add_action('vc_after_init', 'manh_360_degree_product_settings');
function manh_360_degree_product_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('sns_360_degree_product'))
        include $template;
    return ob_get_clean();
}
function manh_360_degree_product_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();
	vc_map( array(
		"name" => esc_html__("SNS 360 Degree Product",'manh-shortcodes'),
		"base" => "sns_360_degree_product",
		"icon" => "sns_icon_products",
		"class" => "sns_360_degree_product",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "WooCommerce products",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Product title",'manh-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("Product title", 'manh-shortcodes'),
			),
			array(
				'type' => 'textarea_html',
				'holder' => 'div',
				'heading' => __( 'Text', 'manh-shortcodes' ),
				'param_name' => 'content',
				'value' => __( '<p>The description of product here.</p>', 'manh-shortcodes' ),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Link for product', 'manh-shortcodes' ),
				'param_name' => 'plink',
				"admin_label" => true,
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Total frame",'manh-shortcodes'),
				"param_name" => "total_frame",
				"value" => "32",
				"group" => __( '360 Degree Settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Image Path",'manh-shortcodes'),
				"param_name" => "image_path",
				"value" => "",
				"group" => __( '360 Degree Settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("File prefix",'manh-shortcodes'),
				"param_name" => "file_prefix",
				"value" => "",
				"group" => __( '360 Degree Settings', 'manh-shortcodes' ),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("File extension",'manh-shortcodes'),
				"param_name" => "file_ext",
				"value" => ".jpg",
				"group" => __( '360 Degree Settings', 'manh-shortcodes' ),
			),

			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Show navigation",'manh-shortcodes'),
				"param_name" => "navigation",
				"admin_label" => true,
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') => '2',
				),
				"group" => __( '360 Degree Settings', 'manh-shortcodes' ),
			),
			
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}