<?php
// MANH Product Ajax Tab
add_shortcode('manh_products_ajaxtab', 'manh_products_ajaxtab_template');
add_action('vc_after_init', 'manh_products_ajaxtab_settings');
function manh_products_ajaxtab_template($atts, $content = null) {
    ob_start();
    if ($template = manh_shortcode_woo_template('manh_products_ajaxtab'))
        include $template;
    return ob_get_clean();
}
function manh_products_ajaxtab_settings() {
	$extra_class = manh_extra_class();
	$woocat_value = manh_woo_cat();

	vc_map( array(
		"name" => esc_html__("Products Ajax Tab",'manh-shortcodes'),
		"base" => "manh_products_ajaxtab",
		"icon" => "icon_manh_products_ajaxtab",
		"class" => "manh_products_ajaxtab",
		"category" => esc_html__("MAnh",'manh-shortcodes'),
		"description" => esc_html__( "Products Ajax Tab",'manh-shortcodes' ),
		"params" => array(
			array(
				"type" => "textfield",
				"heading" => esc_html__("Title",'manh-shortcodes'),
				"param_name" => "title",
				"admin_label" => true,
				"value" =>  esc_html__("The title", 'manh-shortcodes'),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Tab by?",'manh-shortcodes'),
				"param_name" => "tab_type",
				"admin_label" => true,
				"value" => array(
					esc_html__("Order by",'manh-shortcodes') => '1',
					esc_html__("Category",'manh-shortcodes') => '2',
				),
			),
			array(
				"type" => "checkbox",
				"heading" => esc_html__("Select tab to display",'manh-shortcodes'),
				"param_name" => "orderby_tab",
				"value" => array(
					esc_html__('Latest', 'manh-shortcodes') => "recent",
					esc_html__('Best Seller', 'manh-shortcodes') => "best_selling",
					esc_html__('Top Rated', 'manh-shortcodes') => "top_rate",
					esc_html__('Special', 'manh-shortcodes') => "on_sale",
					esc_html__('Featured', 'manh-shortcodes') => "featured_product",
					esc_html__('Recent Review', 'manh-shortcodes') => "recent_review",
				),
				"description" => "",
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '1',
				),
			),
			array(
				"type" => "checkbox",
				"heading" => esc_html__("Select tab to display",'manh-shortcodes'),
				"param_name" => "cat_tab",
				"value" => $woocat_value,
				"description" => "",
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '2',
				),
			),
			array(
				"type" => "dropdown",
				'multiple' => false,
				"heading" => esc_html__("Want to show total product in category?",'manh-shortcodes'),
				"admin_label" => true,
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') => '2',
				),
				"param_name" => "show_cat_number",
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Want to show tab All Category?",'manh-shortcodes'),
				"param_name" => "show_tab_all",
				"value" => array(
					esc_html__('Yes', 'manh-shortcodes') => "1",
					esc_html__('No', 'manh-shortcodes') => "2",
				),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '2',
				),
			),
			array(
				"type" => "checkbox",
				"value" => $woocat_value,
				"heading" => esc_html__("Choice categories",'manh-shortcodes'),
				"param_name" => "cat",
				"description" => esc_html__('If you dont choice, That mean it will query all category','manh-shortcodes'),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '1',
				),
			),
			array(
				"type" => "dropdown",
				"heading" => esc_html__("Order by",'snsmarket-shortcodes'),
				"param_name" => "orderby",
				"value" => array(
					esc_html__('Latest', 'manh-shortcodes') => "recent",
					esc_html__('Best Seller', 'manh-shortcodes') => "best_selling",
					esc_html__('Top Rated', 'manh-shortcodes') => "top_rate",
					esc_html__('Special', 'manh-shortcodes') => "on_sale",
					esc_html__('Featured', 'manh-shortcodes') => "featured_product",
					esc_html__('Recent Review', 'manh-shortcodes') => "recent_review",
				),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '2',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use short title for tab?",'manh-shortcodes'),
				"param_name" => "short_title",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '2',
					esc_html__("Yes",'manh-shortcodes') => '1',
				),
				'dependency' => array(
					'element' => 'tab_type',
					'value' => '1',
				),
			),
			// array(
			// 	"type" => "dropdown",
			// 	"class" => "",
			// 	"heading" => esc_html__("Box style",'manh-shortcodes'),
			// 	"param_name" => "box_style",
			// 	"admin_label" => true,
			// 	"value" => array(
			// 		esc_html__("Style 1",'manh-shortcodes') => '1',
			// 		esc_html__("Style 2",'manh-shortcodes') => '2',
			// 	),
			// ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Product style",'manh-shortcodes'),
				"param_name" => "gridstyle",
				"admin_label" => true,
				"value" => array(
					esc_html__("Style 1",'manh-shortcodes') => '',
					esc_html__("Style 2",'manh-shortcodes') => '2',
					esc_html__("Style 3",'manh-shortcodes') => '3',
					esc_html__("Style 4",'manh-shortcodes') => '4',
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Want to choose thumbnail",'manh-shortcodes'),
				"param_name" => "thumbnail",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '',
					esc_html__("shop_catalog",'manh-shortcodes') => 'shop_catalog',
					esc_html__("shop_single",'manh-shortcodes') => 'shop_single',
				),
			),
			array(
				"type" => "dropdown",
				'multiple' => true,
				"class" => "",
				"value" => array(
					esc_html__('No Effect', 'manh-shortcodes') => "simple-effect",
					esc_html__('fadeIn', 'manh-shortcodes') => "fadeIn",
					esc_html__('fadeInUp', 'manh-shortcodes') => "fadeInUp",
					esc_html__('fadeInDown', 'manh-shortcodes') => "fadeInDown",
					esc_html__('fadeInRight', 'manh-shortcodes') => "fadeInRight",
					esc_html__('fadeInLeft', 'manh-shortcodes') => "fadeInLeft",
					esc_html__('bounceIn', 'manh-shortcodes') => "bounceIn",
					esc_html__('bounceInUp', 'manh-shortcodes') => "bounceInUp",
					esc_html__('bounceInDown', 'manh-shortcodes') => "bounceInDown",
					esc_html__('bounceInLeft', 'manh-shortcodes') => "bounceInLeft",
					esc_html__('bounceInRight', 'manh-shortcodes') => "bounceInRight",
					esc_html__('zoomIn', 'manh-shortcodes') => "zoomIn",
					esc_html__('zoomInUp', 'manh-shortcodes') => "zoomInUp",
					esc_html__('zoomInDown', 'manh-shortcodes') => "zoomInDown",
					esc_html__('zoomInLeft', 'manh-shortcodes') => "zoomInLeft",
					esc_html__('zoomInRight', 'manh-shortcodes') => "zoomInRight",

				),
				"heading" => esc_html__("Effect to show product in tab",'manh-shortcodes'),
				"param_name" => "effect",
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Template for each tab content",'manh-shortcodes'),
				"param_name" => "content_tab_template",
				"admin_label" => true,
				"value" => array(
					esc_html__("Carousel",'manh-shortcodes') => '1',
					esc_html__("Grid and Load more button",'manh-shortcodes') => '2',
					esc_html__("Grid and browser all products link") => '3',
				),
			),
			array(
				'type' => 'vc_link',
				'heading' => esc_html__( 'Want to use Browse all products link?', 'manh-shortcodes' ),
				'param_name' => 'vlink',
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1', '3'),
				),
				"admin_label" => true,
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Want to show Load more button?",'manh-shortcodes'),
				"param_name" => "want_loadmore",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') => '2',
				),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('2'),
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Navigation",'manh-shortcodes'),
				"param_name" => "use_nav",
				"value" => array(
					esc_html__("Yes",'manh-shortcodes') => '1',
					esc_html__("No",'manh-shortcodes') => '2',
				),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1'),
				),
			),
			// array(
			// 	"type" => "dropdown",
			// 	"class" => "",
			// 	"heading" => esc_html__("Navigation position",'manh-shortcodes'),
			// 	"param_name" => "nav_pos",
			// 	"value" => array(
			// 		esc_html__("In middle box - Default",'manh-shortcodes') => 'middlebox',
			// 		esc_html__("In top right",'manh-shortcodes') => 'topright',
			// 		esc_html__("In top center",'manh-shortcodes') => 'topcenter',
					
			// 	),
			// 	'dependency' => array(
			// 		'element' => 'use_nav',
			// 		'value' => '1',
			// 	),
			// ),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use Paging",'manh-shortcodes'),
				"param_name" => "use_paging",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '2',
					esc_html__("Yes",'manh-shortcodes') => '1',
				),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1'),
				),
			),
			array(
				"type" => "dropdown",
				"class" => "",
				"heading" => esc_html__("Use autoplay",'manh-shortcodes'),
				"param_name" => "autoplay",
				"value" => array(
					esc_html__("No",'manh-shortcodes') => '2',
					esc_html__("Yes",'manh-shortcodes') => '1',
				),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1'),
				),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product limit for each tab",'manh-shortcodes'),
				"param_name" => "number_limit",
				"admin_label" => true,
				"value" =>  esc_html__("16", 'manh-shortcodes'),
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => array('1'),
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number product will show more with each click load more button",'manh-shortcodes'),
				"param_name" => "num_showmore",
				"value" => "6",
				'dependency' => array(
					'element' => 'content_tab_template',
					'value' => '2',
				),
			),
			array(
				"type" => "textfield",
				"class" => "",
				"heading" => esc_html__("Number Row per Column",'manh-shortcodes'),
				"param_name" => "number_row",
				"value" => "1"
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Desktop",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_desktop",
				"admin_label" => true,
				"value" =>  esc_html__("5", 'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Tablet Landscape",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_tablet",
				"admin_label" => true,
				"value" =>  esc_html__("3", 'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Tablet Portrait",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_tabletp",
				"admin_label" => true,
				"value" =>  esc_html__("2", 'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Mobile Landscape",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_mobilel",
				"admin_label" => true,
				"value" =>  esc_html__("2", 'manh-shortcodes'),
			),
			array(
				"type" => "textfield",
				"heading" => esc_html__("Number product per column to display on Nobile Portrait",'manh-shortcodes'),
				"group" => __( 'Column settings', 'manh-shortcodes' ),
				"param_name" => "number_mobilep",
				"admin_label" => true,
				"value" =>  esc_html__("1", 'manh-shortcodes'),
			),
			vc_map_add_css_animation(),
			$extra_class,
		)
	) );
}