<?php 
function manh_shortcode_template( $name = false ) {
    if (!$name)
        return false;
    if ( $overridden_template = locate_template( 'vc_templates/' . $name . '.php' ) ) {
        return $overridden_template;
    } else {
        return MANH_SHORTCODES_PATH . '/shortcodes/templates/' . $name . '.php';
    }
}
function manh_shortcode_woo_template( $name = false ) {
    if (!$name)
        return false;
    if ( $overridden_template = locate_template( 'vc_templates/' . $name . '.php' ) ) {
        return $overridden_template;
    } else {
        return MANH_SHORTCODES_PATH . '/shortcodes-woo/templates/' . $name . '.php';
    }
}
function manh_extra_class(){
    return array(
            "type" => "textfield",
            "heading" => esc_html__("Extra class name", 'manh-shortcodes'),
            "param_name" => "extra_class"
        );
}
function manh_getCSSAnimation( $css_animation ) {
    $output = '';
    if ( '' !== $css_animation && 'none' !== $css_animation ) {
        wp_enqueue_script( 'waypoints' );
        wp_enqueue_style( 'animate-css' );
        $output = ' wpb_animate_when_almost_visible wpb_' . $css_animation . ' ' . $css_animation;
    }

    return $output;
}
function manh_css_animation(){
    return array(
        'type' => 'dropdown',
        'heading' => esc_html__( 'CSS Animation', 'manh-shortcodes' ),
        'param_name' => 'css_animation',
        'admin_label' => true,
        'value' => array(
            esc_html__( 'No', 'manh-shortcodes' ) => '',
            esc_html__( 'Top to bottom', 'manh-shortcodes' ) => 'top-to-bottom',
            esc_html__( 'Bottom to top', 'manh-shortcodes' ) => 'bottom-to-top',
            esc_html__( 'Left to right', 'manh-shortcodes' ) => 'left-to-right',
            esc_html__( 'Right to left', 'manh-shortcodes' ) => 'right-to-left',
            esc_html__( 'Appear from center', 'manh-shortcodes' ) => 'appear'
        ),
        'description' => esc_html__( 'Select type of animation for element to be animated when it "enters" the browsers viewport (Note: works only in modern browsers).', 'manh-shortcodes' )
    );
}
function manh_woo_cat_level( $parent_id, $pos, $array, $level, &$dropdown ) {
    for ( $i = $pos; $i < count( $array ); $i ++ ) {
        if ( $array[ $i ]->category_parent == $parent_id ) {
            $name = str_repeat( '- ', $level ) . $array[ $i ]->name;
            $value = $array[ $i ]->slug;
            $dropdown[] = array(
                'label' => $name,
                'value' => $value,
            );
            manh_woo_cat_level( $array[ $i ]->term_id, $i, $array, $level + 1, $dropdown );
        }
    }
}
function manh_woo_cat($bool =1) {
    $args = array(
            'type' => 'post',
            'child_of' => 0,
            'parent' => '',
            //'orderby' => 'parent_id',
            'order' => 'ASC',
            'hide_empty' => false,
            'hierarchical' => 1,
            'exclude' => '',
            'include' => '',
            'number' => '',
            'taxonomy' => 'product_cat',
            'pad_counts' => false,

        );
    $categories = get_categories( $args );
    if ($bool==0) return $categories;
    $dropdown = array(); $woocat_value = array(); 
    manh_sort_level_catid(0, $categories, 0 , $dropdown);
    foreach ($dropdown as $cat) {
        $woocat_value[$cat['label']] = $cat['value'];
    }
    return $woocat_value;
}
function manh_sort_level_catid( $parent_id, $array, $level, &$dropdown){
    $keys = array_keys( $array );
    $i = 0;
    while ( $i < count( $array ) ) {
        $key = $keys[ $i ];
        $item = $array[ $key ];
        $i ++;
        if ( $item->category_parent == $parent_id ) {
            $name = str_repeat( '- ', $level ) . $item->name;
            $value = $item->slug;
            $dropdown[] = array(
                'label' => $name . '(id:' . $item->term_id . ')',
                'value' => $value,
            );
            //$dropdown[$name] = $value;
            unset( $array[ $key ] );
            $array = manh_sort_level_catid( $item->term_id, $array, $level + 1, $dropdown );
            $keys = array_keys( $array );
            $i = 0;
        }
    }

    return $array;
}
function manh_cat(){
    global $wpdb;
    $sql = $wpdb->prepare( "
        SELECT a.name,a.slug,a.term_id 
        FROM {$wpdb->terms} a JOIN  {$wpdb->term_taxonomy} b ON (a.term_id= b.term_id ) 
        WHERE b.count> %d and b.taxonomy = %s",
        0,'category' );
    $results = $wpdb->get_results($sql);
    $cat_value = array();
    foreach ($results as $cat) {
        $cat_value[$cat->name] = $cat->slug;
    }
    return $cat_value;
}
function manh_woo_tags_array(){
    $args = array(
        'taxonomy' => 'product_tag',
        'number' => 10000,
        'format' => 'array',
    );
    $tags = get_terms( $args['taxonomy'], $args ); // Always query top tags
    $tags_arr = array();
    foreach ($tags as $key => $value) {
        $tags_arr[$value->name]  = $value->term_id;
    }
    return $tags_arr;
}
function manh_ajaxtab_order_title($tab){
    switch ($tab) {
        case 'recent':
            return array('name'=>$tab,'title'=>esc_html__('New products','manh-shortcodes'),'short_title'=>esc_html__('New arrival', 'manh-shortcodes'));
        case 'featured_product':
            return array('name'=>$tab,'title'=>esc_html__('Featured Products','manh-shortcodes'),'short_title'=>esc_html__('Featured','manh-shortcodes'));
        case 'top_rate':
            return array('name'=>$tab,'title'=> esc_html__('Top Rated','manh-shortcodes'),'short_title'=>esc_html__('Top Rated', 'manh-shortcodes'));
        case 'best_selling':
            return array('name'=>$tab,'title'=>esc_html__('Best Seller','manh-shortcodes'),'short_title'=>esc_html__('Best Seller','manh-shortcodes'));
        case 'on_sale':
            return array('name'=>$tab,'title'=>esc_html__('Sale Off','manh-shortcodes'),'short_title'=>esc_html__('Sale off','manh-shortcodes'));
    }
}

add_filter( 'vc_iconpicker-type-ionicons', 'vc_iconpicker_type_ionicons' );
function vc_iconpicker_type_ionicons( $icons ) {
    $icon_ion = array(); $ioniocns_icons = array();
    $content_ion = '';
    if( file_exists( get_template_directory().'/assets/fonts/ionicons/css/ionicons.css' ) ) {
        $content_ion = file_get_contents(get_template_directory().'/assets/fonts/ionicons/css/ionicons.css');
    }
    preg_match_all('/\.(ion-(?:\w+(?:-)?)+):before/', $content_ion , $matches_ion, PREG_SET_ORDER);
    foreach($matches_ion as $k => $v){
       $icon_ion[$k] = $v[1];
    }
    if( is_array($icon_ion ) && !empty($icon_ion)) {
        foreach( $icon_ion as $k => $v) { 
            $ioniocns_icons[] = array( $v => $v );
        }
    }
    return array_merge( $icons, $ioniocns_icons );
}
add_action('admin_enqueue_scripts', 'manh_admin_ioniocns_scripts');
function manh_admin_ioniocns_scripts(){
    wp_enqueue_style('font-ionicons', get_template_directory_uri() . '/assets/fonts/ionicons/css/ionicons.min.css');
}


