<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly
}
global $product;

if ( empty( $class ) ) {
	$class = '';
}
?>
<div <?php post_class($class); ?>>
	<div class="item-img">
		<a class="product-image" href="<?php the_permalink(); ?>">
<?php
	manh_product_thumbnail();
	add_action('manh_hotdeal_before_item_title', 'woocommerce_show_product_loop_sale_flash', 10);
	do_action( 'manh_hotdeal_before_item_title' );
?>
		</a>
		<?php manh_quickview_liststyle(); ?>
	</div>
	<div class="item-info">
	<?php
		add_action('manh_hotdeal_after_item_title', 'woocommerce_template_loop_product_title', 5);
		add_action('manh_hotdeal_after_item_title', 'woocommerce_template_loop_price', 15);
		add_action('manh_hotdeal_after_item_title', 'woocommerce_template_loop_rating', 20);
		do_action( 'manh_hotdeal_after_item_title' );

		$thedate = 0;
		if ( $product->is_on_sale() ) {
			$thedate = get_post_meta($product->get_id(), '_sale_price_dates_to', true);
			if( $thedate ) $thedate = date_i18n("Y/m/d", $thedate);
		}
		$current_date = date("Y/m/d H:i:s", time() + get_option( 'gmt_offset' ) * 3600);
		if( strpos(site_url(), 'demo.snstheme.com') || strpos(site_url(), 'dev.snsgroup.me') ){
			if($thedate == 0 || empty($thedate) || $thedate < $current_date)
				$thedate = date('Y/m/d H:i:s', strtotime('+1 days'));
		}
	?>
		<div class="time-count-down" data-date="<?php echo esc_attr($thedate); ?>">
			<div class="clock-digi">
			    <div class="box"><div><div class="day"></div><?php esc_html_e('Days', 'manh');?></div></div>
			    <div class="box"><div><div class="hours"></div><?php esc_html_e('Hours', 'manh');?></div></div>
			    <div class="box"><div><div class="minutes"></div><?php esc_html_e('Mins', 'manh');?></div></div>
			    <div class="box"><div><div class="seconds"></div><?php esc_html_e('Secs', 'manh');?></div></div>
			</div>
		</div>
	</div>
</div>