<?php
/**
 * The Template for displaying product archives, including the main shop page which is a post type archive
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/archive-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.4.0
 */
?>
<?php get_header(); ?>
<!-- Content -->
<div id="sns_content" class="sns-woocommerce-page">
	<?php 
	if ( is_product_category() ){
		$class = ( manh_woo_cat_option('content_extrawidth', '2') == '1' ) ? ' extra-width' : ''; 
	}else{
		$class = ( manh_getoption('content_extrawidth', '2') == '1' ) ? ' extra-width' : ''; 
	}
	?>
	<div class="container<?php echo esc_attr($class); ?>">
		<div class="row sns-content">
			<?php manh_leftcol(); ?>
			<div class="<?php echo esc_attr(manh_maincolclass()); ?>">
			    <?php
					wc_get_template( 'content-archive.php' );
				?>
			</div>
			<?php manh_rightcol(); ?>
		</div>
	</div>
</div>
<!-- End Content -->
<?php get_footer(); ?>