<!-- Header -->
<div id="sns_header" class="wrap <?php echo esc_attr(manh_getoption('header_style', 'style1')); ?>">
	<div class="main-header"><div class="container">
		<?php get_template_part('tpl-head-mobile'); ?>
		<div class="header-inner visible-lg visible-md"><div class="row">
			<div class="header-left col-lg-2 col-md-6 col-xs-6 col-phone-12">
				<div class="header-logo pull-left">
					<div id="logo">
						<?php $logourl = manh_getoption('header_logo', MANH_THEME_URI.'/assets/img/logo.png', 'image'); ?>
						<a class="logo-retina" href="<?php echo esc_url( home_url('/') ) ?>" title="<?php bloginfo( 'sitename' ); ?>">
							<img src="<?php echo esc_attr($logourl); ?>" alt="<?php bloginfo( 'sitename' ); ?>"/>
						</a>
					</div>
				</div>
			</div>
			<?php
			$class_hr = '';
			if ( class_exists('WooCommerce') ) :
				$class_hr .= ' have-btn-woocommerce';
			endif;
			if ( !function_exists('YITH_WCWL') ) :
				$class_hr .= ' no-btn-wishlist';
			endif;
			?>
			<div class="header-center col-lg-8 col-md-6 col-xs-6 col-phone-12 hidden-md hidden-sm hidden-xs"><div class="inner">
				<div id="sns_mainmenu" class="visible-lg">
					<?php
		                if(has_nav_menu('main_navigation')):
				           wp_nav_menu( array(
				           				'theme_location' => 'main_navigation',
				           				'container' => false,
				           				'menu_id' => 'main_navigation',
				           				'walker' => new manh_Megamenu_Front,
				           				'menu_class' => 'nav navbar-nav'
				           	) );
						else:
							echo '<p class="main_navigation_alert">'.esc_html__('Please sellect menu for Main navigation', 'manh').'</p>';
						endif;
					?>
				</div>
			</div></div>
			<div class="header-right<?php echo esc_attr($class_hr);?> col-lg-2 col-md-6 col-xs-6 col-phone-12"><div class="inner">
				<!-- Main menu wrap -->
				<div class="menu-sidebar hidden-lg">
					<span class="tongle"></span><span class="overlay"></span>
					<div class="sidebar-content">
						<?php
						$tms_wcode = new WP_Query(array( 'name' => 'top-menu-sidebar', 'post_type' => 'post-wcode' ));
					    if ($tms_wcode->have_posts()) { ?>
					    	<div class="top-menu-sidebar">
					    	<?php echo do_shortcode('[manh_postwcode name="top-menu-sidebar"]'); ?>
					    	</div>
					    	<?php
					    } ?>
						<div class="mid-menu-sidebar">
	                    <?php
	                    if(has_nav_menu('main_navigation')):
		                   $main_menu = '';
							if(is_page() && ($menu_selected = get_post_meta(get_the_ID(), 'manh_main_menu', true))){
								$main_menu = $menu_selected;
							}
	                   		wp_nav_menu( array(
				           				'theme_location' => 'main_navigation',
				           				'container' => false,
				           				'menu'		=> $main_menu,
				           				'menu_id' => 'main_menu_sidebar',
				           				'menu_class' => 'nav-sidebar resp-nav mainmenu-sidebar-mobile'
				           	) );
	                    else:
	                        echo '<p class="main_navigation_alert">'.esc_html__('Please sellect menu for Main navigation', 'manh').'</p>';
	                    endif;
	                    ?>
	                	</div>
	                	<?php
	                	$bms_wcode = new WP_Query(array( 'name' => 'bottom-menu-sidebar', 'post_type' => 'post-wcode' ));
					    if ($bms_wcode->have_posts()) { ?>
					    	<div class="bottom-menu-sidebar">
					    	<?php echo do_shortcode('[manh_postwcode name="bottom-menu-sidebar"]'); ?>
					    	</div>
					    	<?php
					    } ?>
	                </div>
                </div>
				<div class="mini-search">
					<span class="tongle"><span class="overlay"></span></span>
				</div><?php if(has_nav_menu('user_navigation')): ?><div class="user-menu">
					<span class="tongle"></span>
					<?php
				           wp_nav_menu( array(
				           				'theme_location' => 'user_navigation',
				           				'container' => false,
				           				'depth' => 1,
				           				'menu_id' => 'user_navigation',
				           				'menu_class' => 'nav navbar-nav'
				           	) );
					?>
				</div><?php endif ?><?php if ( class_exists('WooCommerce') ) : ?><?php if ( function_exists('YITH_WCWL') ) { ?><div class="mini-wishlist hidden-sm hidden-xs">
						<a class="tongle" href="<?php echo YITH_WCWL()->get_wishlist_url(); ?>">
							<span class="number"><?php echo YITH_WCWL()->count_products(); ?></span>
						</a>
					</div><?php } ?><div class="mini-cart sns-ajaxcart">
						<a href="<?php echo wc_get_cart_url(); ?>" class="tongle">
							<span class="cart-label"><?php echo esc_html__("Cart", "manh"); ?></span>
							<span class="number"><?php echo sizeof( WC()->cart->get_cart() );?></span>
						</a>
						<?php if ( !is_cart() && !is_checkout() ) : ?>
							<div class="content">
								<div class="cart-title"><h4><?php echo esc_html__("My cart", "manh"); ?></h4></div>
								<div class="block-inner">
									<?php the_widget( 'WC_Widget_Cart', 'title= ', array('before_title' => '', 'after_title' => '') ); ?>
								</div>
							</div>
						<?php endif; ?>
					</div>
				<?php endif; ?>
			</div></div>
		</div></div>
	</div></div>
	<?php get_template_part('tpl-head-mobile-bbar'); ?>
	<div class="search-box">
		<?php
		if ( manh_getoption('enable_search_cat') == true ) manh_get_searchform('def');
		else manh_get_searchform('hide_cat');
		?>
	</div>
</div>
<?php manh_slideshow_wrap(); ?>
<?php
do_action('manh_before_sns_content');

