<?php get_header(); ?>
<!-- Content -->
<div id="sns_content">
	<div class="container">
		<div class="row sns-content">
			<?php manh_leftcol(); ?>
			<div class="<?php echo esc_attr(manh_maincolclass()); ?>">
			    <?php
			    if ( have_posts() ) :
					?>
					<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
						<h1 class="post-title">
					        <?php the_title(); ?>
					    </h1>
					    <div class="post-meta">
					        <?php
					        // Date
					        printf( '<span class="entry-date"><a href="%1$s" rel="bookmark"><time class="entry-date published" datetime="%2$s">%3$s</time></a></span>',
			                    get_permalink(),
			                    esc_attr( get_the_date() ),
			                    get_the_date()
			                );
					        ?>
					        <span class="post-author">
							<?php
							printf( wp_kses(__( '%s <a class="author-link" href="%s">%s</a>', 'manh' ), array(
							            'a' => array(
							                'href' => array(),
							                'class' => array(),
							                'ref' => array()
							            ),
							            ) ), esc_html__( 'By:','manh' ), esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author_meta('display_name') ); ?>
							</span>
					        <?php
					        // Edit link
					        edit_post_link(esc_html__('Edit','manh'), '<span class="edit-post">', '</span>'); ?>
					    </div>
					    
						<div class="entry-attachment">
							<?php
								echo wp_get_attachment_image( get_the_ID(), 'large' );
							?>
							<?php if ( has_excerpt() ) : ?>
								<div class="entry-caption">
									<?php the_excerpt(); ?>
								</div>
							<?php endif; ?>
						</div>
						<?php the_content(); ?>
						<nav id="image-navigation" class="navigation image-navigation">
							<div class="nav-links">
								<div class="nav-previous"><?php previous_image_link( false, esc_html__( 'Previous Image', 'manh' ) ); ?></div>
								<div class="nav-next"><?php next_image_link( false, esc_html__( 'Next Image', 'manh' ) ); ?></div>
							</div>
						</nav>
					    <?php
					    // Post Comment
					    if ( comments_open() || get_comments_number() ) :
					        comments_template();
					    endif;
					    ?>
					</article>
				<?php
			    else:
			        get_template_part( 'content', 'none' );
			    endif; ?>
			</div>
			<?php manh_rightcol(); ?>
		</div>
	</div>
</div>
<!-- End Content -->
<?php get_footer(); ?>