<?php
define( 'MANH_THEME_DIR', get_template_directory() );
define( 'MANH_THEME_URI', get_template_directory_uri() );
require_once( MANH_THEME_DIR.'/framework/init.php' );
/** 
 *   Initialize Visual Composer in the theme.
 **/
add_action( 'vc_before_init', 'manh_vc_setastheme' );
function manh_vc_setastheme() {
    if ( function_exists('vc_set_as_theme') ) vc_set_as_theme(true);
}
/** 
 *  Width of content, it's max width of content without sidebar.
 **/
if ( ! isset( $content_width ) ) { $content_width = 960; }

/** 
 *  Set base function for theme.
 **/
if ( ! function_exists( 'manh_setup' ) ) {
    function manh_setup() {
        global $manh_opt;
        // Load default theme textdomain.
        load_theme_textdomain( 'manh' , MANH_THEME_DIR . '/languages' );
        // Add default posts and comments RSS feed links to head.
        add_theme_support( 'automatic-feed-links' );
        // Enable support for Post Thumbnails on posts and pages.
        add_theme_support( 'post-thumbnails' );
        // Add title-tag, it auto title of head
        add_theme_support( 'title-tag' );
        // Enable support for Post Formats.
        add_theme_support( 'post-formats',
            array(
                'video', 'quote', 'link', 'gallery'
            )
        );
        // Register images size
        add_image_size('manh_blog_tiny_footer_thumb', 90, 70, true);
        add_image_size('manh_blog_tiny_thumb', 90, 90, true);
        add_image_size('manh_blog_small_thumb', 430, 280, true);
        add_image_size('manh_blog_large_thumb', 960, 545, true);
        if ( class_exists('WooCommerce') ) {
            add_theme_support( 'wc-product-gallery-zoom' );
            add_theme_support( 'wc-product-gallery-lightbox' );
            add_theme_support( 'wc-product-gallery-slider' );
            add_theme_support( 'woocommerce', array(
                'thumbnail_image_width' => 315,
                'gallery_thumbnail_image_width' => 128,
                'single_image_width' => 545, 
            ));
        }
        //Setup the WordPress core custom background & custom header feature.
         $default_background = array(
            'default-color' => '#FFF',
        );
        add_theme_support( 'custom-background', $default_background );
        $default_header = array();
        add_theme_support( 'custom-header', $default_header );
        // Register navigations
        register_nav_menus( 
            array(
                'main_navigation' => __( 'Main navigation', 'manh' ),
                'user_navigation' => __( 'User navigation', 'manh' ),
            ) 
        );
        
    }
    add_action ( 'after_setup_theme', 'manh_setup' );
}

/** 
    Add class for body
 **/
add_filter( 'body_class', 'manh_bodyclass' );
function manh_bodyclass( $classes ) {
    $layouttype = manh_layouttype('layouttype');
    $classes[] = 'layout-type-'.$layouttype;
    if ( $layouttype == 'l-m' && '' == manh_get_sb('leftsidebar') ) {
        $classes[] = 'no-leftcol';
    }
    if ( $layouttype == 'm-r' && '' == manh_get_sb('rightsidebar') ) {
        $classes[] = 'no-rightcol';
    }
    if( manh_themeoption('advance_tooltip', 1) == 1){
        $classes[] = 'use-tooltip';
    }
    if( manh_getoption('use_stickmenu') == 1){
        $classes[] = 'use_stickmenu';
    }
    if ( manh_themeoption('woo_uselazyload', 0) == 1 ){
        $classes[] = 'use_lazyload';
    }
    if ( is_404() ) {
        $classes[] = 'page-404';
    }
    if ( is_page() && manh_metabox('useslideshow') == 1 && manh_metabox('revolutionslider') != '' ) {
        $classes[] = 'use-slideshow';
    }
    if ( is_page() && manh_metabox('page_class') != '' ) {
        $classes[] = manh_metabox('page_class');
    }
    $classes[] = 'header-'.manh_getoption('header_style', 'style1');
    $classes[] = 'footer-'.manh_getoption('footer_layout', '1');
    if ( manh_getoption('enable_search_cat') == true ) $classes[] = 'enable-search-cat';
    $breadcrumbbg = '';
    if ( is_front_page()  || is_404() ) {
        $showbreadcrumb = 0;
    }else{
        $showbreadcrumb = manh_getoption('showbreadcrump', '1');
        $breadcrumbbg = manh_getoption('breadcrumbbg', '', 'image');
    }

    if(class_exists('WooCommerce')){
        global $product;
        $classes[] = 'woocommerce';
        if( is_product() && $product->get_type() === 'variable' && manh_themeoption('woo_designvariations', 1) == 1 && manh_getoption('use_variation_thumb', 1) == 1 ){
            $classes[] = 'use-variation-thumb';
        }
        if( is_product() && manh_getoption('woo_gallery_type', 'h') == 'n2' ){
            $classes[] = 'use-gallery-type-n2';
        }
        if( is_product_category() ){ 
            $showbreadcrumb = manh_woo_cat_option('showbreadcrump');
            $breadcrumbbg = manh_woo_cat_option('breadcrumbbg', '', 'image');
        }
    }
    if ( $showbreadcrumb != '1' ) {
        $classes[] = 'no-breadcrumb';
    }elseif ( $showbreadcrumb == '1' && !is_array($breadcrumbbg) && $breadcrumbbg != '' ) {
        $classes[] = 'have-breadcrumb-img';
    }

    return $classes;
}

function manh_widgetlocations(){
    // Register widgetized locations
    if(function_exists('register_sidebar')) {
        register_sidebar(array(
            'name' => __( 'Blog Sidebar','manh' ),
            'id'   => 'blog-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<h3 class="widget-title"><span>',
            'after_title'   => '</span></h3>',
        ));
        register_sidebar(array(
            'name' => __( 'WooCommerce Sidebar','manh' ),
            'id'   => 'woo-sidebar',
            'before_widget' => '<aside id="%1$s" class="widget %2$s">',
            'after_widget'  => '</aside>',
            'before_title'  => '<h3 class="widget-title"><span>',
            'after_title'   => '</span></h3>',
        ));
        register_sidebar(array(
            'name' => __( 'WooCommerce Sidebar - Sticky','manh' ),
            'id'   => 'woo-sidebar-sticky',
            'before_widget' => '<div id="%1$s" class="widget woo-sidebar-sticky %2$s">',
            'after_widget'  => '</div>',
            'before_title'  => '<h4 class="widget-title">',
            'after_title'   => '</h4>'
        ));
    }
}
add_action( 'widgets_init', 'manh_widgetlocations' );
/** 
 *  Add styles & scripts
 **/
function manh_scripts() {
    global $manh_opt, $wp_query;
    $optimize = '.min'; $optimize = '';
    $css_file = manh_css_file();
    // Enqueue style
    wp_enqueue_style('bootstrap', MANH_THEME_URI . '/assets/css/bootstrap.min.css');
    wp_enqueue_style('owlcarousel', MANH_THEME_URI . '/assets/css/owl.carousel.min.css');
    wp_enqueue_style('slick', MANH_THEME_URI . '/assets/css/slick.min.css');
    wp_enqueue_style('select2', MANH_THEME_URI . '/assets/css/select2.min.css' );
    wp_enqueue_style('font-awesome', MANH_THEME_URI . '/assets/fonts/fontawesome-5/css/all.min.css'); 
    wp_enqueue_style('font-ionicons', MANH_THEME_URI . '/assets/fonts/ionicons/css/ionicons.min.css');
    wp_enqueue_style('manh-theme-style', MANH_THEME_URI . '/assets/css/' . $css_file);
    if ( !class_exists( 'Redux_Framework_Plugin' ) ) {
        wp_enqueue_style( 'manh-google-fonts', 'https://fonts.googleapis.com/css2?family=K2D:wght@400;700;800&display=swap' );
    }
    // Dequeue style
    wp_dequeue_style('simple-share-buttons-adder-font-awesome');
    wp_dequeue_style('yith-wcwl-font-awesome'); 
    // Register script
    wp_register_script('isotope', MANH_THEME_URI . '/assets/js/isotope.pkgd.min.js', array('jquery'), '', true);
    wp_register_script('manh-blog-ajax', MANH_THEME_URI . '/assets/js/sns-blog-ajax.js', array('jquery'), '', true);
    wp_register_script('jquery-countdown', MANH_THEME_URI . '/assets/countdown/jquery.countdown.min.js', array('jquery'), '2.1.0', true);
    wp_register_script( 'waypoints' , MANH_THEME_URI . '/assets/js/waypoints.min.js', array('jquery'), '', true);
    wp_register_script('threesixty', MANH_THEME_URI . '/assets/js/threesixty.min.js', array('jquery'), '', true);
    // Enqueue script
    wp_enqueue_script('bootstrap', MANH_THEME_URI . '/assets/js/bootstrap.min.js', array('jquery'), '', true);
    wp_enqueue_script('bootstrap-tabdrop', MANH_THEME_URI . '/assets/js/bootstrap-tabdrop.min.js', array('jquery'), '', true);
    wp_enqueue_script('bootstrap-input-spinner', MANH_THEME_URI . '/assets/js/bootstrap-input-spinner.min.js', array('jquery'), '', true);
    wp_enqueue_script('owlcarousel', MANH_THEME_URI . '/assets/js/owl.carousel.min.js', array('jquery'), '', true);
    wp_enqueue_script('slick', MANH_THEME_URI . '/assets/js/slick.min.js', array('jquery'), '', true);
    wp_enqueue_script('select2', MANH_THEME_URI.'/assets/js/select2.min.js', array(), '', true);
    wp_enqueue_script('jquery-waitforimages', MANH_THEME_URI.'/assets/js/jquery.waitforimages.min.js', array(), '', true);
    if(class_exists('WooCommerce')){
        if( manh_themeoption('woo_uselazyload', 0) == 1 ) {
            wp_enqueue_script('jquery-lazyload', MANH_THEME_URI . '/assets/js/jquery.lazyload.min.js', array('jquery'), '', true);
        }
        wp_enqueue_script('resizesensor', MANH_THEME_URI . '/assets/js/resizesensor.min.js', array('jquery'), '', true);
        wp_enqueue_script('sticky-sidebar', MANH_THEME_URI . '/assets/js/sticky-sidebar.min.js', array('jquery'), '', true);
        if( manh_themeoption('woo_usecloudzoom', 1) == 1 ) {
            wp_enqueue_script('jquery-elevatezoom', MANH_THEME_URI.'/assets/js/jquery.elevatezoom.min.js', array('jquery'), '', true);
        }
        wp_enqueue_script('manh-woo', MANH_THEME_URI.'/assets/js/sns-woo.js', array('jquery'), '', true);
    }
    wp_enqueue_script('manh-script', MANH_THEME_URI . '/assets/js/sns-script.js', array('jquery'), '', true);
    // Inline style after manh-theme-style, The conten render by function manh_cssinline()
    wp_add_inline_style( 'manh-theme-style', manh_cssinline() );
    // Inline scritp after manh-script. The conten render by function manh_jsinline()
    wp_add_inline_script( 'manh-script', manh_jsinline() );
    // Code to declare the URL to the file handing the AJAX request
    $js_params = array(
        'ajaxurl' => admin_url( 'admin-ajax.php' ),
        'query_vars' => $wp_query->query_vars
    );
    wp_localize_script('ajax-request', 'sns', $js_params);
}
add_action( 'wp_enqueue_scripts', 'manh_scripts' );
/**
 *  Remove inline style after FontAwesome
 **/
function manh_remove_cssinline(){
    wp_styles()->add_data( 'font-awesome', 'after', '' );
}
add_action( 'wp_print_styles', 'manh_remove_cssinline' );
/**
 * Inline style, with style depend config in Theme Option
**/
function manh_cssinline(){
    global $manh_opt;
    $bodycss = ''; $body_font_css = ''; $headlinecss = ''; $three_fontcss = ''; $breadcrumpcss = '';
    $body_font = array( "font-family" => "K2D", "font-weight" => "400", "font-size" => "14px", "color" => "#626262" );
    if(isset($manh_opt['body_font']) && is_array($manh_opt['body_font'])) {
        $body_font = $manh_opt['body_font'];
    }
    foreach($body_font as $propety => $value)
        if($value != 'true' && $value != 'false' && $value != '' && $propety != 'subsets' && $propety != 'google' )
            $body_font_css .= $propety . ':' . $value . ';';
    if($body_font_css != '') $bodycss .= $body_font_css;
    if(isset($manh_opt['headline_font']) && is_array($manh_opt['headline_font'])) {
        $headline_font = '';
        foreach($manh_opt['headline_font'] as $propety => $value)
            if($value != 'true' && $value != 'false' && $value != '' && $propety != 'subsets' && $propety != 'google' )
                $headline_font .= $propety . ':' . $value . ';';
        if ($headline_font != '' && isset($manh_opt['hfont_target']) and $manh_opt['hfont_target']!='' )  $headlinecss .= $manh_opt['hfont_target'].'{'.$headline_font.'}';
    }
    if(isset($manh_opt['three_font']) && is_array($manh_opt['three_font'])) {
        $three_font = '';
        foreach($manh_opt['three_font'] as $propety => $value)
            if($value != 'true' && $value != 'false' && $value != '' && $propety != 'subsets' && $propety != 'google' )
                $three_font .= $propety . ':' . $value . ';';
        if ($three_font != '' && isset($manh_opt['threefont_target']) and $manh_opt['threefont_target']!='' )  $three_fontcss .= $manh_opt['threefont_target'].'{'.$three_font.'}';
    }
    if( class_exists('WooCommerce') && is_woocommerce() && is_product_category() ){ 
        $showbreadcrump = manh_woo_cat_option('showbreadcrump');
        $breadcrumbbg = manh_woo_cat_option('breadcrumbbg', '', 'image');
    }else {
        $showbreadcrump = manh_getoption('showbreadcrump', '1');
        $breadcrumbbg = manh_getoption('breadcrumbbg', '', 'image');
    }
    if ( $showbreadcrump == '1' && !is_array($breadcrumbbg) && $breadcrumbbg != '' ) {
        $breadcrumpcss = '#sns_breadcrumbs.wrap{ background-image:url('.$breadcrumbbg.');}';
    }
    return 'body {'.$bodycss.'}'.$headlinecss.$three_fontcss.$breadcrumpcss;
}
/* 
 * Inline script, with js variables depend config in Theme Option & Product Option
 */
function manh_jsinline() {
    $output = '';
    ob_start();
    if(class_exists('WooCommerce')){ ?>
        if ( typeof wc_single_product_params !== 'undefined' ) {
            wc_single_product_params.sns_thumbnum = '<?php echo esc_html(manh_themeoption('woo_thumb_num', 5)) ; ?>';
            wc_single_product_params.sns_product_video = '<?php echo esc_html(get_post_meta( get_the_id(), 'manh_product_video', true )); ?>';
        }
        <?php
        global $product;
        $theID = get_the_id();
        $product = wc_get_product( $theID );
        if( is_product() && $product->get_type() === 'variable' && manh_themeoption('woo_designvariations', 1) == 1 ){
            $attributes = $product->get_attributes();
            ?>
            /* Declaring sns_arr_attr variable if Product Type is Variable Product */
            var sns_arr_attr = {};
            <?php
            foreach ( $attributes as $attribute ) :
                if ( empty( $attribute['is_visible'] ) || ( $attribute['is_taxonomy'] && ! taxonomy_exists( $attribute['name'] ) ) ) {
                    continue;
                } else {}
                $terms = wc_get_product_terms( $product->get_id(), $attribute['name'], array( 'fields' => 'all' ) );
                $type = '';
                $key_val = array();
                $i = 0;
                if ( is_array($terms) && empty($terms) ) {
                    $terms = $attribute['options'];
                    foreach ($terms as $term) { $i++;
                        $key_val[$term] = $term;
                    }
                }else{
                    foreach ($terms as $term) { $i++;
                        $type = manh_get_term_byid($term->term_id, 'manh_product_attribute_type', 'text');

                        $available_variations = $product->get_available_variations();
                        $image_src = ''; $color_code = '';
                        foreach ($available_variations as $available_variation) {
                            if( manh_getoption('use_variation_thumb', 1) == 1 && isset($available_variation['attributes']["attribute_$term->taxonomy"]) && $term->slug === $available_variation['attributes']["attribute_$term->taxonomy"] ){
                                $image_src = get_post_thumbnail_id( $available_variation['variation_id'] ); 
                                $image_src = wp_get_attachment_image_src( $image_src, 'shop_thumbnail');
                                $image_src = isset($image_src['0']) ? $image_src['0'] : '';
                                
                            }
                        }
                        $color_code = manh_get_term_byid($term->term_id, 'manh_product_attribute_color', '');
                        if ( $image_src != '' ) {
                            $key_val[$term->slug] = $image_src;
                        }elseif( trim($color_code) != '' ){
                            $key_val[$term->slug] = $color_code;
                        }else{
                            $key_val[$term->slug] = $term->name;
                        }
                    } 
                }?>
                var attributeName = '<?php echo esc_attr( strtolower($attribute['name']) ) ?>';
                var data_type = '<?php echo esc_attr($type); ?>';
                var key_val = {};
                <?php foreach ($key_val as $key => $value):?>
                    key_val['<?php echo esc_attr($key) ?>'] = '<?php echo esc_attr($value) ?>';
                <?php endforeach;?>
                sns_arr_attr['attribute_' + attributeName] = {'type': data_type, key_val};
            <?php
            endforeach;
        }
    } ?>
    /* Declaring ajaxurl variable */
    if (typeof ajaxurl == 'undefined') {
        var ajaxurl = '<?php echo esc_js( admin_url('admin-ajax.php') ); ?>';
    }
    <?php
    $output = '/* <![CDATA[ */ ' . ob_get_clean() . '/* ]]> */';
    return $output;
}
/*
 * Enqueue admin styles and scripts
 */
function manh_admin_styles_scripts(){
    wp_enqueue_style('manh-admin-style', MANH_THEME_URI.'/assets/css/admin-style.css');
    wp_enqueue_style( 'wp-color-picker' );
    wp_enqueue_style('font-awesome', MANH_THEME_URI . '/assets/fonts/awesome/css/font-awesome.min.css');
    wp_enqueue_media();
    wp_enqueue_script( 'wp-color-picker' );
    wp_enqueue_script('manh-admin-template-js', MANH_THEME_URI.'/assets/js/sns-admin-template.js', array( 'jquery', 'wp-color-picker' ), false, true);
}
add_action('admin_enqueue_scripts', 'manh_admin_styles_scripts');
/**
 * Editor style
 **/
add_editor_style('assets/css/editor-style.css');
/* 
 * Add tpl footer
 */
function manh_tplfooter() {
    ob_start();
    require MANH_THEME_DIR . '/tpl-footer.php';
    echo ob_get_clean();
}
add_action('wp_footer', 'manh_tplfooter');
/** 
 *  Tile for page, post
 **/
function manh_pagetitle(){
    // Disable title in page
    if ( class_exists('WooCommerce') ) {
        if( is_shop() && manh_metabox('showtitle') == '2' ) return;
    }
    if( is_front_page() || ( is_page() && manh_metabox('showtitle') == '2' ) ) return;
    // Show title in page, single post
    if ( is_singular('post') ) : return; ?>
        <h3 class="page-header">
            <span><?php echo esc_html__('Blog', 'manh'); ?></span>
        </h3>
    <?php
    elseif( is_page() || ( is_home() && get_option( 'show_on_front' ) == 'page' ) ) : ?>
        <h1 class="page-header">
            <span><?php the_title(); ?></span>
        </h1>
    <?php 
    // Show title for category page
    elseif ( is_category() ) : ?>
        <h1 class="page-header">
            <span><?php single_cat_title(); ?></span>
        </h1>
    <?php
    // Author
    elseif ( is_author() ) : ?>
        <h1 class="page-header">
            <span>
        <?php
            printf( __( 'All posts by: %s', 'manh' ), get_the_author() );
        ?>
            </span>
        </h1>
        <?php if ( get_the_author_meta( 'description' ) ) : ?>
        <header class="archive-header">
            <div class="author-description"><p><?php the_author_meta( 'description' ); ?></p></div>
        </header>
        <?php endif; ?>
    <?php 
    // Tag
    elseif ( is_tag() ) : ?>
        <h1 class="page-header">
            <span>
            <?php printf( __( 'Tag Archives: %s', 'manh' ), single_tag_title( '', false ) ); ?>
            </span>
        </h1>
        <?php
        $term_description = term_description();
        if ( ! empty( $term_description ) ) : ?>
        <header class="archive-header">
            <?php printf( '<div class="taxonomy-description">%s</div>', $term_description ); ?>
        </header>
        <?php endif; ?>
    <?php 
    // Search
    elseif ( is_search() ) : ?>
        <h1 class="page-header"><span><?php printf( __( 'Search Results for: %s', 'manh' ), get_search_query() ); ?></span></h1>
    <?php
    // Archive
    elseif ( is_archive() ) : ?>
        <h1 class="page-header">
            <?php 
            if ( class_exists('WooCommerce') && is_woocommerce() ) {
                woocommerce_page_title(); 
            }else{
                the_archive_title();
            }
            ?>
        </h1>
        <?php
        if( get_the_archive_description() ): ?>
        <header class="archive-header">
            <?php the_archive_description( '<div class="taxonomy-description">', '</div>' ); ?>
        </header>
        <?php    
        endif;
        ?>
    <?php
    // Default
    else : ?>
        <h1 class="page-header">
            <span><?php the_title(); ?></span>
        </h1>
    <?php
    endif;
}

// Excerpt Function
if(!function_exists('manh_excerpt')){
    function manh_excerpt($limit, $afterlimit='[...]') {
        $limit = ($limit) ? $limit : 55 ;
        $excerpt = get_the_excerpt();
        if( $excerpt != '' ){
           $excerpt = explode(' ', strip_tags( $excerpt ), intval($limit));
        }else{
            $excerpt = explode(' ', strip_tags(get_the_content( )), intval($limit));
        }
        if ( count($excerpt) >= $limit ) {
            array_pop($excerpt);
            $excerpt = implode(" ",$excerpt).' '.$afterlimit;
        } else {
            $excerpt = implode(" ",$excerpt);
        }
        $excerpt = preg_replace('`[[^]]*]`','',$excerpt);
        return strip_shortcodes( $excerpt );
    }
}

// Word Limiter
function manh_limitwords($string, $word_limit) {
    $words = explode(' ', $string);
    if ( $word_limit < count($words) ){
        return implode(' ', array_slice($words, 0, $word_limit));
    }else{
        return implode(' ', array_slice($words, 0, $word_limit));
    }
}
function manh_limitcharacter($string, $character_limit) {
    if ( $character_limit < strlen($string) ){
        return substr($string, 0, $character_limit) . ' ...';
    }else{
        return $string;
    }
}
//
if(!function_exists('manh_sharebox')){
    function manh_sharebox(){
        if ( class_exists('SimpleShareButtonsAdder\Plugin') ) {
        ?>
        <div class="post-share-block">
            <?php echo do_shortcode('[ssba-buttons]'); ?>
        </div>
        <?php
        }
    }
}
//
if(!function_exists('manh_relatedpost')){
    function manh_relatedpost(){
        global $post;
        if($post){
            $post_id = $post->ID;
        }
        
        $relate_count = manh_themeoption('related_num');
        $get_related_post_by = manh_themeoption('related_posts_by');

        $args = array(
            'post_status' => 'publish',
            'posts_per_page' => $relate_count,
            'orderby' => 'date',
            'ignore_sticky_posts' => 1,
            'post__not_in' => array ($post_id)
        );
        
        if($get_related_post_by == 'cat'){
            $categories = wp_get_post_categories($post_id);
            $args['category__in'] = $categories;
        }else{
            $posttags = wp_get_post_tags($post_id);
            
            $array_tags = array();
            if($posttags){
                foreach ($posttags as $tag){
                    $tags = $tag->term_id;
                    array_push($array_tags, $tags);
                }
            }
            $args['tag__in'] = $array_tags;
        }
        
        $relates = new WP_Query( $args );
        $template_name = '/framework/tpl/posts/related_post.php';
        if(is_file(MANH_THEME_DIR.$template_name)) {
            include(MANH_THEME_DIR.$template_name);
        }
        wp_reset_postdata();
    }
}

/*
 * Function to display number of posts.
 */
function manh_get_post_views($post_id){
    $count_key = 'post_views_count';
    $count = get_post_meta($post_id, $count_key, true);
    if($count == ''){
        delete_post_meta($post_id, $count_key);
        add_post_meta($post_id, $count_key, '0');
        return esc_html__('0 view', 'manh');
    }
    return $count. esc_html__(' View', 'manh');
}
/*
* Redmore for excerpt
*/
function manh_excerpt_more( $link ) {
    $link = '';
    if ( is_admin() ) {
        return $link;
    }
    if ( !is_search() ) {
        $link = sprintf(
            '<p class="link-more"><a href="%1$s" class="more-link">%2$s</a></p>',
            esc_url( get_permalink( get_the_ID() ) ),
            '<span>'.__('Read More', 'manh').'</span><span class="meta-nav">&#8594;</span>'
        );
    }
    return $link;
}
add_filter( 'excerpt_more', 'manh_excerpt_more' );
/*
 * Function to count views.
 */
function manh_set_post_views($post_id){
    $count_key = 'post_views_count';
    $count = get_post_meta($post_id, $count_key, true);
    if($count == ''){
        $count = 0;
        delete_post_meta($post_id, $count_key);
        add_post_meta($post_id, $count_key, '0');
    }else{
        $count++;
        update_post_meta($post_id, $count_key, $count);
    }
}


function manh_comment($comment, $args, $depth) {
    $GLOBALS['comment'] = $comment; ?>
    <?php $add_below = ''; ?>
    <li <?php comment_class(); ?> id="comment-<?php comment_ID() ?>">
        <div class="comment-body">
            <div class="comment-user-meta">
                <?php echo get_avatar($comment, 100); ?>
                <div class="comment-head">
                    <h4 class="comment-user"><?php echo get_comment_author_link(); ?>
                        <span class="date">
                            <?php 
                            printf(__('%1$s at %2$s', 'manh'), get_comment_date(),  get_comment_time()) 
                            ?>
                        </span>
                    </h4>
                </div>
                <?php if ($comment->comment_type != 'pingback'): ?>
                <div class="comment-content">
                    <?php if ($comment->comment_approved == '0') : ?>
                    <p>
                        <em><?php echo esc_html__('Your comment is awaiting moderation.', 'manh') ?></em><br />
                    </p>
                    <?php endif; ?>
                     <?php comment_text() ?>
                </div>
                <?php endif; ?>
                <div class="comment-meta">
                    <?php comment_reply_link(array_merge( $args, array('reply_text' => esc_html__('Reply', 'manh'), 'add_below' => 'comment', 'depth' => $depth, 'max_depth' => $args['max_depth'])))?>
                    <?php edit_comment_link(esc_html__('Edit', 'manh'),'  ','') ?>
                </div>
            </div>
        </div>
  <?php 
}
/** 
 *  Breadcrumbs
 **/
add_action( 'manh_before_sns_content', 'manh_getbigbreadcrumbs', 5 );
function manh_getbigbreadcrumbs(){
    $showbreadcrump = '';
    if( class_exists('WooCommerce') && is_woocommerce() && is_product_category() ){ 
        $showbreadcrump = manh_woo_cat_option('showbreadcrump');
    }else {
        $showbreadcrump = manh_getoption('showbreadcrump', '1');
    }
    if ( $showbreadcrump != '1' ) return;
    $bread_class = 'wrap';
    if ( !is_front_page()  && !is_404() ) : ?>
        <div id="sns_breadcrumbs" class="<?php echo esc_attr($bread_class); ?>">
            <div class="container">
                <?php 
                if( is_file( MANH_THEME_DIR . '/tpl-breadcrumb.php' ) ) {
                    echo '<div class="inner">';
                        if ( class_exists('WooCommerce') && is_product() ) {
                            echo '<div class="page-header">
                                <span>'.esc_html__('Shop', 'manh').'</span>
                            </div>';
                        }elseif( is_singular('post') ){
                            echo '<div class="page-header">
                                <span>'.esc_html__('Blog', 'manh').'</span>
                            </div>';
                        }else{
                            manh_pagetitle();
                        }
                        include( MANH_THEME_DIR . '/tpl-breadcrumb.php' );
                    echo '</div>';
                }
                ?>
            </div>
        </div>
    <?php endif;
}
/** 
 *  Search Ajax From
 **/
if( !function_exists('manh_get_searchform') ){
    function manh_get_searchform($search_box_type = 'def'){
        $exists_woo = (class_exists('WooCommerce'))?true:false;
        if( $exists_woo ){
            $taxonomy = 'product_cat';
            $post_type = 'product';
            $placeholder_text = esc_attr__('Search product...', 'manh');
        }else{
            $taxonomy = 'category';
            $post_type = 'post';
            $placeholder_text = esc_attr__('Enter keywords...', 'manh');
        }
        $options = '<option value="">'.esc_html__('All categories', 'manh').'</option>';
        $options .= manh_get_searchform_option($taxonomy, 0, 0);
        $uq = rand().time();
        if( $search_box_type != 'hide_cat' ){
            echo '<div class="sns-searchwrap container" data-useajaxsearch="true" data-usecat-ajaxsearch="true">';
        }else{
            echo '<div class="sns-searchwrap container" data-useajaxsearch="true" data-usecat-ajaxsearch="false">';
        }
        echo '<div class="sns-ajaxsearchbox">
        <form method="get" id="search_form_' . $uq . '" action="' . esc_url( home_url( '/'  ) ) . '">';
        if( $search_box_type != 'hide_cat' ){
            echo '<select class="select-cat" name="cat">' . $options . '</select>';
        }
        echo '
        <div class="search-input">
            <input type="text" value="' . get_search_query() . '" name="s" id="s_' . $uq . '" placeholder="' . esc_attr($placeholder_text) . '" autocomplete="off" />
            <button type="submit">
                '. esc_html__('Search', 'manh') .'
            </button>
            <input type="hidden" name="post_type" value="' . esc_attr($post_type) . '" />';

        if ( $search_box_type != 'hide_cat' ) { echo '<input type="hidden" name="taxonomy" value="' . esc_attr($taxonomy) . '" />'; }
        echo '</div>
        </form></div></div>';
    }
}

if( !function_exists('manh_get_searchform_option') ){
    function manh_get_searchform_option($taxonomy = 'product_cat', $parent = 0, $level = 0){
        $options = '';
        $spacing = '';
        for( $i = 0; $i < $level * 3 ; $i++ ){
            $spacing .= '&nbsp;';
        }
        $args = array(
            'number'        => '',
            'hide_empty'   => 1,
            'orderby'      =>'date',
            'order'        =>'desc',
            'parent'       => $parent
        );
        $select = '';
        $categories = get_terms($taxonomy, $args);
        if( is_search() &&  isset($_GET['cat']) && $_GET['cat'] != '' ){
            $select = $_GET['cat'];
        }
        $level++;
        if( is_array($categories) ){
            foreach( $categories as $cat ){
                $options .= '<option value="' . esc_attr($cat->slug) . '"';
                if ($select == $cat->slug) {
                    $options .= ' selected';
                }
                $options .= '>' . esc_html($spacing) . esc_html($cat->name) . '</option>';
                $options .= manh_get_searchform_option($taxonomy, $cat->term_id, $level);
            }
        }
        return $options;
    }
}

/** 
 *  Search by Title only From
 **/
function manh_search_by_title_only( $search )  {  
    global $wpdb, $wp_query;
    if ( empty( $search ) )  
        return $search; // skip processing - no search term in query  
    $q = $wp_query->query_vars;
    $n = ( isset( $q['exact'] ) && ! empty( $q['exact'] ) ) ? '' : '%';  
    $search =  '';
    $searchand = '';  
    foreach ( (array) $q['search_terms'] as $term ) {  
        $term = esc_sql( $wpdb->esc_like( $term ) );  
        $like = $n . $term . $n;
        $search .= $wpdb->prepare( "{$searchand}($wpdb->posts.post_title LIKE %s)", $like );
        $searchand = ' AND ';  
    }  
    if ( ! empty( $search ) ) {  
        $search = " AND ({$search}) ";  
        if ( ! class_exists('WooCommerce') && ! is_user_logged_in() ) { // Just for post
            $search .= " AND ($wpdb->posts.post_password = '') ";  
        }
    }
    return $search;
} 

/**
 * Ajax search action
 **/
add_action( 'wp_ajax_manh_ajax_search', 'manh_ajax_search' );
add_action( 'wp_ajax_nopriv_manh_ajax_search', 'manh_ajax_search' );

if( !function_exists('manh_ajax_search') ){
    function manh_ajax_search(){ 
        global $post, $wp_query;

        $exists_woo = ( class_exists('WooCommerce') ) ? true : false ;
        if( $exists_woo ){
            $taxonomy = 'product_cat';
            $post_type = 'product';
        }else{
            $taxonomy = 'category';
            $post_type = 'post';
        }
        $num_result = manh_getoption('search_limit', -1);
        $keywords = $_POST['keywords'];
        $category = isset($_POST['category'])? $_POST['category']: '';
        $args = array(
            'post_type'        => $post_type,
            'post_status'      => 'publish',
            's'                => $keywords,
            'posts_per_page'   => $num_result
        );
        if( $category != '' ){
            $args['tax_query'] = array(
                array(
                    'taxonomy'  => $taxonomy,
                    'terms'     => $category,
                    'field'     => 'slug'
                )
            );
        }
        $results = new WP_Query($args);
        if( $results->have_posts() ){
            $extra_class = '';
            if( isset($results->post_count, $results->found_posts) && $results->found_posts > $results->post_count ){
                $extra_class = 'allcat-result';
            }
            $html = '<ul class="'.esc_attr($extra_class).'">';
            while( $results->have_posts() ){
                $results->the_post();
                $link = get_permalink($post->ID);
                $image = '';
                if( $post_type == 'product' ){
                    $product = wc_get_product($post->ID);
                    $image = $product->get_image();
                }
                else if( has_post_thumbnail($post->ID) ){
                    $image = get_the_post_thumbnail($post->ID, 'thumbnail');
                }
                $html .= '<li>';
                    if( $image ){
                        $html .= '<div class="thumbnail">';
                            $html .= '<a href="'.esc_url($link).'">'. $image .'</a>';
                        $html .= '</div>';
                    }
                    $html .= '<div class="meta">';
                        $html .= '<a href="'.esc_url($link).'" class="title">'. manh_ajaxsearch_highlight_key($post->post_title, $keywords) .'</a>';
                        if( $post_type == 'product' ){
                            $html .= '<span class="price">'. $product->get_price_html() .'</span>';
                        }
                    $html .= '</div>';
                $html .= '</li>';
            }
            $html .= '</ul>';
            if( isset($results->post_count, $results->found_posts) && $results->found_posts > $results->post_count ){
                $html .= '<div class="viewall-result">';
                    $html .= '<a href="#">'. sprintf( __('View all %d results', 'manh'), $results->found_posts ) .'</a>';
                $html .= '</div>';
            }
            wp_reset_postdata();
            
            $return = array();
            $return['html'] = $html;
            $return['keywords'] = $keywords;
            die( json_encode($return) );
        }else{
            wp_reset_postdata();
            $return = array();
            if( $exists_woo ){
                $return['html'] = esc_html__('No products were found matching your selection', 'manh');
            }else{
                $return['html'] = esc_html__('No post were found matching your selection', 'manh');
            }  
            $return['keywords'] = $keywords;
            die( json_encode($return) );
        }
    }
}
/**
 *  Highlight search key
 **/
if( !function_exists('manh_ajaxsearch_highlight_key') ){
    function manh_ajaxsearch_highlight_key($string, $keywords){
        $hl_string = '';
        $position_left = stripos($string, $keywords);
        if( $position_left !== false ){
            $position_right = $position_left + strlen($keywords);
            $hl_string_rightsection = substr($string, $position_right);
            $highlight = substr($string, $position_left, strlen($keywords));
            $hl_string_leftsection = stristr($string, $keywords, true);
            $hl_string = $hl_string_leftsection . '<span class="hightlight">' . $highlight . '</span>' . $hl_string_rightsection;
        } else{
            $hl_string = $string;
        }
        return $hl_string;
    }
}

/**
 *  Match with default search
 **/
add_filter('woocommerce_get_catalog_ordering_args', 'manh_woo_get_catalog_ordering_args');
if( !function_exists('manh_woo_get_catalog_ordering_args') ){
    function manh_woo_get_catalog_ordering_args( $args ){
        if( class_exists('WooCommerce') && is_search() && !isset($_GET['orderby']) && get_option( 'woocommerce_default_catalog_orderby' ) == 'menu_order' ){
            $args['orderby'] = '';
            $args['order'] = '';
        }
        return $args;
    }
}
/**
 * Slideshow wrap
 **/
function manh_slideshow_wrap($container = false, $extra_width = false){
    if ( is_page() && manh_metabox('useslideshow') == 1 ): ?>
    <div id="sns_slideshow" class="wrap">
        <?php
        if ( $container == true ) {
            if ( $extra_width == true ) {
                echo '<div class="container extra-width">'.do_shortcode('[rev_slider '.esc_attr(manh_metabox('revolutionslider')).' ]').'</div>'; 
            }else{
                echo '<div class="container">'.do_shortcode('[rev_slider '.esc_attr(manh_metabox('revolutionslider')).' ]').'</div>'; 
            }
        }else{
            echo do_shortcode('[rev_slider '.esc_attr(manh_metabox('revolutionslider')).' ]'); 
        }
        ?>
    </div>
    <?php
    endif;
}
/** 
 * Sample data 
 **/
add_action( 'admin_enqueue_scripts', 'manh_importlib' );
function manh_importlib(){
    wp_enqueue_script('sampledata', MANH_THEME_URI . '/framework/sample-data/assets/script.js', array('jquery'), '', true);
    wp_enqueue_style('sampledata-css', MANH_THEME_URI . '/framework/sample-data/assets/style.css');
}
add_action( 'wp_ajax_sampledata', 'manh_importsampledata' );
function manh_importsampledata(){
    include_once(MANH_THEME_DIR . '/framework/sample-data/sns-importdata.php');
    manh_importdata();
}
