<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="content-inner">
    <?php
    // Post Quote
    if ( get_post_format() == 'quote' && function_exists('rwmb_meta') && rwmb_meta('manh_post_quotecontent') && rwmb_meta('manh_post_quoteauthor') ) :
        $uq  = rand().time();
        ?>
        <div class="quote-info quote-info-<?php echo esc_attr($uq); ?>">
            <?php if ( rwmb_meta('manh_post_quotecontent') ) : ?>
            <div class="quote-content"><?php echo esc_html(rwmb_meta('manh_post_quotecontent')); ?></div>
            <?php endif; ?>
             <?php if ( rwmb_meta('manh_post_quoteauthor') ) : ?>
            <div class="quote-author"><?php echo esc_html(rwmb_meta('manh_post_quoteauthor')); ?></div>
            <?php endif; ?>
        </div>
    <?php
    // Post Link
    elseif ( get_post_format() == 'link' && function_exists('rwmb_meta') && rwmb_meta('manh_post_linkurl') ) : ?>
        <div class="link-info">
            <a title="<?php echo esc_attr(rwmb_meta('manh_post_linktitle')) ?>" href="<?php echo esc_url( rwmb_meta('manh_post_linkurl') ) ?>"><?php echo esc_html(rwmb_meta('manh_post_linktitle')) ?></a>
        </div>
    <?php
    // Post Video
    elseif ( get_post_format() == 'video' && get_post_meta(get_the_id(), 'manh_post_video', true) ) : 
    ?>
        <div class="video-thumb video-responsive">
            <?php
            echo wp_oembed_get(esc_attr(get_post_meta(get_the_id(), 'manh_post_video', true)));
            ?>
        </div>
    <?php
    // Post Audio
    elseif ( get_post_format() == 'audio' && get_post_meta(get_the_id(), 'manh_post_audio', true) ) : 
    ?>
        <div class="audio-thumb audio-responsive">
            <?php
            echo wp_oembed_get(esc_attr(get_post_meta(get_the_id(), 'manh_post_audio', true)));
            ?>
        </div>
    <?php
    // Post Gallery
    elseif ( function_exists('rwmb_meta') && rwmb_meta('manh_post_gallery') ) :
    ?>
        <div class="gallery-thumb">
            <div class="thumb-container owl-carousel">
            <?php
            foreach (rwmb_meta('manh_post_gallery', 'type=image') as $image) {
                if ( isset($image['sizes']['full_url']) && $image['sizes']['full_url']['file'] ) {
                    $src = str_replace($image['name'], $image['sizes']['full_url']['file'], $image['full_url']);
                }else{
                    $src = $image['full_url'];
                }
                ?>
               <div class="item"><img alt="<?php echo esc_attr($image['alt']); ?>" src="<?php echo esc_attr($src); ?>"/></div>
            <?php
            }
            ?>
            </div>
        </div>
    <?php
    // Post Image
    elseif ( has_post_thumbnail() ) : ?>
        <div class="post-thumb">
            <?php
           the_post_thumbnail();
            ?>
        </div>
    <?php
    endif;?>
    <div class="post-info-wrap">
        <div class="post-info-inner">
            <div class="post-meta">
<?php
// Date
printf( '<span class="entry-date"><a href="%1$s" rel="bookmark"><time class="entry-date published" datetime="%2$s">%3$s</time></a></span>', esc_url( get_permalink() ), esc_attr( get_the_date( DATE_W3C ) ), esc_html( get_the_date() )
); ?>
<?php if(manh_themeoption('show_categories', 1) == 1 && get_the_category_list() ): ?>
<div class="post-categories">
<?php echo esc_html__( 'In: ','manh' ); ?>
<span class="cat-links">
<?php echo get_the_category_list(', '); ?>
</span>
</div><?php endif;?>
<span class="post-author">
<?php
printf( wp_kses(__( '%s <a class="author-link" href="%s">%s</a>', 'manh' ), array(
            'a' => array(
                'href' => array(),
                'class' => array(),
                'ref' => array()
            ),
            ) ), esc_html__( 'By:','manh' ), esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author_meta('display_name') ); ?>
</span><?php
// Edit link
edit_post_link(esc_html__('Edit','manh'), '<span class="edit-post">', '</span>'); ?>
            </div>
            <?php if ( get_the_title() != '' ) : ?>
            <h1 class="post-title">
                <?php the_title(); ?>
            </h1>
            <?php endif;?>
            <div class="post-content">
                <?php 
                the_content();
                // Post Paging
                wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'manh' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) ); 
                ?>
            </div><!-- /.post-content -->
        </div>
    </div>
</div>
    <?php
    if ( ( manh_themeoption('show_postsharebox') && class_exists('SimpleShareButtonsAdder\Plugin') ) || get_the_tag_list() ) :?>
    <div class="post-foot">
        <?php
        if ( manh_themeoption('show_postsharebox') ) :
           manh_sharebox();
        endif;
        ?>
        <?php if( get_the_tag_list() ): ?>
        <div class="left-part">
            <?php if( get_the_tag_list() ): ?>
                <span class="tags-links">
                    <?php the_tags('<span class="label">'.esc_html__('Tags:', 'manh').'</span> ', ''); ?>
                </span>
            <?php endif; ?>
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
    <?php
    // Post navigation.
    manh_post_nav();
    ?>
    <?php
        // Author bio
        if ( manh_themeoption('show_postauthor') && get_the_author_meta( 'description' ) ) :
            get_template_part( 'author-bio' );
        endif;
    ?>
    <?php
    // Related post
    if ( manh_themeoption('enalble_related', false) ) : ?>
    <div class="post-related">
        <?php manh_relatedpost(); ?>
    </div>
    <?php
    endif; ?>
    
    <?php 
    // If comments are open or we have at least one comment, load up the comment template.
    if ( comments_open() || get_comments_number() ) :
    comments_template();
    endif;
    ?>
</article>