<?php
if( $relates->have_posts() ): ?>
	<h2 class="related-title">
        <span><?php echo esc_html__( 'Related post', 'manh' ); ?></span>
    </h2>
    <div class="related-content"><div class="owl-carousel">
		<?php
		while ( $relates->have_posts() ) : $relates->the_post();
        ?>
            <div class="item">
                <?php if ( has_post_thumbnail()) : ?>
                    <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" class="image">
                        <?php the_post_thumbnail('manh_blog_small_thumb'); ?>
                    </a>
                <?php endif; ?>
                 <div class="post-meta">
                    <?php 
                    $post_categories = get_the_terms( $post->ID, 'category' );
                    if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
                        $cate_name = wp_list_pluck( $post_categories, 'name' );
                        $cate_id = wp_list_pluck( $post_categories, 'term_id' );
                        $length = count($cate_id);
                        echo '<a class="post-cat" href="' . get_category_link($cate_id[$length - 1]) . '">' .$cate_name[$length - 1] . '</a>';
                    }
                    ?>
                    <span class="post-author">
                    <?php
printf( wp_kses(__( '%s <a class="author-link" href="%s" ref="author">%s</a>', 'manh' ), array(
            'a' => array(
                'href' => array(),
                'class' => array(),
                'ref' => array()
            ),
            ) ), esc_html__( 'By:','manh' ), esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author_meta('display_name') ); ?>
                    </span>
                </div>
                <h3 class="title">
                    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>
            </div>
        <?php
        endwhile; ?>
    </div></div>
    <?php
endif;
?>