<div class="sns-grid-item">
	<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    	<div class="inner-post">
	    <?php
    // Post Quote
    if ( get_post_format() == 'quote' && function_exists('rwmb_meta') && rwmb_meta('manh_post_quotecontent') && rwmb_meta('manh_post_quoteauthor') ) :
        $uq  = rand().time();
        ?>
        <div class="quote-info quote-info-<?php echo esc_attr($uq); ?>">
            <?php if ( rwmb_meta('manh_post_quotecontent') ) : ?>
            <div class="quote-content"><?php echo esc_html(rwmb_meta('manh_post_quotecontent')); ?></div>
            <?php endif; ?>
             <?php if ( rwmb_meta('manh_post_quoteauthor') ) : ?>
            <div class="quote-author"><?php echo esc_html(rwmb_meta('manh_post_quoteauthor')); ?></div>
            <?php endif; ?>
        </div>
    <?php
    // Post Link
    elseif ( get_post_format() == 'link' && function_exists('rwmb_meta') && rwmb_meta('manh_post_linkurl') ) : 
    ?> 
        <div class="link-info">
            <a title="<?php echo esc_attr(rwmb_meta('manh_post_linktitle')) ?>" href="<?php echo esc_url( rwmb_meta('manh_post_linkurl') ) ?>"><?php echo esc_html(rwmb_meta('manh_post_linktitle')) ?></a>
        </div>
    <?php
    // Post Video
    elseif ( get_post_format() == 'video' && get_post_meta(get_the_id(), 'manh_post_video', true) ) : 
    ?>
        <div class="video-thumb video-responsive">
            <?php
            echo rwmb_meta('manh_post_video');
            ?>
        </div>
    <?php
    // Post audio
    elseif ( get_post_format() == 'audio' && get_post_meta(get_the_id(), 'manh_post_audio', true) ) : ?>
    ?>
        <div class="audio-thumb audio-responsive">
            <?php
            echo wp_oembed_get(esc_attr(rwmb_meta('manh_post_audio')));
            ?>
        </div>
    <?php
    // Post Gallery
    elseif ( function_exists('rwmb_meta') && rwmb_meta('manh_post_gallery') ) :
    ?>
        <div class="gallery-thumb">
            <div class="thumb-container owl-carousel">
            <?php
            foreach (rwmb_meta('manh_post_gallery', 'type=image') as $image) { ?>
                <?php 
                if ( $image['sizes']['manh_blog_small_thumb']['file'] ) {
                    $src = str_replace($image['name'], $image['sizes']['manh_blog_small_thumb']['file'], $image['full_url']);
                }else{
                    $src = $image['full_url'];
                }
                ?>
               <div class="item"><img alt="<?php echo esc_attr($image['alt']); ?>" src="<?php echo esc_attr($src); ?>"/></div>
            <?php
            }
            ?>
            </div>
        </div>
    <?php
    // Post Image
    elseif ( has_post_thumbnail() ) : ?>
        <div class="post-thumb">
            <?php
            $blog_type = manh_themeoption('blog_type');
            ?>
            <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">
            <?php
                the_post_thumbnail('manh_blog_small_thumb');
            ?>
            </a>
        </div>
    <?php
    endif;?>
<div class="post-info-wrap">
    <div class="post-meta">
        <?php if ( is_sticky() && ! is_paged() && !is_search() ) { ?>
            <span class="sticky-content"><?php echo esc_html__( 'Featured', 'manh' ) ; ?></span>
        <?php
        } ?>
<?php printf( '<span class="post-date"><a href="%1$s" rel="bookmark"><time class="entry-date published" datetime="%2$s">%3$s</time></a></span>', esc_url( get_permalink() ), esc_attr( get_the_date( DATE_W3C ) ), esc_html( get_the_date() ) ); ?>
<?php
if(manh_themeoption('show_categories', 1) == 1 && get_the_category_list() ):
$post_categories = get_the_terms( get_the_ID(), 'category' );
if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
    $cate_name = wp_list_pluck( $post_categories, 'name' );
    $cate_id = wp_list_pluck( $post_categories, 'term_id' );
    $length = count($cate_id);
    echo '<div class="post-categories">'.esc_html__( 'In: ','manh' ).'<a class="post-cat" href="' . get_category_link($cate_id[0]) . '">' .$cate_name[0] . '</a></div>';
}
?>
<?php endif;?>
        <?php if( 1 == 0 && ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ): ?>
            <span class="post-comment-count">
            <?php
                echo '<span class="comments-link">';
                comments_popup_link( esc_html__( '0 Comments','manh' ),  esc_html__( '1 Comment','manh' ), '%' . esc_html__(' Comments','manh'));
                echo '</span>';
            ?>
            </span>
        <?php endif; ?>
    </div>
    <?php if ( get_the_title() != '' ) : ?>
    <h3 class="post-title">
        <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a>
    </h3>
    <?php endif;?>
    <?php if ( 1==0 ) { ?>
    <div class="post-content">
        <?php
        if ( is_search() ) {
            the_excerpt();
        }else{
            if( empty( $post->post_excerpt ) ) {
                $readmore = '<span>'.esc_html__('Read More', 'manh').'</span><span class="meta-nav">&#8594;</span>';
                if ( $post->post_type == 'page' ) {
                    // Trip shortcodes for post type is page on search result page
                    echo strip_shortcodes(get_the_content($readmore));
                }else{
                    the_content($readmore);
                }
                wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'manh' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
            } else { ?>
                <p class="excerpt">
                    <?php
                    if ( isset($_POST['numexcerpt']) && $_POST['numexcerpt'] != '' ) {
                        echo esc_html(manh_excerpt( (int)$_POST['numexcerpt'] ));
                    }else{
                        echo esc_html(manh_excerpt( (int)manh_themeoption('excerpt_length', 25) ));
                    } ?>
                </p>
                <?php if ( manh_themeoption('show_morelink', 1) == 1) : ?>
                    <a class="more-link" href="<?php echo get_permalink();?>" title="<?php esc_attr_e('read more', 'manh');?>"><?php esc_html_e('Read more', 'manh');?></a>
                <?php endif; ?>
            <?php 
            }
        } ?>
    </div>
    <?php } ?>
    </div>
		</div>
	</article>
</div>