<article id="post-<?php the_ID(); ?>" <?php post_class('post-list'); ?>>
    <div class="inner-post">
    <?php
    $post_media = false;
    // Post Quote
    if ( get_post_format() == 'quote' && function_exists('rwmb_meta') && rwmb_meta('manh_post_quotecontent') && rwmb_meta('manh_post_quoteauthor') ) :
        $post_media = true;
        $uq  = rand().time();
        ?>
        <div class="part-left media-post">
            <div class="quote-info quote-info-<?php echo esc_attr($uq); ?>">
                <?php if ( rwmb_meta('manh_post_quotecontent') ) : ?>
                <div class="quote-content"><?php echo esc_html(rwmb_meta('manh_post_quotecontent')); ?></div>
                <?php endif; ?>
                 <?php if ( rwmb_meta('manh_post_quoteauthor') ) : ?>
                <div class="quote-author"><?php echo esc_html(rwmb_meta('manh_post_quoteauthor')); ?></div>
                <?php endif; ?>
            </div>
    <?php
    // Post Link
    elseif ( get_post_format() == 'link' && function_exists('rwmb_meta') && rwmb_meta('manh_post_linkurl') ) : 
        $post_media = true;
    ?>  
        <div class="part-left media-post">
            <div class="link-info">
                <a title="<?php echo esc_attr(rwmb_meta('manh_post_linktitle')) ?>" href="<?php echo esc_url( rwmb_meta('manh_post_linkurl') ) ?>"><?php echo esc_html(rwmb_meta('manh_post_linktitle')) ?></a>
            </div>
    <?php
    // Post Video
    elseif ( get_post_format() == 'video' && get_post_meta(get_the_id(), 'manh_post_video', true) ) : 
        $post_media = true;
    ?>
        <div class="part-left media-post">
            <div class="video-thumb video-responsive">
                <?php
                echo rwmb_meta('manh_post_video');
                ?>
            </div>
    <?php
    // Post audio
    elseif ( get_post_format() == 'audio' && get_post_meta(get_the_id(), 'manh_post_audio', true) ) : 
            $post_media = true;
    ?>
        <div class="part-left media-post">
            <div class="audio-thumb audio-responsive">
                <?php
                echo wp_oembed_get(esc_attr(rwmb_meta('manh_post_audio')));
                ?>
            </div>
    <?php
    // Post Gallery
    elseif ( function_exists('rwmb_meta') && rwmb_meta('manh_post_gallery') ) :
        $post_media = true;
    ?>
        <div class="part-left media-post">
            <div class="gallery-thumb">
                <div class="thumb-container owl-carousel">
                <?php
                foreach (rwmb_meta('manh_post_gallery', 'type=image') as $image) { ?>
                    <?php 
                    $src = $image['full_url'];
                    ?>
                   <div class="item"><img alt="<?php echo esc_attr($image['alt']); ?>" src="<?php echo esc_attr($src); ?>"/></div>
                <?php
                }
                ?>
                </div>
            </div>
    <?php
    // Post Image
    elseif ( has_post_thumbnail() ) : $post_media = true; ?>
        <div class="part-left media-post">
            <div class="post-thumb">
                <?php
                $blog_type = manh_themeoption('blog_type');
                ?>
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark">
                <?php
                    the_post_thumbnail();
                ?>
                </a>
            </div>
    <?php
    endif;?>
    <?php if( $post_media ): ?>
    </div><!--end left-->
    <div class="part-right">
    <?php endif; ?>
    <div class="post-info-wrap"> 
        <?php if ( get_the_title() != '' ) : ?>
            <h3 class="post-title">
                <a href="<?php the_permalink(); ?>" title="<?php the_title_attribute(); ?>" rel="bookmark"><?php the_title(); ?></a>
            </h3>
        <?php endif;?>
        <div class="post-meta">
            <?php if ( is_sticky() && ! is_paged() && !is_search() ) { ?>
                <span class="sticky-content"><?php echo esc_html__( 'Featured', 'manh' ) ; ?></span>
            <?php
            } ?>
            <?php if(manh_themeoption('show_categories', 1) == 1 && get_the_category_list() ): ?>
            <?php 
            $post_categories = get_the_terms( get_the_ID(), 'category' );
            if ( ! empty( $post_categories ) && ! is_wp_error( $post_categories ) ) {
                $cate_name = wp_list_pluck( $post_categories, 'name' );
                $cate_id = wp_list_pluck( $post_categories, 'term_id' );
                $length = count($cate_id);
                echo '<a class="post-cat" href="' . get_category_link($cate_id[0]) . '">' .$cate_name[0] . '</a>';
            }
            ?>
            <?php endif;?>
            <?php if( manh_themeoption('show_author', 1) == 1 ): ?>
            <span class="post-author">
            <?php
            printf( wp_kses(__( '<a class="author-link" href="%s" ref="author">%s</a>', 'manh' ), array(
                            'a' => array(
                                'href' => array(),
                                'class' => array(),
                                'ref' => array()
                            ),
                            ) ), esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ), get_the_author_meta('display_name') ); ?>
            </span>
            <?php endif; ?>
            <?php if( 1 == 0 && ! is_single() && ! post_password_required() && ( comments_open() || get_comments_number() ) ): ?>
                <span class="post-comment-count">
                <?php
                    echo '<span class="comments-link">';
                    comments_popup_link( esc_html__( '0 Comments','manh' ),  esc_html__( '1 Comment','manh' ), '%' . esc_html__(' Comments','manh'));
                    echo '</span>';
                ?>
                </span>
            <?php endif; ?>
            <?php
            // Edit link
            edit_post_link(esc_html__('Edit','manh'), '<span class="edit-post">', '</span>'); ?>
        </div>
        <div class="post-content">
            <?php
            if ( is_search() ) {
                    the_excerpt();
            }else{
                if( empty( $post->post_excerpt ) ) {
                    $readmore = '<span>'.esc_html__('Read More', 'manh').'</span><span class="meta-nav">&#8594;</span>';
                    if ( $post->post_type == 'page' ) {
                        // Trip shortcodes for post type is page on search result page
                        echo strip_shortcodes(get_the_content($readmore));
                    }else{
                        the_content($readmore);
                    }
                    wp_link_pages( array( 'before' => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'manh' ) . '</span>', 'after' => '</div>', 'link_before' => '<span>', 'link_after' => '</span>' ) );
                } else { ?>
                    <p class="excerpt"><?php echo esc_html(manh_excerpt( (int)manh_themeoption('excerpt_length', 45) )); ?></p>
                    <?php if ( manh_themeoption('show_morelink', 1) == 1) : ?>
                        <a class="more-link" href="<?php echo get_permalink();?>" title="<?php esc_attr_e('Read more', 'manh');?>"><?php esc_html_e('read more', 'manh');?></a>
                    <?php endif; ?>
                <?php } 
            }?>
        </div>
    </div>
    <?php if( $post_media ): ?>
    </div>
    <?php endif; ?>
    </div>
</article>