<?php
if(class_exists('WooCommerce')){
    // Single image size
    add_filter( 'woocommerce_get_image_size_single', function( $size ) {
        return array(
            'width' => 545,
            'height' => 692,
            'crop' => 1,
        );
    } );
    // Gallery image size
    add_filter( 'woocommerce_get_image_size_gallery_thumbnail', function( $size ) {
        return array(
            'width' => 128,
            'height' => 162,
            'crop' => 1,
        );
    } );

    // Remove each woo style one by one
    add_filter( 'woocommerce_enqueue_styles', 'manh_dequeue_woostyles' );
    function manh_dequeue_woostyles( $enqueue_styles ) {
        unset( $enqueue_styles['woocommerce-general'] );    // Remove the gloss
        unset( $enqueue_styles['woocommerce-layout'] );     // Remove the layout
        unset( $enqueue_styles['woocommerce-smallscreen'] );    // Remove the smallscreen optimisation
        return $enqueue_styles;
    }
    /*
     * Archive Product
     */
    remove_action( 'woocommerce_before_main_content', 'woocommerce_output_content_wrapper', 10 );
    remove_action( 'woocommerce_before_main_content', 'woocommerce_breadcrumb', 20 );
    remove_action( 'woocommerce_after_main_content', 'woocommerce_output_content_wrapper_end', 10 );
    add_action( 'woocommerce_before_main_content', 'manh_archive_wrapper_start', 10 );
    add_action( 'woocommerce_after_main_content', 'manh_archive_wrapper_end', 10 );
    
    function manh_archive_wrapper_start() {
        if ( is_shop() || is_product_category() || is_product_tag() ) {
            wp_enqueue_script('isotope');
            echo '<div class="listing-product-main"><div class="listing-product-wrap">';
        }
    }
    function manh_archive_wrapper_end() {
        if ( is_shop() || is_product_category() || is_product_tag() ) echo '</div></div>';
    }
    if ( !is_shop() && !is_product_category() && !is_product_tag() && !is_product() ) {
        add_action( 'manh_before_sns_content', 'manh_woo_message', 10 );
        function manh_woo_message(){
            echo '<div class="woo-message wrap"><div class="container"><div class="row">';
            wc_print_notices();
            echo '</div></div></div>';
        }
    }
    add_action( 'woocommerce_before_shop_loop', 'manh_archive_title', 2);
    add_action( 'woocommerce_before_shop_loop', 'manh_archive_begin_toolbar_top', 11);
    add_action( 'woocommerce_before_shop_loop', 'manh_sticky_product_filter_btn', 12 );
    remove_action( 'woocommerce_before_shop_loop', 'woocommerce_result_count', 20 );
    add_action( 'woocommerce_before_shop_loop', 'manh_number_cols_display', 13 );
    add_action( 'woocommerce_before_shop_loop', 'manh_archive_end_toolbar', 41);
    add_action( 'woocommerce_after_shop_loop', 'manh_archive_begin_toolbar_bottom', 1);
    remove_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 10 );
    add_action( 'woocommerce_after_shop_loop', 'woocommerce_result_count', 2 );
    add_action( 'woocommerce_after_shop_loop', 'woocommerce_pagination', 3 );
    add_action( 'woocommerce_after_shop_loop', 'manh_archive_end_toolbar', 31);
    
    // Set modeview
    add_action( 'wp_ajax_sns_setgridcols','manh_set_gridcols' );
    add_action( 'wp_ajax_nopriv_sns_setgridcols', 'manh_set_gridcols' );
    function manh_set_gridcols(){
        setcookie('sns_woo_gridcols', $_POST['gridcols'] , time()+3600*24*100, '/');
    }
    function manh_sticky_product_filter_btn(){
        if ( manh_woo_cat_option('woo_stickypfilter') == true && is_active_sidebar('woo-sidebar-sticky') ){
            echo '<div class="sticky-filter-btn"><span>'.esc_html__('Filter', 'manh').'</span></div>';
        }
    }
    add_action( 'wp_footer', 'manh_sticky_product_filter');
    function manh_sticky_product_filter(){
        if ( manh_woo_cat_option('woo_stickypfilter') == true && is_active_sidebar('woo-sidebar-sticky') ){
            echo '<div class="sticky-product-filter"><div class="inner">';
                dynamic_sidebar('woo-sidebar-sticky');
            echo '</div><span class="overlay"></span></div>';
        }
    }
    function manh_archive_title(){
        if ( manh_getoption('showbreadcrump', '1') != '1' ) manh_pagetitle();
    }
    function manh_archive_begin_toolbar_top(){
        echo '<div class="toolbar toolbar-top">';
    }
    function manh_archive_begin_toolbar_bottom(){
        echo '<div class="toolbar toolbar-bottom">';
    }
    function manh_archive_end_toolbar(){
        echo '</div>';
    }
    function manh_number_cols_display(){
        if ( is_product_category() ) {
            $number_cols = trim( manh_woo_cat_option('woo_value_number_cols', '2/3/4') );
        }else{
            $number_cols = trim( manh_getoption('woo_value_number_cols', '2/3/4') );
        }
        $number_cols = explode( '/', $number_cols );
        if ( is_array($number_cols) && count($number_cols) > 0 ) { 
            echo '<div class="set-cols-number">';
            echo '<div class="label-cols">'.esc_html__("Show grid:", "manh").'</div>';
            $i = 0;
            foreach ( $number_cols as $number ) {
                $i ++;
                if ( $i == 1) {
                    $class = ' first';
                }elseif( $i == count($number_cols) ) {
                    $class = ' last';
                }else{
                    $class = '';
                }
                echo '<div class="btn-col'.esc_attr($class).'" data-number="'.esc_attr($number).'">'.esc_html($number).'</div>';
            }
            echo '</div>';
        }
    }
    // Slideshow
    add_action( 'manh_before_sns_content', 'manh_woo_cat_slider', 1 );
    function manh_woo_cat_slider(){
        $cat_slideshow = '';
        if ( is_product_category() ) {
            $cat_slideshow = manh_woo_cat_option( 'product_cat_slideshow' );
        } elseif ( is_shop() ) {
            $cat_slideshow = manh_getoption('revolutionslider');
        }
        if( !empty($cat_slideshow) ) { ?>
            <div class="cat-slideshow wrap">
                <?php echo do_shortcode('[rev_slider '.esc_attr($cat_slideshow).' ]'); ?>
            </div>
        <?php
        }
    }
    // Sub cats
    add_action( 'woocommerce_before_main_content', 'manh_archive_subcategories', 2);
    function manh_archive_subcategories(){
        $display_type = woocommerce_get_loop_display_mode();
        if ( 'subcategories' === $display_type || 'both' === $display_type ) { ?>
            <ul class="sub-cats">
            <?php
            woocommerce_output_product_categories( array(
                'parent_id' => is_product_category() ? get_queried_object_id() : 0,
            ) );
            ?>
            </ul>
            <?php
        }
    }
    // Number product per page
    add_filter( 'loop_shop_per_page', 'manh_woo_shop_perpage' );
    function manh_woo_shop_perpage() {
        global $manh_opt;
        if(is_product_category()){
            $manh_number_perpage = manh_woo_cat_option( 'number_perpage' );
            if( $manh_number_perpage != '' )
                return $manh_number_perpage;
        }
        if ( isset( $manh_opt['woo_number_perpage'] ) ) {
            return $manh_opt['woo_number_perpage'];
        }else{
            return wc_get_default_products_per_row() * wc_get_default_product_rows_per_page();
        }
    }
    // Show minicart on Cart page, Checkout page
    add_filter('woocommerce_widget_cart_is_hidden', 'sns_show_cart_on_checkout');
    function sns_show_cart_on_checkout(){
        if( is_cart() || is_checkout() ) {
            return false;
        }
    }
    // Added to cart message popup
    function sns_added_cart_popup_message(){
        if ( get_option('woocommerce_enable_ajax_add_to_cart') == 'yes' ) {
            echo '<div id="sns-ajaxcart-popup-message"><div class="inner">'.esc_html__('Product added to cart successfully', 'manh').'</div></div>';
        }
    }
    add_action( 'wp_body_open', 'sns_added_cart_popup_message' );
    //
    remove_action( 'woocommerce_sidebar', 'woocommerce_get_sidebar', 10 );
    remove_action( 'woocommerce_before_shop_loop_item', 'woocommerce_template_loop_product_link_open', 10);
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_product_link_close', 5);
    remove_action( 'woocommerce_after_shop_loop_item', 'woocommerce_template_loop_add_to_cart', 10);
    add_action( 'woocommerce_after_shop_loop_item', 'manh_item_addtocart', 10);
    add_action( 'manh_woo_after_product_image', 'manh_item_wishlist_prdimg', 0);
    add_action( 'woocommerce_after_shop_loop_item', 'manh_item_compare', 12);
    function manh_item_variation_colorthumb(){
        global $product;
        if ( $product->get_type() != 'variable' ) { return; }
        $variations = $product->get_variation_attributes();
        if ( !empty($variations) && !isset($variations['pa_color']) && ( isset($variations['pa_color']) && count($variations['pa_color']) ) <= 0 ) { return; }
        ?>
        <div class="variations-product-wrap">
            <div class="variable-item">
        <?php
        $available_variations = $product->get_available_variations();
        $terms = wc_get_product_terms( $product->get_id(), 'pa_color', array( 'fields' => 'all' ));
        foreach ($terms as $term) {
            foreach ($available_variations as $available_variation) {
                if($term->slug === $available_variation['attributes']["attribute_$term->taxonomy"]){
                    $image_var = get_post_thumbnail_id( $available_variation['variation_id'] ); 
                    $image_src = wp_get_attachment_image_src( $image_var, 'shop_catalog');
                    $image_src = isset($image_src['0']) ? $image_src['0'] : '';
                    if ( rwmb_meta('manh_use_variation_thumb', array(), $product->get_id()) != 1 ) {
                        $color = manh_get_term_byid($term->term_id, 'manh_product_attribute_color', '');
                        ?>
                        <a href="#" class="option color" title="<?php echo esc_attr( $term->name );?>" data-toggle="tooltip" data-original-title="<?php echo esc_attr( $term->name );?>" data-value="<?php echo esc_attr( $term->slug );?>" data-image-src="<?php echo esc_url( $image_src );?>"><span style="background:<?php echo esc_attr( $color );?>"></span></a>
                        <?php
                    }else{  
                        $thumb_src = wp_get_attachment_image_src( $image_var, 'shop_thumbnail');
                        $thumb_src = isset($thumb_src['0']) ? $thumb_src['0'] : '';
                        ?>
                        <a href="#" class="option thumb" title="<?php echo esc_attr( $term->name );?>" data-toggle="tooltip" data-original-title="<?php echo esc_attr( $term->name );?>" data-value="<?php echo esc_attr( $term->slug );?>" data-image-src="<?php echo esc_url( $image_src );?>">
                            <?php echo '<img src="'.esc_url($image_src).'" alt="'.esc_attr($term->name).'"/>'; ?>
                        </a>
                        <?php
                    }
                    break;
                }
            }
        }?>
        </div></div>
        <?php
    }
    function manh_item_addtocart( $args = array() ) {
        global $product;
        if ( $product ) {
            $defaults = array(
                'quantity'   => 1,
                'class'      => implode( ' ', array_filter( array(
                    'button',
                    'product_type_' . $product->get_type(),
                    $product->is_purchasable() && $product->is_in_stock() ? 'add_to_cart_button' : '',
                    $product->supports( 'ajax_add_to_cart' ) ? 'ajax_add_to_cart' : '',
                ) ) ),
                'attributes' => array(
                    'data-product_id'  => $product->get_id(),
                    'data-product_sku' => $product->get_sku(),
                    'aria-label'       => $product->add_to_cart_description(),
                    'rel'              => 'nofollow',
                ),
            );
            $args = apply_filters( 'woocommerce_loop_add_to_cart_args', wp_parse_args( $args, $defaults ), $product );
            ?>
            <div class="cart-wrap">
            <?php 
            wc_get_template( 'loop/add-to-cart.php', $args );
            ?>
            </div>
            <?php
        }
    }
    function manh_item_readmore(){
        global $product;
        if ( $product ) {
            echo '<a class="button btn-readmore" href="'.get_the_permalink().'" title="'.the_title_attribute( 'echo=0' ).'">' . esc_html__('View detail', 'manh') . '</a>';
        }
        return;
    }

    if( class_exists( 'YITH_WCWL' ) ) {
        add_filter( 'yith_wcwl_is_wishlist_responsive', '__return_false' );
        add_filter( 'yith_wcwl_localize_script', function($localize) {
            $localize['actions']['load_mobile_action'] = 'no-mob-ver';
            return $localize;
        } );
        add_filter( 'yith_wcwl_template_part_hierarchy', function($data) {
            foreach($data as $k => $v) $data[$k] = str_replace('-mobile.php', '.php', $v);
            return $data;
        } );
    }
    function manh_item_wishlist_prdimg(){
        if( class_exists( 'YITH_WCWL' ) ) {
            echo '<div class="wl-prdimg">' . do_shortcode( '[yith_wcwl_add_to_wishlist icon=""]' ) . '</div>';
        }
    }
    function manh_item_wishlist(){
        if( class_exists( 'YITH_WCWL' ) ) {
            echo do_shortcode( '[yith_wcwl_add_to_wishlist icon=""]' );
        }
    }
    function manh_item_wishlist2(){
        if( class_exists( 'YITH_WCWL' ) ) {
            apply_filters( 'yith_wcwl_button_label', 'ABC' );
            echo do_shortcode( '[yith_wcwl_add_to_wishlist icon=""]' );
        }
    }
    function manh_item_wishlist3(){
        if( class_exists( 'YITH_WCWL' ) ) {
            apply_filters( 'yith_wcwl_button_label', 'ABC' );
            echo '<div class="i-action wishlist">'.do_shortcode( '[yith_wcwl_add_to_wishlist icon=""]' ).'</div>';
        }
    }
    function manh_item_wishlist_button(){
        global $product;
        if( class_exists( 'YITH_WCWL' ) ) { ?>
            <a href="<?php echo esc_url( add_query_arg( 'add_to_wishlist', $product->get_id() ) )?>" rel="nofollow" data-product-id="<?php echo esc_attr($product->get_id()); ?>" data-product-type="<?php echo esc_attr($product->get_type()); ?>">
                <?php echo esc_html__("Wishlist", "manh"); ?>
            </a>
            <?php
        }
    }
    
    function manh_item_compare(){
        global $product;
        if( class_exists( 'YITH_Woocompare' ) ) {
            $action_add = 'yith-woocompare-add-product';
            $url_args = array(
                'action' => $action_add,
                'id' => $product->get_id()
            );
            ?>
            <a href="<?php echo esc_url( wp_nonce_url( add_query_arg( $url_args ), $action_add ) ); ?>" class="compare btn btn-primary-outline" data-product_id="<?php echo esc_attr( $product->get_id() ); ?>">
            <?php echo esc_html__( 'Compare', 'manh' ); ?>
            </a>
            <?php
        }
    }
    function manh_item_compare2(){
        global $product;
        if( class_exists( 'YITH_Woocompare' ) ) {
            $action_add = 'yith-woocompare-add-product';
            $url_args = array(
                'action' => $action_add,
                'id' => $product->get_id()
            );
            ?>
            <div class="i-action">
            <a href="<?php echo esc_url( wp_nonce_url( add_query_arg( $url_args ), $action_add ) ); ?>" class="compare btn btn-primary-outline" data-product_id="<?php echo esc_attr( $product->get_id() ); ?>">
            <?php echo esc_html__( 'Compare', 'manh' ); ?>
            </a>
            </div>
            <?php
        }
    }
    /** 
     *  Quick view for product list style
     **/
    function manh_quickview_liststyle(){
        if ( !class_exists('YITH_WCQV_Frontend') ) return;
        global $product;
        $product_id = 0;
        // get product id
        ! $product_id && $product_id = yit_get_prop( $product, 'id', true );
        $button = '<a href="#" class="button yith-wcqv-button" data-product_id="' . esc_attr($product_id) . '">'.esc_html__('Quick view', 'manh').'</a>';
        echo apply_filters( 'yith_add_quick_view_button_html', $button, esc_html__('Quick view', 'manh'), $product );
    }
    function manh_quickview_liststyle2(){
        if ( !class_exists('YITH_WCQV_Frontend') ) return;
        global $product;
        $product_id = 0;
        // get product id
        ! $product_id && $product_id = yit_get_prop( $product, 'id', true );
        $button = '<div class="i-action visible-lg visible-md"><a href="#" class="button yith-wcqv-button" data-product_id="' . esc_attr($product_id) . '">'.esc_html__('Quick view', 'manh').'</a></div>';
        echo apply_filters( 'yith_add_quick_view_button_html', $button, esc_html__('Quick view', 'manh'), $product );
    }
    remove_action( 'yith_wcqv_product_summary', 'woocommerce_template_single_meta', 30 );
    // Override thumbnail
    function manh_post_thumbnail_html($html, $post_id, $post_thumbnail_id, $size, $attr) {
        if( manh_themeoption('woo_uselazyload', 0) == 1 || ( isset($attr['class']) && strpos($attr['class'], 'use-zoom') !== false ) ){
            $id = get_post_thumbnail_id(); 
            if ( !$id ) return $html;
            $src = wp_get_attachment_image_src($id, $size);
            $alt = the_title_attribute( 'echo=0' );
            $class = ( isset($attr['class']) ) ? $attr['class'] : '';
            $img_new = '<img alt="'.esc_attr($alt).'" class="' . esc_attr($class) . '"';
            if (strpos($class, 'lazy') !== false) {
                $img_new .= ' data-original="' . esc_url($src[0]) . '"';
                if ( strpos($class, 'attachment-shop_single') !== false) {
                    $img_new .= ' src="'.MANH_THEME_URI.'/assets/img/prod_loading_3.gif"';
                } else {
                    $img_new .= ' src="'.MANH_THEME_URI.'/assets/img/prod_loading.gif"';
                }
            }else{
                $img_new .= ' src="' . esc_url($src[0]) . '"';
            }
            if (strpos($class, 'use-zoom') !== false) {
                $src_full = wp_get_attachment_image_src($id, 'full');
                $img_new .= ' data-zoom-image="'. esc_url($src_full[0]) .'"';
            }
            $img_new .= '/>';
            return $img_new;
        }
        return $html;
    }
    add_action('woocommerce_single_product_summary', 'manh_extra_info', 25);
    function manh_extra_info(){
        if ( is_product() && manh_metabox('extra_info') != '' ) { 
            $extra_info = new WP_Query(array( 'name' => manh_metabox('extra_info'), 'post_type' => 'post-wcode' ));
            if ($extra_info->have_posts()) {
                echo do_shortcode('[manh_postwcode name="'.manh_metabox('extra_info').'"]');
            }
            wp_reset_postdata();
        }
    }
    remove_action('woocommerce_before_shop_loop_item_title', 'woocommerce_template_loop_product_thumbnail', 10);
    add_action( 'woocommerce_before_shop_loop_item_title', 'manh_product_thumbnail', 11 );
    add_action( 'manh_grid4_before_shop_loop_item_title', 'manh_product_thumbnail_grid1', 11 );
    add_filter('post_thumbnail_html', 'manh_post_thumbnail_html', 99, 5);
    function manh_product_thumbnail_grid1(){
        global $post;
        $size = 'shop_catalog';
        $class = 'attachment-shop_catalog use-zoom';
        if ( has_post_thumbnail() ) {
            if( manh_themeoption('woo_uselazyload', 0) == 1 ){
                $class .= ' lazy';
                echo get_the_post_thumbnail( $post->ID, $size, array('class' => $class) );
            }else{
                echo get_the_post_thumbnail( $post->ID, $size, array('class' => $class) );
            }
        } elseif ( wc_placeholder_img_src() ) {
            echo wc_placeholder_img( $size );
        }
    }
    function manh_product_thumbnail(){
        global $post;
        $size = 'shop_catalog';
        $class = 'attachment-shop_catalog';
        if ( has_post_thumbnail() ) {
            if( manh_themeoption('woo_uselazyload', 0) == 1 ){
                $class .= ' lazy';
                echo get_the_post_thumbnail( $post->ID, $size, array('class' => $class) );
            }else{
                echo get_the_post_thumbnail( $post->ID, $size );
            }
        } elseif ( wc_placeholder_img_src() ) {
            echo wc_placeholder_img( $size );
        }
    }
    function manh_product_370_thumbnail(){
        global $post;
        $size = 'manh_woo_370370_thumb';
        $class = 'attachment-shop_catalog';
        if ( has_post_thumbnail() ) {
            if( manh_themeoption('woo_uselazyload', 0) == 1 ){
                $class .= ' lazy';
                echo get_the_post_thumbnail( $post->ID, $size, array('class' => $class) );
            }else{
                echo get_the_post_thumbnail( $post->ID, $size );
            }
        } elseif ( wc_placeholder_img_src() ) {
            echo wc_placeholder_img( $size );
        }
    }
    function manh_single_product_thumbnail(){
        global $post;
        $size = 'shop_single';
        if ( has_post_thumbnail() ) {
            if( manh_themeoption('woo_uselazyload', 0) == 1 ){
                echo get_the_post_thumbnail( $post->ID, $size, array('class' => "lazy attachment-shop_single") );
            }else{
                echo get_the_post_thumbnail( $post->ID, $size );
            }
        } elseif ( wc_placeholder_img_src() ) {
            echo wc_placeholder_img( $size );
        }
    }
    function manh_display_gallery_product(){
        global $product; 
        $size = 'manh_woo_370370_thumb';
        $main_thumb_id = get_post_thumbnail_id();
        $main_datasrc = wp_get_attachment_image_src( $main_thumb_id, $size );
        $main_src = wp_get_attachment_image_src( $main_thumb_id, 'manh_woo_370370_thumb' );
        echo '<div class="gallery-product">';
        woocommerce_show_product_loop_sale_flash();
        echo '<div class="owl-carousel">';
        echo '<div class="item"><img src="'.$main_src['0'].'" data-src="'.$main_datasrc['0'].'" alt="'.$product->get_title().'"/></div>';
        $gallery_ids = $product->get_gallery_image_ids();
        if ( $gallery_ids && has_post_thumbnail() ) {
            foreach ( $gallery_ids as $gallery_id ) {
                $gallery_datasrc = wp_get_attachment_image_src( $gallery_id, $size );
                $gallery_src = wp_get_attachment_image_src( $gallery_id, 'manh_woo_370370_thumb' );
                if ( $gallery_datasrc['0'] ){
                    echo '<div class="item"><img src="'.$gallery_src['0'].'" data-src="'.$gallery_datasrc['0'].'" alt="'.$product->get_title().'"/></div>';
                }
            }
        }
        echo '</div></div>';
    }
    add_action('woocommerce_single_product_summary', 'manh_woo_single_countdown', 15);
    function manh_woo_single_countdown () {
        global $post, $product;
        // Get the Sale Price Date To of the product
        $sale_price_dates_to = ( $date = get_post_meta( $post->ID, '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
        if(!empty($sale_price_dates_to)):
            // Set sale price date to default 10 days for http://demo.snstheme.com/
            if( strpos(site_url(), 'demo.snstheme.com') || strpos(site_url(), 'dev.snsgroup.me') ){
                if($sale_price_dates_to == 0) $sale_price_dates_to = date('Y/m/d', strtotime('+10 days'));
            }
            wp_enqueue_script('jquery-countdown');
            $uq = rand().time();
            ?>
            <div class="time-cdown-wrap">
                <span class="label"><?php echo esc_html__('Time left:', 'manh'); ?></span>
                <div class="time-count-down" id="sns-tcd-<?php echo esc_attr($uq); ?>" data-date="<?php echo esc_attr($sale_price_dates_to); ?>">
                    <div class="clock-digi">
                        <div><div><div class="day"></div><?php esc_html_e('Days', 'manh');?></div></div>
                        <div><div><div class="hours"></div><?php esc_html_e('Hours', 'manh');?></div></div>
                        <div><div><div class="minutes"></div><?php esc_html_e('Mins', 'manh');?></div></div>
                        <div><div><div class="seconds"></div><?php esc_html_e('Secs', 'manh');?></div></div>
                    </div>
                </div>
            </div>
        <?php endif;
    }
    function manh_woo_special_countdown () {
        global $post, $product;
        // Get the Sale Price Date To of the product
        $sale_price_dates_to = ( $date = get_post_meta( $post->ID, '_sale_price_dates_to', true ) ) ? date_i18n( 'Y/m/d', $date ) : '';
            // Set sale price date to default 23 hours
            if( strpos(site_url(), 'demo.snstheme.com') || strpos(site_url(), 'dev.snsgroup.me') ){
                if($sale_price_dates_to == 0 || $sale_price_dates_to <= date('Y/m/d') ) $sale_price_dates_to = date('Y/m/d', strtotime('+10 days'));
            }
            wp_enqueue_script('jquery-countdown');
            $uq = rand().time();
            ?>
            <div class="time-cdown-wrap second-font">
                <span class="label-cd"><?php echo esc_html__('End In:', 'manh'); ?></span>
                <div class="time-count-down" id="sns-tcd-<?php echo esc_attr($uq); ?>" data-date="<?php echo esc_attr($sale_price_dates_to); ?>">
                    <div class="clock-digi">
                        <div><div><div class="day second-font"></div><?php esc_html_e('Days', 'manh');?></div></div>
                        <div><div><div class="hours second-font"></div><?php esc_html_e('Hours', 'manh');?></div></div>
                        <div><div><div class="minutes second-font"></div><?php esc_html_e('Minutes', 'manh');?></div></div>
                        <div><div><div class="seconds second-font"></div><?php esc_html_e('Seconds', 'manh');?></div></div>
                    </div>
                </div>
            </div>
        <?php
    }
    function manh_special_sold_bar(){
        global $product;
        ?>
        <div class="sold-bar">
            <div class="the-bar">
                <?php $precent = ( $product->get_total_sales() < $product->get_stock_quantity() ) ? ($product->get_total_sales()/$product->get_stock_quantity())*100 : '0'; ?>
                <span data-width="<?php echo esc_attr($precent); ?>%"></span>
            </div>
            <div class="num-sold">
                <?php 
                $sold = $product->get_total_sales() ;
                echo esc_html__('Sold: ', 'manh') . $sold;
                if ( $sold > 1) {
                    echo ' '.esc_html__('items', 'manh');
                } else {
                    echo ' '.esc_html__('item', 'manh');
                }?>
            </div>
            <div class="num-stock">
                <?php 
                $stock = $product->get_stock_quantity() ; 
                echo esc_html__('Available: ', 'manh') . $stock;
                if ( $stock > 1) {
                    echo ' '.esc_html__('items', 'manh');
                } else {
                    echo ' '.esc_html__('item', 'manh');
                }?>
            </div>
        </div>
        <?php
    }
    function manh_discount_percent(){
        global $product;
        if ( $product->get_sale_price() ) {
            echo '<span class="badge-discount-percent">-' . round ( ( ( $product->get_regular_price() - $product->get_sale_price() ) * 100 ) / $product->get_regular_price() ) . '%</span>';
        }
    }
    function manh_woo_cat_links(){
        global $product;
        echo wc_get_product_category_list( $product->get_id(), ', ', '<div class="cat-links">', '</div>' );
    }
    function manh_woo_query($type, $post_per_page=-1, $cat='', $offset=0, $paged=1){
        global $woocommerce;
        $args = array(
            'post_type' => 'product',
            'posts_per_page' => $post_per_page,
            'post_status' => 'publish',
            'offset'            => $offset,
            'paged' => $paged
        );
        switch ($type) {
            case 'best_selling':
                $args['meta_key']='total_sales';
                $args['orderby']='meta_value_num';
                $args['ignore_sticky_posts']   = 1;
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                break;
            case 'featured_product':
                $args['ignore_sticky_posts']=1;
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $args['post__in'] = wc_get_featured_product_ids();
                break;
            case 'top_rate':
                $args['meta_key'] = '_wc_average_rating';
                $args['orderby']  = array(
                    'meta_value_num' => 'DESC',
                    'ID'             => 'ASC',
                );
                break;
            case 'recent':
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                break;
            case 'on_sale':
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $args['post__in'] = wc_get_product_ids_on_sale();
                break;
            case 'hot_deal':
                global $wpdb;
                $query = $wpdb->prepare("
                    SELECT posts.ID, posts.post_parent
                    FROM {$wpdb->prefix}posts posts
                    INNER JOIN {$wpdb->prefix}postmeta ON (posts.ID = {$wpdb->prefix}postmeta.post_id)
                    INNER JOIN {$wpdb->prefix}postmeta AS mt1 ON (posts.ID = mt1.post_id)
                    WHERE
                        posts.post_status = 'publish'
                        AND  (mt1.meta_key = '_sale_price_dates_to' AND mt1.meta_value >= %s) 
                        GROUP BY posts.ID 
                        ORDER BY %s", time(), "ASC");
                $product_ids_raw = $wpdb->get_results($query);
                $product_ids_hotdeal = array();
                foreach ( $product_ids_raw as $product_raw ) {
                    if(!empty($product_raw->post_parent)){
                        $product_ids_hotdeal[] = $product_raw->post_parent;
                    }else{
                        $product_ids_hotdeal[] = $product_raw->ID;  
                    }
                }
                $product_ids_hotdeal = array_unique($product_ids_hotdeal);
                if ( is_array($product_ids_hotdeal) && count($product_ids_hotdeal) == 0 ) {
                    $product_ids_hotdeal = wc_get_product_ids_on_sale(); 
                }
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $args['post__in'] = $product_ids_hotdeal;
                break;
            case 'recent_review':
                if($post_per_page == -1) $_limit = 4;
                else $_limit = $post_per_page;
                global $wpdb;
                $query = $wpdb->prepare( "
                    SELECT c.comment_post_ID 
                    FROM {$wpdb->prefix}posts p, {$wpdb->prefix}comments c 
                    WHERE p.ID = c.comment_post_ID AND c.comment_approved > %d 
                    AND p.post_type = %s AND p.post_status = %s
                    AND p.comment_count > %d ORDER BY c.comment_date ASC" ,
                    0, 'product', 'publish', 0 );
                $results = $wpdb->get_results($query, OBJECT);
                $_pids = array();
                foreach ($results as $re) {
                    if(!in_array($re->comment_post_ID, $_pids))
                        $_pids[] = $re->comment_post_ID;
                    if(count($_pids) == $_limit)
                        break;
                }
                $args['meta_query'] = array();
                $args['meta_query'][] = $woocommerce->query->stock_status_meta_query();
                $args['meta_query'][] = $woocommerce->query->visibility_meta_query();
                $args['post__in'] = $_pids;
                break;
        }
        if($cat!=''){
            $args['product_cat']= $cat;
        }
        return new WP_Query($args);
    }
    /*
     * Single Product
     */
    // Entry img
    add_filter( 'woocommerce_review_gravatar_size', function() { return '80'; } );
    // Update WooCommerce Flexslider options
    add_filter( 'woocommerce_single_product_carousel_options', 'ud_update_woo_flexslider_options' );
    function ud_update_woo_flexslider_options( $options ) {
        $options['directionNav'] = true;
        return $options;
    }
    // Share box in product page
    if ( manh_themeoption('woo_sharebox') == 1 ) {
        add_action('woocommerce_share', 'manh_sharebox', 22);
    }
    // Rename product tab
    function manh_woo_rename_tabs( $tabs ) {
        if ( isset($tabs['description']) ) {
            $tabs['description']['title'] = esc_html__( 'Description', 'manh' );
        }
        if ( isset($tabs['additional_information']) ) {
            $tabs['additional_information']['title'] = esc_html__( 'Additional','manh' );   // Rename the additional information tab
        }
        return $tabs;
    }
    // Add clear for product summary
    add_action( 'woocommerce_single_product_summary', 'manh_woo_addclear', 35 );
    function manh_woo_addclear() {
        echo '<div class="clear"></div>';
    }
    // Cross sells
    add_filter( 'woocommerce_cross_sells_total', 'limit_woocommerce_cross_sells_total' );
    function limit_woocommerce_cross_sells_total() {
        return 6;
    }
    // Re-render rating
    function manh_get_rating_html(){
        global $woocommerce, $product;
        if( $product && $product->get_average_rating() ) $rating = $product->get_average_rating();
        if( isset($rating) && $rating > 0){
            $rating_html  = '<div class="star-rating" title="' . sprintf( __( 'Rated %s out of 5', 'manh' ), $rating ) . '">';
            $rating_html .= '<span class="value" data-width="' . ( ( $rating / 5 ) * 100 ) . '%"><strong class="rating">' . $rating . '</strong> ' . esc_html__( 'out of 5', 'manh' ) . '</span>';
        }else{
            $rating_html  = '<div class="star-rating">';
        }
        $rating_html .= '</div>';
        return $rating_html;
    }
    function manh_woo_product_list_title() {
        echo '<div class="item-title woocommerce-loop-product__title"><a href="'.get_the_permalink().'" title="'.the_title_attribute( 'echo=0' ).'">' . manh_limitcharacter( get_the_title(), 30) . '</a></div>';
    }
    // Override product title
    function woocommerce_template_loop_product_title() {
        echo '<div class="item-title woocommerce-loop-product__title"><a href="'.get_the_permalink().'" title="'.the_title_attribute( 'echo=0' ).'">' . get_the_title() . '</a></div>';
    }
    // Class for Woo
	class manh_Woocommerce{
        public $revsliders = array();
		public static function getInstance(){
			static $_instance;
			if( !$_instance ){
				$_instance = new manh_Woocommerce();
			}
			return $_instance;
		}
		public function __construct(){
            global $wpdb;
            $this->revsliders[0] = 'Select a slider';
            if ( class_exists('RevSlider') ) {
                $query = $wpdb->prepare("
                    SELECT * 
                    FROM {$wpdb->prefix}revslider_sliders 
                    ORDER BY %s"
                    , "ASC");
                $get_sliders = $wpdb->get_results($query);
                if($get_sliders) {
                    foreach($get_sliders as $slider) {
                       $this->revsliders[$slider->alias] = $slider->title;
                   }
                }
            }
            // Add Taxonomy product_cat custom meta fields
            add_action('product_cat_add_form_fields', array(&$this, 'manh_product_cat_add_new_meta_field'), 20, 3);
            add_action('product_cat_edit_form_fields', array(&$this, 'manh_product_cat_edit_meta_field'), 20, 3);
            // Save extra taxonomy fields callback function
            add_action( 'edit_term', array(&$this,'manh_save_product_cat_custom_meta'), 10, 3 );
            add_action( 'created_term', array(&$this,'manh_save_product_cat_custom_meta'), 10, 3 );
            // Add Taxonomy product_attributes custom meta fields
            $attribute_taxonomies = wc_get_attribute_taxonomies();
            if ( $attribute_taxonomies ) {
                foreach ( $attribute_taxonomies as $attribute) {
                    add_action( 'pa_' . $attribute->attribute_name . '_add_form_fields', array(&$this, 'manh_product_attribute_add_new_meta_field'), 20, 3 );
                    add_action( 'pa_' . $attribute->attribute_name . '_edit_form_fields', array(&$this, 'manh_product_attribute_edit_meta_field'), 20, 3);
                    add_action( 'pa_' . $attribute->attribute_name . '_edit_form_fields', array(&$this, 'manh_termattr_js'));
                    add_action( 'pa_' . $attribute->attribute_name . '_add_form_fields', array(&$this, 'manh_termattr_js'));
                    add_action( 'edit_term', array(&$this,'manh_product_attribute_save_custom_meta'), 10, 3 );
                    add_action( 'created_term', array(&$this,'manh_product_attribute_save_custom_meta'), 10, 3 );
                }
            }
		}
        // Add term page
        public function manh_product_cat_add_new_meta_field(){
            // This will add the custom meta field  to the add new term page
            $revsliders = $this->revsliders;
            ?>
            <div class="form-field term-manh_woo_stickypfilter">
                <label for="manh_woo_stickypfilter"><?php esc_html_e( "Sticky product filter in left", 'manh' ); ?></label>
                <select name="manh_woo_stickypfilter" id="manh_woo_stickypfilter">
                    <option value=""><?php esc_html_e('Default', 'manh');?></option>
                    <option value="1"><?php esc_html_e('Yes', 'manh');?></option>
                    <option value="0"><?php esc_html_e('No', 'manh');?></option>
                </select>
            </div>
            <div class="form-field term-manh_showbreadcrump">
                <label for="manh_showbreadcrump"><?php esc_html_e( "Show Breadcrumbs?", 'manh' ); ?></label>
                <select name="manh_showbreadcrump" id="manh_showbreadcrump">
                    <option value=""><?php esc_html_e('Default', 'manh');?></option>
                    <option value="1"><?php esc_html_e('Yes', 'manh');?></option>
                    <option value="2"><?php esc_html_e('No', 'manh');?></option>
                </select>
            </div>
            <div class="form-field term-manh_product_cat_slideshow">
                <label for="manh_product_cat_slideshow"><?php esc_html_e( 'Slideshow', 'manh' ); ?></label>
                <select name="manh_product_cat_slideshow" id="manh_product_cat_slideshow">
                    <?php
                    foreach ($revsliders as $key => $value):?>
                       <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($value); ?></option>
                    <?php
                    endforeach;
                    ?>
                </select>
                <p class="description"><?php esc_html_e( 'Select Slideshow.','manh' ); ?></p>
            </div>
            <div class="form-field term-manh_content_extrawidth">
                <label for="manh_content_extrawidth"><?php esc_html_e( "Want to use extra width for main content?", 'manh' ); ?></label>
                <select name="manh_content_extrawidth" id="manh_content_extrawidth">
                    <option value="2"><?php esc_html_e('No', 'manh');?></option>
                    <option value="1"><?php esc_html_e('Yes', 'manh');?></option>
                </select>
            </div>
            <div class="form-field term-manh_product_cat_layout">
                <label for="manh_product_cat_layout"><?php esc_html_e( 'Layout', 'manh' ); ?></label>
                <select name="manh_product_cat_layout" id="manh_product_cat_layout">
                    <option value=""><?php esc_html_e('Default (Layout of Shop page)', 'manh');?></option>
                    <option value="m"><?php esc_html_e('Without sidebar', 'manh');?></option>
                    <option value="l-m"><?php esc_html_e('Left Sidebar', 'manh');?></option>
                    <option value="m-r"><?php esc_html_e('Right Sidebar', 'manh');?></option>
                </select>
                <p class="description"><?php esc_html_e( 'Set the layout fullwidth or has sidebar (Woo Sidebar).','manh' ); ?></p>
            </div>
            <div class="form-field term-manh_woo_gridstyle">
                <label for="manh_woo_gridstyle"><?php esc_html_e( 'Grid style', 'manh' ); ?></label>
                <select name="manh_woo_gridstyle" id="manh_woo_gridstyle">
                    <option value=""><?php esc_html_e('Default', 'manh');?></option>
                    <option value="1"><?php esc_html_e('Style 1', 'manh');?></option>
                    <option value="2"><?php esc_html_e('Style 2', 'manh');?></option>
                    <option value="3"><?php esc_html_e('Style 3', 'manh');?></option>
                    <option value="4"><?php esc_html_e('Style 4', 'manh');?></option>
                </select>
            </div>
            <div class="form-field term-manh_woo_grid_col">
                <label for="manh_woo_grid_col"><?php esc_html_e( 'Grid columns', 'manh' ); ?></label>
                <select name="manh_woo_grid_col" id="manh_woo_grid_col">
                    <option value=""><?php esc_html_e('Default', 'manh');?></option>
                    <option value="1"><?php esc_html_e('1', 'manh');?></option>
                    <option value="1"><?php esc_html_e('2', 'manh');?></option>
                    <option value="1"><?php esc_html_e('3', 'manh');?></option>
                    <option value="1"><?php esc_html_e('4', 'manh');?></option>
                    <option value="1"><?php esc_html_e('6', 'manh');?></option>
                </select>
                <p class="description"><?php esc_html_e( 'We are using grid bootstap - 12 cols layout. Default use in Theme Options.','manh' ); ?></p>
            </div>
            <div class="form-field term-manh_woo_value_number_cols">
                <label for="manh_woo_value_number_cols"><?php esc_html_e( 'The numbers value columns', 'manh' ); ?></label>
                <input name="manh_woo_value_number_cols" id="manh_woo_value_number_cols" type="text" value="2/3/4" size="40">
                <p class="description"><?php esc_html_e( 'The numbers value to set product columns per row. Ex: 2/3/4/5','manh' ); ?></p>
            </div>
            <div class="form-field term-manh_number_perpage">
                <label for="manh_number_perpage"><?php esc_html_e( 'Number products per listing page', 'manh' ); ?></label>
                <input name="manh_number_perpage" id="manh_number_perpage" type="text" value="12" size="40">
            </div>
            <?php
        }
        // Edit term page
        public function manh_product_cat_edit_meta_field($term, $taxonomy){
            $revsliders = $this->revsliders;
            $manh_woo_stickypfilter = manh_get_term_byid($term->term_id, 'manh_woo_stickypfilter', '');
            $manh_showbreadcrump = manh_get_term_byid($term->term_id, 'manh_showbreadcrump', ''); 
            $manh_product_cat_slideshow = manh_get_term_byid($term->term_id, 'manh_product_cat_slideshow', '');
            $manh_content_extrawidth = manh_get_term_byid($term->term_id, 'manh_content_extrawidth', '' );
            $manh_product_cat_layout = manh_get_term_byid($term->term_id, 'manh_product_cat_layout', '' );
            $manh_woo_gridstyle = manh_get_term_byid($term->term_id, 'manh_woo_gridstyle', '' );
            $manh_woo_grid_col = manh_get_term_byid($term->term_id, 'manh_woo_grid_col', '' );
            $manh_woo_value_number_cols = manh_get_term_byid($term->term_id, 'manh_woo_value_number_cols', '' );
            $manh_number_perpage = manh_get_term_byid($term->term_id, 'manh_number_perpage', '' );
            ?>
            <tr class="form-field term-manh_woo_stickypfilter">
                <th scope="row"><label for="manh_woo_stickypfilter"><?php esc_html_e( "Sticky product filter in left", 'manh' ); ?></label></th>
                <td>
                    <select name="manh_woo_stickypfilter" id="manh_woo_stickypfilter">
                        <option value="" <?php selected($manh_woo_stickypfilter, '', true)?>><?php esc_html_e('Default', 'manh');?></option>
                        <option value="1" <?php selected($manh_woo_stickypfilter, '1', true)?>><?php esc_html_e('Yes', 'manh');?></option>
                        <option value="0" <?php selected($manh_woo_stickypfilter, '0', true)?>><?php esc_html_e('No', 'manh');?></option>
                    </select>
                </td>
            </tr>
            <tr class="form-field term-manh_showbreadcrump">
                <th><label for="manh_showbreadcrump"><?php esc_html_e( "Show Breadcrumbs?", 'manh' ); ?></label></th>
                <td>
                    <select name="manh_showbreadcrump" id="manh_showbreadcrump">
                        <option value="" <?php selected($manh_showbreadcrump, '', true)?>><?php esc_html_e('Default', 'manh');?></option>
                        <option value="1" <?php selected($manh_showbreadcrump, '1', true)?>><?php esc_html_e('Yes', 'manh');?></option>
                        <option value="2" <?php selected($manh_showbreadcrump, '2', true)?>><?php esc_html_e('No', 'manh');?></option>
                    </select>
                </td>
            </tr>
            <tr class="form-field manh_product_cat_slideshow">
                <th scope="row"><label for="manh_product_cat_slideshow"><?php esc_html_e( 'Slideshow', 'manh' ); ?></label></th>
                <td>
                    <select name="manh_product_cat_slideshow" id="manh_product_cat_slideshow">
                        <?php
                        foreach ($revsliders as $key => $value):?>
                           <option value="<?php echo esc_attr($key); ?>" <?php selected($manh_product_cat_slideshow, $key, true)?>><?php echo esc_html($value); ?></option>
                        <?php
                        endforeach;
                        ?>
                    </select>
                    <p class="description"><?php esc_html_e( 'Select Slideshow.','manh' ); ?></p>
                </td>
            </tr>
            <tr class="form-field term-manh_content_extrawidth">
                <th scope="row"><label for="manh_content_extrawidth"><?php esc_html_e( "Want to use extra width for main content?", 'manh' ); ?></label></th>
                <td>
                    <select name="manh_content_extrawidth" id="manh_content_extrawidth">
                        <option value="0" <?php selected($manh_content_extrawidth, '2', true)?>><?php esc_html_e('No', 'manh');?></option>
                        <option value="1" <?php selected($manh_content_extrawidth, '1', true)?>><?php esc_html_e('Yes', 'manh');?></option>
                    </select>
                </td>
            </tr>
            <tr class="form-field manh_product_cat_layout">
                <th scope="row"><label for="manh_product_cat_layout"><?php esc_html_e( 'Layout', 'manh' ); ?></label></th>
                <td>
                    <select name="manh_product_cat_layout" id="manh_product_cat_layout">
                        <option value="" <?php selected($manh_product_cat_layout, '', true)?>><?php esc_html_e('Default (Layout of Shop page)', 'manh');?></option>
                        <option value="m" <?php selected($manh_product_cat_layout, 'm', true)?>><?php esc_html_e('Without sidebar', 'manh');?></option>
                        <option value="l-m" <?php selected($manh_product_cat_layout, 'l-m', true)?>><?php esc_html_e('Left Sidebar', 'manh');?></option>
                        <option value="m-r" <?php selected($manh_product_cat_layout, 'm-r', true)?>><?php esc_html_e('Right Sidebar', 'manh');?></option>
                    </select>
                    
                    <p class="description"><?php esc_html_e( 'Set the layout is without sidebar or has sidebar (Woo Sidebar).','manh' ); ?></p>
                </td>
            </tr>
            <tr class="form-field manh_woo_gridstyle">
                <th scope="row"><label for="manh_woo_gridstyle"><?php esc_html_e( 'Grid style', 'manh' ); ?></label></th>
                <td>
                    <select name="manh_woo_gridstyle" id="manh_woo_gridstyle">
                        <option value="" <?php selected($manh_woo_gridstyle, '', true)?>><?php esc_html_e('Default', 'manh');?></option>
                        <option value="1" <?php selected($manh_woo_gridstyle, '1', true)?>><?php esc_html_e('Style 1', 'manh');?></option>
                    </select>
                </td>
            </tr>
            <tr class="form-field manh_woo_grid_col">
                <th scope="row"><label for="manh_woo_grid_col"><?php esc_html_e( 'Grid columns', 'manh' ); ?></label></th>
                <td>
                    <select name="manh_woo_grid_col" id="manh_woo_grid_col">
                        <option value="" <?php selected($manh_woo_grid_col, '', true)?>><?php esc_html_e('Default', 'manh');?></option>
                        <option value="1" <?php selected($manh_woo_grid_col, '1', true)?>><?php esc_html_e('1', 'manh');?></option>
                        <option value="2" <?php selected($manh_woo_grid_col, '2', true)?>><?php esc_html_e('2', 'manh');?></option>
                        <option value="3" <?php selected($manh_woo_grid_col, '3', true)?>><?php esc_html_e('3', 'manh');?></option>
                        <option value="4" <?php selected($manh_woo_grid_col, '4', true)?>><?php esc_html_e('4', 'manh');?></option>
                        <option value="5" <?php selected($manh_woo_grid_col, '5', true)?>><?php esc_html_e('5', 'manh');?></option>
                        <option value="6" <?php selected($manh_woo_grid_col, '6', true)?>><?php esc_html_e('6', 'manh');?></option>
                    </select>
                    <p class="description"><?php esc_html_e( 'We are using grid bootstap - 12 cols layout. Default use in Theme Options.','manh' ); ?></p>
                </td>
            </tr>
            <tr class="form-field manh_woo_value_number_cols">
                <th scope="row"><label for="manh_woo_value_number_cols"><?php esc_html_e( 'The numbers value columns', 'manh' ); ?></label></th>
                <td>
                    <input name="manh_woo_value_number_cols" id="manh_woo_value_number_cols" type="text" value="<?php echo esc_attr($manh_woo_value_number_cols);?>" size="40">
                    <p class="description"><?php esc_html_e( 'The numbers value to set product columns per row. Ex: 2/3/4/5','manh' ); ?></p>
                </td>
            </tr>
            <tr class="form-field manh_number_perpage">
                <th scope="row"><label for="manh_number_perpage"><?php esc_html_e( 'Number products per listing page', 'manh' ); ?></label></th>
                <td>
                    <input name="manh_number_perpage" id="manh_number_perpage" type="text" value="<?php echo esc_attr($manh_number_perpage);?>" size="40">
                </td>
            </tr>
            <?php
        }
        // Save term page
        public function manh_save_product_cat_custom_meta($term_id, $tt_id, $taxonomy){
            $fields = array(
                'manh_woo_stickypfilter',
                'manh_showbreadcrump',
                'manh_product_cat_slideshow',
                'manh_content_extrawidth',
                'manh_product_cat_layout',
                'manh_woo_gridstyle',
                'manh_woo_grid_col',
                'manh_woo_value_number_cols',
                'manh_number_perpage'
            );
            foreach ($fields as $field){
                if( isset($_POST[$field]) ){
                    $value = $_POST[$field];
                    update_woocommerce_term_meta($term_id, $field, $value);
                }
            }
        }
        //Add term page for product_attribute
        public function manh_product_attribute_add_new_meta_field(){
            // This will add the custom meta field  to the add new term page
            ?>
            <div class="form-field term-manh_product_attribute_type">
                <label for="manh_product_attribute_type"><?php esc_html_e( 'Type', 'manh' ); ?></label>
                <select name="manh_product_attribute_type" id="manh_product_attribute_type">
                    <option value="text"><?php esc_html_e('Text', 'manh');?></option>
                    <option value="color"><?php esc_html_e('Color Picker', 'manh');?></option>
                </select>
                <p class="description"></p>
            </div>
            <div class="form-field term-manh_product_attribute_color">
                <label for="manh_product_attribute_color"><?php esc_html_e( 'Color Picker', 'manh' ); ?></label>
                <input type="text" class="colorpicker sns-colorpicker" value="" name="manh_product_attribute_color"/>
                <p class="description"></p>
            </div>
            <?php
        }
        // Term attribute js
        function manh_termattr_js(){
            wp_enqueue_script('manh-termattr', MANH_THEME_URI . '/assets/js/sns-woo-termattr.js', array('jquery'), '', true);
        }
        // Edit term page
        public function manh_product_attribute_edit_meta_field($term, $taxonomy){
            $manh_product_attribute_type = manh_get_term_byid($term->term_id, 'manh_product_attribute_type', '');
            $manh_product_attribute_color = manh_get_term_byid($term->term_id, 'manh_product_attribute_color', '');
            ?>
            <tr class="form-field manh_product_attribute_type">
                <th scope="row"><label for="manh_product_attribute_type"><?php esc_html_e( 'Type', 'manh' ); ?></label></th>
                <td>
                    <select name="manh_product_attribute_type" id="manh_product_attribute_type">
                        <option value="text" <?php selected($manh_product_attribute_type, 'text', true)?>><?php esc_html_e('Text', 'manh');?></option>
                        <option value="color" <?php selected($manh_product_attribute_type, 'color', true)?>><?php esc_html_e('Color Picker', 'manh');?></option>
                    </select>
                    <p class="description"></p>
                </td>
            </tr>
            <tr class="form-field term-manh_product_attribute_color">
                <th scope="row"><label for="manh_product_attribute_color"><?php esc_html_e( 'Color Picker', 'manh' ); ?></label></th>
                <td>
                    <input type="text" class="colorpicker sns-colorpicker" value="<?php echo esc_attr( $manh_product_attribute_color );?>" name="manh_product_attribute_color"/>
                    <p class="description"></p>
                </td>
            </tr>
            <?php
        }
        // Save term page
        public function manh_product_attribute_save_custom_meta($term_id, $tt_id, $taxonomy){
            $fields = array(
                'manh_product_attribute_type',
                'manh_product_attribute_color',
                'manh_product_attribute_image_id'
            );
            foreach ($fields as $field){
                if( isset($_POST[$field]) ){
                    $value = !empty($_POST[$field]) ? $_POST[$field] : '';
                    
                    update_woocommerce_term_meta($term_id, $field, $value);
                }
            }
        }
	}
	manh_Woocommerce::getInstance();
}
